/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.workbench.ui.plugin.dataprocessing;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.LayerableComparator;
import com.vividsolutions.jump.workbench.model.RedlineLayer;
import com.vividsolutions.jump.workbench.model.Task;
import com.vividsolutions.jump.workbench.ui.layertree.CategoryNameComboBoxRenderer;
import com.vividsolutions.jump.workbench.ui.layertree.LayerNameComboBoxRenderer;
import com.vividsolutions.jump.workbench.ui.layertree.LayerNameRenderer;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class LayerSelectionPanel
extends JPanel {
    private boolean bolBlockEvents = false;
    private Task task = null;
    private final CategoryNameComboBoxRenderer catRenderer = new CategoryNameComboBoxRenderer();
    private final LayerNameComboBoxRenderer lyRenderer = new LayerNameComboBoxRenderer(LayerNameRenderer.Style.SINGLE_ROW_PREVIEW_RIGHT);
    private Layer lastLayerSelected = null;
    private boolean onlyRedlineLayers = false;
    private final List<ActionListener> actionListeners = new ArrayList<ActionListener>();
    private String featuresVariableName = "features";
    private boolean initFlag = false;
    private JCheckBox cboUseSelection;
    private JComboBox<Category> cmbCat;
    private JComboBox<Layerable> cmbLayer;
    private JScrollPane jScrollPane1;
    private JLabel lblFilter;
    private JTextArea txaFilter;

    public LayerSelectionPanel() {
        this.initComponents();
    }

    private synchronized void initAtFirstTaskUpdate() {
        if (!this.initFlag) {
            this.lyRenderer.setRenderSubCategory(true);
            this.catRenderer.setCheckBoxVisible(false);
            this.cmbCat.setRenderer(this.catRenderer);
            this.cmbLayer.setRenderer(this.lyRenderer);
            this.initFlag = true;
        }
    }

    public void addActionListener(ActionListener actionListener) {
        if (!this.actionListeners.contains(actionListener)) {
            this.actionListeners.add(actionListener);
        }
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionListeners.remove(actionListener);
    }

    private void fireActionPerformed() {
        ActionEvent actionEvent = new ActionEvent(this, 1, "layer changed");
        for (ActionListener actionListener : this.actionListeners) {
            actionListener.actionPerformed(actionEvent);
        }
    }

    public void displayFilterDefinition(boolean useFilter) {
        this.lblFilter.setVisible(useFilter);
        this.txaFilter.setVisible(useFilter);
        this.jScrollPane1.setVisible(useFilter);
    }

    public void displayUseSelection(boolean useSelection) {
        this.cboUseSelection.setVisible(useSelection);
    }

    public void displayOnlyRedlineLayers(boolean onlyRedlineLayers) {
        this.onlyRedlineLayers = onlyRedlineLayers;
    }

    private void fillCats() {
        this.cmbCat.removeAllItems();
        List<Category> lstCats = this.task.getLayerManager().getSubcategories();
        for (Category cat : lstCats) {
            boolean lyFound = false;
            for (Layerable objLy : cat.getAllLayerables()) {
                if (!this.isLayerRelevant(objLy)) continue;
                lyFound = true;
                break;
            }
            if (!lyFound) continue;
            this.cmbCat.addItem(cat);
        }
    }

    public void setTask(Task task) {
        this.bolBlockEvents = true;
        try {
            this.lastLayerSelected = (Layer)this.cmbLayer.getSelectedItem();
            this.task = task;
            this.initAtFirstTaskUpdate();
            this.fillCats();
            this.fillLayers();
            if (this.lastLayerSelected != null) {
                this.selectLayer(this.lastLayerSelected.getKey());
            }
        }
        finally {
            this.bolBlockEvents = false;
        }
        this.fireActionPerformed();
    }

    public String getFeaturesVariableName() {
        return this.featuresVariableName;
    }

    public void setFeaturesVariableName(String featuresVariableName) {
        this.featuresVariableName = featuresVariableName;
    }

    public void resetTaskByWorkbench() {
        this.setTask(WorkbenchContext.getTask());
    }

    public Layer getSelectedLayer() {
        return (Layer)this.cmbLayer.getSelectedItem();
    }

    private void sortLayerables(List<Layerable> lstLy) {
        Layerable[] arrLy = (Layerable[])lstLy.toArray(Layerable[]::new);
        Arrays.sort(arrLy, new LayerableComparator(true));
        lstLy.clear();
        lstLy.addAll(Arrays.asList(arrLy));
    }

    private void fillLayers() {
        this.cmbLayer.removeAllItems();
        if (this.cmbCat.getItemCount() > 0) {
            Category cat = (Category)this.cmbCat.getSelectedItem();
            List<Layerable> lstLy = cat.getAllLayerables();
            this.sortLayerables(lstLy);
            for (Layerable objLy : lstLy) {
                if (!this.isLayerRelevant(objLy)) continue;
                this.cmbLayer.addItem(objLy);
            }
        }
    }

    private boolean isLayerRelevant(Layerable layerable) {
        return this.onlyRedlineLayers ? layerable instanceof RedlineLayer : layerable instanceof Layer;
    }

    public void selectLayer(String layerId) {
        Layer layer = this.task.getLayerManager().getLayerByKey(layerId);
        if (layer != null) {
            Category cat = this.findTopCategoryForLayer(layer);
            this.cmbCat.setSelectedItem(cat);
            this.fillLayers();
            this.cmbLayer.setSelectedItem(layer);
        }
    }

    Category findTopCategoryForLayer(Layer layer) {
        Category cat = layer.getCategory();
        int counter = 0;
        while (cat.getParentCategory() != this.task.getLayerManager().getRootCatBuildIn() && cat.getParentCategory() != this.task.getLayerManager().getRootCatLocal()) {
            cat = cat.getParentCategory();
            if (++counter <= 100) continue;
            return null;
        }
        return cat;
    }

    public String validateInput() {
        if (this.getSelectedLayer() == null) {
            return "Please select a layer. Currently no layer is selected.";
        }
        if (this.cboUseSelection.isSelected() && !WorkbenchContext.getInstance().getSelectionManager().hasSelections(this.getSelectedLayer())) {
            return I18N.get("LayerSelectionPanel.no-selected-items-message");
        }
        return null;
    }

    public String getSelectedLayerId() {
        if (this.getSelectedLayer() == null) {
            throw new IllegalStateException(this.validateInput());
        }
        return this.getSelectedLayer().getKey();
    }

    public String getCqlFilter() {
        return this.txaFilter.getText();
    }

    public void setCqlFilter(String filterText) {
        this.txaFilter.setText(filterText);
    }

    public String getGdbBeanshell() throws IllegalStateException {
        StringBuilder sbBeanshell = new StringBuilder();
        sbBeanshell.append("//Read data from layer\n");
        if (this.cboUseSelection.isSelected()) {
            sbBeanshell.append(String.format("Features %s = readFeaturesFromSelection(\"%s\", \"%s\");", this.featuresVariableName, this.getSelectedLayerId(), this.getCqlFilter()));
        } else {
            sbBeanshell.append(String.format("Features %s = readFeaturesFromLayer(\"%s\", \"%s\");", this.featuresVariableName, this.getSelectedLayerId(), this.getCqlFilter()));
        }
        sbBeanshell.append("\n\n");
        return sbBeanshell.toString();
    }

    public void setUseSelection(boolean useSelection) {
        this.cboUseSelection.setSelected(useSelection);
    }

    private void initComponents() {
        this.cmbCat = new JComboBox();
        this.cmbLayer = new JComboBox();
        this.lblFilter = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.txaFilter = new JTextArea();
        this.cboUseSelection = new JCheckBox();
        this.setLayout(new GridBagLayout());
        this.cmbCat.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayerSelectionPanel.this.cmbCatActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 0, 3, 0);
        this.add(this.cmbCat, gridBagConstraints);
        this.cmbLayer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayerSelectionPanel.this.cmbLayerActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 0, 3, 0);
        this.add(this.cmbLayer, gridBagConstraints);
        ResourceBundle bundle = ResourceBundle.getBundle("language/jump");
        this.lblFilter.setText(bundle.getString("LayerSelectionPanel.lblFilter.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 0, 3, 0);
        this.add((Component)this.lblFilter, gridBagConstraints);
        this.txaFilter.setColumns(20);
        this.txaFilter.setRows(5);
        this.jScrollPane1.setViewportView(this.txaFilter);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 0, 3, 0);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.cboUseSelection.setText(bundle.getString("LayerSelectionPanel.cboUseSelection.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 0, 3, 0);
        this.add((Component)this.cboUseSelection, gridBagConstraints);
    }

    private void cmbCatActionPerformed(ActionEvent evt) {
        if (this.bolBlockEvents) {
            return;
        }
        this.bolBlockEvents = true;
        try {
            this.fillLayers();
        }
        finally {
            this.bolBlockEvents = false;
        }
        this.fireActionPerformed();
    }

    private void cmbLayerActionPerformed(ActionEvent evt) {
        if (this.bolBlockEvents) {
            return;
        }
        this.fireActionPerformed();
    }
}

