/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.workbench.ui.plugin.dataprocessing;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import de.riwagis.riwajump.workbench.ui.plugin.dataprocessing.ExecuteGeoDataProcessingPanel;
import de.riwagis.riwajump.workbench.ui.plugin.dataprocessing.GdpDialog;
import de.riwagis.riwajump.workbench.ui.plugin.dataprocessing.LayerSelectionPanel;
import de.riwagis.riwajump.workbench.ui.plugin.dataprocessing.TargetPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class IntersectDialog
extends JDialog
implements GdpDialog {
    private final PlugInContext context;
    private JComboBox<String> cmbIntersectionType;
    private ExecuteGeoDataProcessingPanel executeGeoDataProcessingPanel;
    private JPanel intersectPanel;
    private JPanel pnlSelect;
    private LayerSelectionPanel sourcePanel1;
    private LayerSelectionPanel sourcePanel2;
    private TargetPanel targetPanel;

    public IntersectDialog(PlugInContext context) {
        super((Frame)context.getWorkbenchFrame(), false);
        this.context = context;
        this.initComponents();
        this.i18n();
        this.init();
    }

    private void i18n() {
        this.cmbIntersectionType.removeAllItems();
        this.cmbIntersectionType.addItem(I18N.get("IntersectDialog.cmbIntersectionType.intersection"));
        this.cmbIntersectionType.addItem(I18N.get("IntersectDialog.cmbIntersectionType.contains"));
    }

    private void init() {
        this.sourcePanel1.resetTaskByWorkbench();
        this.sourcePanel1.setFeaturesVariableName("sourceFeatures");
        this.sourcePanel2.resetTaskByWorkbench();
        this.sourcePanel2.setFeaturesVariableName("intersectionFeatures");
        this.executeGeoDataProcessingPanel.setGdpDialog(this);
        this.cmbIntersectionType.setSelectedIndex(0);
    }

    private void initComponents() {
        this.intersectPanel = new JPanel();
        this.cmbIntersectionType = new JComboBox();
        this.targetPanel = new TargetPanel();
        this.executeGeoDataProcessingPanel = new ExecuteGeoDataProcessingPanel();
        this.pnlSelect = new JPanel();
        this.sourcePanel1 = new LayerSelectionPanel();
        this.sourcePanel2 = new LayerSelectionPanel();
        ResourceBundle bundle = ResourceBundle.getBundle("language/jump");
        this.setTitle(bundle.getString("IntersectDialog.title"));
        this.setMinimumSize(new Dimension(550, 550));
        this.setPreferredSize(new Dimension(550, 550));
        this.setSize(new Dimension(550, 550));
        this.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent evt) {
                IntersectDialog.this.formWindowGainedFocus(evt);
            }

            @Override
            public void windowLostFocus(WindowEvent evt) {
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.intersectPanel.setBorder(BorderFactory.createTitledBorder(bundle.getString("IntersectDialog.intersectPanel.border.title")));
        this.intersectPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.intersectPanel.add(this.cmbIntersectionType, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.intersectPanel, gridBagConstraints);
        this.targetPanel.setBorder(BorderFactory.createTitledBorder(bundle.getString("IntersectDialog.targetPanel.border.title")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 25;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.targetPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 20;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.executeGeoDataProcessingPanel, gridBagConstraints);
        this.pnlSelect.setLayout(new GridLayout(1, 2, 2, 0));
        this.sourcePanel1.setBorder(BorderFactory.createTitledBorder(bundle.getString("IntersectDialog.sourcePanel1.border.title")));
        this.sourcePanel1.setMinimumSize(new Dimension(270, 230));
        this.sourcePanel1.setName("sourcePanel1");
        this.sourcePanel1.setPreferredSize(new Dimension(250, 219));
        this.pnlSelect.add(this.sourcePanel1);
        this.sourcePanel2.setBorder(BorderFactory.createTitledBorder(bundle.getString("IntersectDialog.sourcePanel2.border.title")));
        this.sourcePanel2.setMinimumSize(new Dimension(270, 230));
        this.sourcePanel2.setPreferredSize(new Dimension(250, 219));
        this.pnlSelect.add(this.sourcePanel2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.pnlSelect, gridBagConstraints);
        this.pack();
    }

    private void formWindowGainedFocus(WindowEvent evt) {
        this.sourcePanel1.resetTaskByWorkbench();
        this.sourcePanel2.resetTaskByWorkbench();
        this.targetPanel.resetTaskByWorkbench();
    }

    @Override
    public String getGdpBeanshell() {
        StringBuilder sbBeanshell = new StringBuilder();
        sbBeanshell.append(this.sourcePanel1.getGdbBeanshell());
        sbBeanshell.append(this.sourcePanel2.getGdbBeanshell());
        sbBeanshell.append("//Intersect features\n");
        sbBeanshell.append(String.format("Features features = intersectFeatureGeometries(sourceFeatures, intersectionFeatures, %s);", this.getIntersectionTypeText()));
        sbBeanshell.append("\n\n");
        sbBeanshell.append(this.targetPanel.getGdbBeanshell());
        return sbBeanshell.toString();
    }

    @Override
    public void closeDialog() {
        this.setVisible(false);
    }

    @Override
    public String validateInput() {
        StringBuilder sbErrors = new StringBuilder();
        if (this.sourcePanel1.validateInput() != null) {
            sbErrors.append(this.sourcePanel1.validateInput()).append("\n");
        }
        if (this.sourcePanel2.validateInput() != null) {
            sbErrors.append(this.sourcePanel2.validateInput()).append("\n");
        }
        if (this.targetPanel.validateInput() != null) {
            sbErrors.append(this.targetPanel.validateInput()).append("\n");
        }
        if (sbErrors.isEmpty()) {
            return null;
        }
        return sbErrors.toString();
    }

    @Override
    public String getOperationName() {
        return "Intersect";
    }

    @Override
    public PlugInContext getPlugInContext() {
        return this.context;
    }

    private String getIntersectionTypeText() {
        switch (this.cmbIntersectionType.getSelectedIndex()) {
            case 0: {
                return "IntersectOperation.ON_INTERSECTION";
            }
            case 1: {
                return "IntersectOperation.ON_CONTAIN";
            }
        }
        throw new IllegalStateException("Should never reach here. Invalid intersection type.");
    }
}

