/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.workbench.ui.plugin.dataprocessing;

import bsh.EvalError;
import bsh.Interpreter;
import bsh.ParseException;
import bsh.Parser;
import de.riwagis.riwajump.workbench.ui.plugin.dataprocessing.GeoDataProcessingWorkflow;
import de.riwagis.riwajump.workbench.ui.plugin.dataprocessing.dsl.AttributeConfiguration;
import de.riwagis.riwajump.workbench.ui.plugin.dataprocessing.dsl.AttributeType;
import de.riwagis.riwajump.workbench.ui.plugin.dataprocessing.dsl.ComparisonOperation;
import de.riwagis.riwajump.workbench.ui.plugin.dataprocessing.dsl.EndCapStyle;
import de.riwagis.riwajump.workbench.ui.plugin.dataprocessing.dsl.Features;
import de.riwagis.riwajump.workbench.ui.plugin.dataprocessing.dsl.FilterIntersectOperation;
import de.riwagis.riwajump.workbench.ui.plugin.dataprocessing.dsl.GroupingFunction;
import de.riwagis.riwajump.workbench.ui.plugin.dataprocessing.dsl.IntersectOperation;
import de.riwagis.riwajump.workbench.ui.plugin.dataprocessing.dsl.JoinStyle;
import de.riwagis.riwajump.workbench.ui.plugin.dataprocessing.dsl.MergeOperation;
import de.riwagis.riwajump.workbench.ui.plugin.dataprocessing.dsl.Methods;
import de.riwagis.riwajump.workbench.ui.plugin.dataprocessing.dsl.WriteOption;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.fife.rsta.ac.java.BeanShellCompletionMetadata;

class GeoDataProcessingWorkflowExecutor {
    private static final List<Class<?>> IMPORT_STATIC_METHODS = List.of(Methods.class);
    private static final List<Class<?>> IMPORT_CLASSES = List.of(Features.class, WriteOption.class, EndCapStyle.class, JoinStyle.class, MergeOperation.class, AttributeConfiguration.class, GroupingFunction.class, ComparisonOperation.class, IntersectOperation.class, AttributeType.class, FilterIntersectOperation.class);
    private static final List<Class<?>> IMPORT_JAVA_DEFAULT_CLASSES = List.of(String.class, Iterable.class, Math.class);

    GeoDataProcessingWorkflowExecutor() {
    }

    public void validate(GeoDataProcessingWorkflow workflow) throws ParseException {
        this.validateCode(workflow.getCode());
    }

    private void validateCode(String code) throws ParseException {
        try (StringReader stringReader = new StringReader(code);){
            Parser parser = new Parser((Reader)stringReader);
            while (!parser.Line()) {
                parser.popNode();
            }
        }
    }

    public void execute(GeoDataProcessingWorkflow workflow) throws EvalError {
        try (StringReader stringReader = new StringReader(workflow.getCode());){
            Interpreter i = new Interpreter();
            for (Class<?> clazz : IMPORT_STATIC_METHODS) {
                i.eval(GeoDataProcessingWorkflowExecutor.importAllClassMethods(clazz));
            }
            for (Class<?> clazz : IMPORT_CLASSES) {
                i.eval(GeoDataProcessingWorkflowExecutor.importClass(clazz));
            }
            i.eval((Reader)stringReader);
        }
    }

    BeanShellCompletionMetadata createCompletionMetadata() {
        BeanShellCompletionMetadata metaData = new BeanShellCompletionMetadata();
        metaData.setClassHeader(this.getJavaCompatibleClassHeader());
        metaData.setClassFooter(this.getJavaCompatibleClassFooter());
        metaData.setClassImports(this.getClassImports());
        metaData.setMethodBlacklist(Set.of("execute", "setLogger", "setupContext", "<clinit>"));
        metaData.setClassBlacklist(Set.of(Methods.class.getCanonicalName()));
        metaData.setCodeValidator(this::validateCode);
        return metaData;
    }

    private String getJavaCompatibleClassHeader() {
        StringBuilder builder = new StringBuilder();
        builder.append("package ").append(Methods.class.getPackageName()).append(";");
        for (Class<?> clazz : IMPORT_STATIC_METHODS) {
            builder.append(GeoDataProcessingWorkflowExecutor.importClass(clazz));
        }
        for (Class<?> clazz : IMPORT_CLASSES) {
            builder.append(GeoDataProcessingWorkflowExecutor.importClass(clazz));
        }
        builder.append("public class Workflow extends Methods {").append("public static void execute() throws Exception {\n");
        return builder.toString();
    }

    private String getJavaCompatibleClassFooter() {
        return "\n}}";
    }

    private List<Class<?>> getClassImports() {
        ArrayList imports = new ArrayList(IMPORT_STATIC_METHODS);
        imports.addAll(IMPORT_JAVA_DEFAULT_CLASSES);
        imports.addAll(IMPORT_CLASSES);
        return imports;
    }

    private static String importClass(Class<?> clazz) {
        return "import %s;".formatted(clazz.getCanonicalName());
    }

    private static String importAllClassMethods(Class<?> clazz) {
        return "static import %s.*;".formatted(clazz.getCanonicalName());
    }
}

