/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.workbench.ui.plugin.dataprocessing;

import bsh.EvalError;
import bsh.ParseException;
import bsh.TargetError;
import com.formdev.flatlaf.ui.FlatBorder;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.Task;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.WindowVisibleKeeper;
import com.vividsolutions.jump.workbench.ui.WorkbenchFrame;
import com.vividsolutions.jump.workbench.ui.components.TitledPopupMenu;
import com.vividsolutions.jump.workbench.ui.layertree.LayerTree;
import com.vividsolutions.jump.workbench.ui.layertree.LayerTreeModel;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import de.riwagis.guitools.Tasks;
import de.riwagis.icons.IconLoader;
import de.riwagis.riwajump.data.gui.FeatureTypeTable;
import de.riwagis.riwajump.data.gui.FeatureTypeTableModel;
import de.riwagis.riwajump.workbench.ui.plugin.dataprocessing.CodeTemplate;
import de.riwagis.riwajump.workbench.ui.plugin.dataprocessing.GenerateCodeInsertionPlugIn;
import de.riwagis.riwajump.workbench.ui.plugin.dataprocessing.GeoDataProcessingWorkflow;
import de.riwagis.riwajump.workbench.ui.plugin.dataprocessing.GeoDataProcessingWorkflowDao;
import de.riwagis.riwajump.workbench.ui.plugin.dataprocessing.GeoDataProcessingWorkflowExecutor;
import de.riwagis.riwajump.workbench.ui.plugin.dataprocessing.HighlightErrorsAndNotifyBindingListener;
import de.riwagis.riwajump.workbench.ui.plugin.dataprocessing.NotBlankValidator;
import de.riwagis.riwajump.workbench.ui.plugin.dataprocessing.dsl.Methods;
import de.riwagis.util.gui.GUISupport;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.text.DateFormat;
import java.util.Date;
import java.util.Objects;
import javax.swing.DefaultButtonModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;
import javax.swing.tree.TreePath;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.fife.rsta.ac.java.BeanShellLanguageSupport;
import org.fife.ui.rsyntaxtextarea.ErrorStrip;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.jdesktop.beansbinding.AbstractBindingListener;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.BindingListener;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.beansbinding.Validator;
import org.opengis.feature.simple.SimpleFeatureType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoDataProcessingEditorDialog
extends JFrame {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GeoDataProcessingEditorDialog.class);
    private static final SimpleFeatureType FEATURETYPE_EMPTY = GeoDataProcessingEditorDialog.createEmptyFeatureType();
    private static final int ICON_COLUMN_INDEX = 0;
    private static final int DATE_COLUMN_INDEX = 1;
    private static final int MESSAGE_COLUMN_INDEX = 2;
    private static final int DETAILS_COLUMN_INDEX = 3;
    private static final String KEY_LASTUSEDFILE = GeoDataProcessingEditorDialog.class.getName() + "_LASTUSEDFILE";
    private static final String FILE_EXTENSION = "gdp";
    private GeoDataProcessingWorkflow workflow = this.createNewWorkflow();
    private boolean unsavedChanges = false;
    private boolean formValid = true;
    private final GeoDataProcessingWorkflowExecutor workflowExecutor = new GeoDataProcessingWorkflowExecutor();
    private final GeoDataProcessingWorkflowDao workflowDao = new GeoDataProcessingWorkflowDao();
    private final FileFilter workflowFileFilter = GUISupport.createFileFilter((String)I18N.get("geodata-processing-file"), (String[])new String[]{"gdp"});
    private File currentFile = null;
    private SimpleFeatureType currentFeatureType = FEATURETYPE_EMPTY;
    private final PlugInContext context;
    private final TitledPopupMenu layerTreePopupMenu = new TitledPopupMenu();
    private JButton butClose;
    private JButton butExecute;
    private JButton butLoad;
    private JButton butNew;
    private JButton butSave;
    private JButton butSaveAs;
    private JComboBox<CodeTemplate> cbTemplates;
    private JTree layerTree;
    private JLabel lblDescription;
    private JLabel lblName;
    private JLabel lblTemplates;
    private JPanel pnaBottom;
    private JPanel pnlCodeAndTemplates;
    private JPanel pnlCodeEditor;
    private JPanel pnlSidebar;
    private JScrollPane scpDescription;
    private JScrollPane scpLayerAttributes;
    private JScrollPane scpLayerTree;
    private JScrollPane spCodeEditor;
    private JScrollPane spLog;
    private JSplitPane spaCodeAndLog;
    private JSplitPane spaLayerTreeAndAttributes;
    private JSplitPane spaMain;
    private JSplitPane spaSideBarAndLayer;
    private RSyntaxTextArea staCodeEditor;
    private JTextArea taDescription;
    private JTable tblLayerAttributes;
    private JTable tblLog;
    private JTextField tfName;
    private JToolBar toolBar;

    public GeoDataProcessingEditorDialog(PlugInContext context) {
        this.context = context;
        BeanShellLanguageSupport.initialSetup();
        this.initComponents();
        this.setupFrame();
        this.bindModel();
    }

    private void setupFrame() {
        WorkbenchFrame parentFrame = this.context.getWorkbenchFrame();
        if (parentFrame != null) {
            this.setIconImages(parentFrame.getIconImages());
        }
        WindowVisibleKeeper.keepFrameVisibleOnDeviceChanges(this);
        this.getRootPane().setDefaultButton(this.butExecute);
        this.setupTemplates();
        this.setupCodeEditor();
        this.setupLogTable();
        this.setupLayerTree();
        this.setupFeatureTypeTable();
    }

    private void setupTemplates() {
        ((DefaultComboBoxModel)this.cbTemplates.getModel()).addAll(CodeTemplate.TEMPLATES);
        this.cbTemplates.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                CodeTemplate template = (CodeTemplate)value;
                if (template == null) {
                    return super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                }
                Component comp = super.getListCellRendererComponent(list, template.getDisplayedText(), index, isSelected, cellHasFocus);
                if (template.isHeader()) {
                    comp.setBackground(new Color(61, 61, 61));
                    comp.setForeground(Color.WHITE);
                    comp.setFont(this.getFont().deriveFont(1));
                }
                return comp;
            }
        });
    }

    private void setupLayerTree() {
        LayerTree tree = (LayerTree)this.layerTree;
        this.updateLayerTreeModel(this.context.getTask());
        tree.getSelectionModel().setSelectionMode(1);
        tree.getSelectionModel().addTreeSelectionListener(tse -> {
            Object lastPathComponent = tse.getPath().getLastPathComponent();
            if (lastPathComponent instanceof Layer) {
                Layer layer = (Layer)lastPathComponent;
                this.currentFeatureType = layer.getFeatureType();
            } else {
                this.currentFeatureType = FEATURETYPE_EMPTY;
            }
            FeatureTypeTable tbl = (FeatureTypeTable)this.tblLayerAttributes;
            tbl.setFeatureType(this.currentFeatureType);
        });
        this.context.getWorkbenchFrame().addTaskFrameChangedListener(taskFrame -> {
            tree.getSelectionModel().clearSelection();
            this.updateLayerTreeModel(taskFrame.getTask());
        });
        this.registerCodeInsertions();
    }

    private void registerCodeInsertions() {
        GenerateCodeInsertionPlugIn readFeaturesFromLayerPlugIn = new GenerateCodeInsertionPlugIn(this, "readFeaturesFromLayer");
        GenerateCodeInsertionPlugIn readFeaturesFromSelectionPlugIn = new GenerateCodeInsertionPlugIn(this, "readFeaturesFromSelection");
        GenerateCodeInsertionPlugIn writeFeaturesToLayerPlugIn = new GenerateCodeInsertionPlugIn(this, "writeFeaturesToLayer", l -> {
            if (l.isEditable()) {
                return null;
            }
            return I18N.get("layer-is-not-editable");
        });
        this.context.getFeatureInstaller().addPopupMenuItem(this.layerTreePopupMenu, readFeaturesFromLayerPlugIn).addPopupMenuItem(this.layerTreePopupMenu, readFeaturesFromSelectionPlugIn).addPopupMenuItem(this.layerTreePopupMenu, writeFeaturesToLayerPlugIn);
    }

    RSyntaxTextArea getCodeEditor() {
        return this.staCodeEditor;
    }

    Layer getSelectedLayerFromTree() {
        Object selectedElement = this.layerTree.getSelectionModel().getSelectionPath().getLastPathComponent();
        if (selectedElement instanceof Layer) {
            Layer layer = (Layer)selectedElement;
            return layer;
        }
        throw new IllegalStateException("There is no layer selected in tree.");
    }

    private void setupFeatureTypeTable() {
        FeatureTypeTable tbl = (FeatureTypeTable)this.tblLayerAttributes;
        FeatureTypeTableModel attributeModel = (FeatureTypeTableModel)tbl.getModel();
        attributeModel.setEditable(false);
        attributeModel.setAttributTypesEditable(false);
    }

    private static SimpleFeatureType createEmptyFeatureType() {
        SimpleFeatureTypeBuilder ftBuilder = new SimpleFeatureTypeBuilder();
        ftBuilder.setName("DUMMY");
        return ftBuilder.buildFeatureType();
    }

    private void updateLayerTreeModel(Task task) {
        LayerTree tree = (LayerTree)this.layerTree;
        task.getLayerManager().removeLayerListener(tree);
        LayerTreeModel layerTreeModel = new LayerTreeModel(task);
        layerTreeModel.addListFilter(element -> {
            if (element instanceof Category) {
                return true;
            }
            return element instanceof Layer;
        });
        this.layerTree.setModel(layerTreeModel);
        task.getLayerManager().addLayerListener(tree);
    }

    private void setupLogTable() {
        final TableColumnModel columnModel = this.tblLog.getColumnModel();
        columnModel.getColumn(0).setMinWidth(30);
        columnModel.getColumn(0).setMaxWidth(30);
        columnModel.getColumn(0).setResizable(false);
        columnModel.getColumn(1).setMinWidth(130);
        columnModel.getColumn(1).setMaxWidth(130);
        columnModel.getColumn(1).setResizable(false);
        columnModel.getColumn(3).setMinWidth(20);
        columnModel.getColumn(3).setMaxWidth(20);
        columnModel.getColumn(3).setResizable(false);
        columnModel.getColumn(3).setCellRenderer(new ShowDetailsCellRenderer());
        this.tblLog.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e) && 3 == columnModel.getColumnIndexAtX(e.getX())) {
                    String message = Objects.toString(GeoDataProcessingEditorDialog.this.tblLog.getModel().getValueAt(GeoDataProcessingEditorDialog.this.tblLog.getSelectedRow(), 3));
                    GeoDataProcessingEditorDialog.this.showLogDetailWindow(message);
                }
            }
        });
        this.tblLog.getTableHeader().setResizingColumn(columnModel.getColumn(2));
    }

    private void setupCodeEditor() {
        BeanShellLanguageSupport.register(this.staCodeEditor, this.workflowExecutor.createCompletionMetadata());
        this.pnlCodeEditor.add((Component)new ErrorStrip(this.staCodeEditor), "After");
        RTextScrollPane tsp = (RTextScrollPane)this.spCodeEditor;
        tsp.setLineNumbersEnabled(true);
        tsp.setFoldIndicatorEnabled(true);
        tsp.setIconRowHeaderEnabled(true);
        this.pnlCodeEditor.putClientProperty("JComponent.focusOwner", c -> this.staCodeEditor.hasFocus());
        this.staCodeEditor.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent de) {
                this.updateCodeBindingOnUndoOrRedo(de);
            }

            @Override
            public void removeUpdate(DocumentEvent de) {
                this.updateCodeBindingOnUndoOrRedo(de);
            }

            @Override
            public void changedUpdate(DocumentEvent de) {
                this.updateCodeBindingOnUndoOrRedo(de);
            }

            private void updateCodeBindingOnUndoOrRedo(DocumentEvent de) {
                if ("UndoRedoDocumentEvent".equals(de.getClass().getSimpleName())) {
                    SwingUtilities.invokeLater(() -> {
                        DocumentFilter documentFilter = ((AbstractDocument)GeoDataProcessingEditorDialog.this.staCodeEditor.getDocument()).getDocumentFilter();
                        ((ActionListener)((Object)documentFilter)).actionPerformed(null);
                    });
                }
            }
        });
    }

    private void bindModel() {
        AutoBinding nameBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)BeanProperty.create((String)"workflow.name"), (Object)this.tfName, (Property)BeanProperty.create((String)"text"));
        AutoBinding descriptionBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)BeanProperty.create((String)"workflow.description"), (Object)this.taDescription, (Property)BeanProperty.create((String)"text"));
        AutoBinding codeBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)BeanProperty.create((String)"workflow.code"), (Object)this.staCodeEditor, (Property)BeanProperty.create((String)"text"));
        nameBinding.setValidator((Validator)new NotBlankValidator());
        BindingGroup bindingGroup = new BindingGroup();
        bindingGroup.addBinding((Binding)nameBinding);
        bindingGroup.addBinding((Binding)descriptionBinding);
        bindingGroup.addBinding((Binding)codeBinding);
        bindingGroup.addBindingListener((BindingListener)new HighlightErrorsAndNotifyBindingListener(this::setFormValid));
        bindingGroup.addBindingListener((BindingListener)new AbstractBindingListener(){

            public void synced(Binding binding) {
                GeoDataProcessingEditorDialog.this.setUnsavedChanges(true);
            }
        });
        bindingGroup.bind();
        AutoBinding saveBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this, (Property)ELProperty.create((String)"${unsavedChanges && formValid}"), (Object)this.butSave, (Property)BeanProperty.create((String)"enabled"));
        AutoBinding saveAsBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this, (Property)BeanProperty.create((String)"formValid"), (Object)this.butSaveAs, (Property)BeanProperty.create((String)"enabled"));
        saveBinding.bind();
        saveAsBinding.bind();
        this.setUnsavedChanges(false);
    }

    public void setWorkflow(GeoDataProcessingWorkflow workflow) {
        GeoDataProcessingWorkflow oldWorkflow = this.workflow;
        this.workflow = workflow;
        this.firePropertyChange("workflow", oldWorkflow, workflow);
        this.staCodeEditor.discardAllEdits();
        this.setUnsavedChanges(false);
        this.currentFile = null;
    }

    public GeoDataProcessingWorkflow getWorkflow() {
        return this.workflow;
    }

    private GeoDataProcessingWorkflow createNewWorkflow() {
        GeoDataProcessingWorkflow newWorkflow = new GeoDataProcessingWorkflow();
        newWorkflow.setName(I18N.get("new-workflow"));
        return newWorkflow;
    }

    public boolean isUnsavedChanges() {
        return this.unsavedChanges;
    }

    public void setUnsavedChanges(boolean unsavedChanges) {
        boolean oldUnsavedChanges = this.unsavedChanges;
        this.unsavedChanges = unsavedChanges;
        this.firePropertyChange("unsavedChanges", oldUnsavedChanges, unsavedChanges);
    }

    public boolean isFormValid() {
        return this.formValid;
    }

    public void setFormValid(boolean formValid) {
        boolean oldFormValid = this.formValid;
        this.formValid = formValid;
        this.firePropertyChange("formValid", oldFormValid, formValid);
    }

    private File getLastUsedFile() {
        String lastUsedFile = (String)PersistentBlackboardPlugIn.get().get(KEY_LASTUSEDFILE);
        if (lastUsedFile == null) {
            return null;
        }
        return new File(lastUsedFile);
    }

    private void setLastUsedFile(File file) {
        PersistentBlackboardPlugIn.get().put(KEY_LASTUSEDFILE, file.getAbsolutePath());
    }

    private void jumpToLine(int errorLine) {
        SwingUtilities.invokeLater(() -> {
            try {
                this.staCodeEditor.setCaretPosition(this.staCodeEditor.getLineStartOffset(errorLine - 1));
                this.staCodeEditor.requestFocusInWindow();
            }
            catch (BadLocationException ex) {
                log.warn("Reported error line does not seem to exist", (Object)errorLine);
            }
        });
    }

    private void logMessage(LogMessageType type, String message) {
        Date now = new Date();
        SwingUtilities.invokeLater(() -> {
            DefaultTableModel model = (DefaultTableModel)this.tblLog.getModel();
            model.addRow(new Object[]{type, now, message.split("\\R", 2)[0], StringUtils.abbreviate((String)message, (String)"...", (int)100000)});
            int lastRowIndex = model.getRowCount() - 1;
            this.tblLog.scrollRectToVisible(this.tblLog.getCellRect(lastRowIndex, 0, true));
            this.tblLog.setRowSelectionInterval(lastRowIndex, lastRowIndex);
        });
    }

    private void showAndJumpToError(String message, EvalError ex) {
        this.logMessage(LogMessageType.ERROR, I18N.getMessage("workflow-exited-with-error", message.trim()));
        this.jumpToLine(ex.getErrorLineNumber());
    }

    private void showLogDetailWindow(String message) {
        JTextArea txaMessage = new JTextArea();
        txaMessage.setColumns(30);
        txaMessage.setRows(10);
        txaMessage.setLineWrap(true);
        txaMessage.setWrapStyleWord(true);
        txaMessage.setSize(txaMessage.getPreferredSize().width, txaMessage.getPreferredSize().height);
        txaMessage.setEditable(false);
        JScrollPane spMessage = new JScrollPane(txaMessage);
        JDialog detailDialog = new JDialog(this, I18N.get("common.message"), true);
        JOptionPane optionPane = new JOptionPane();
        optionPane.setMessageType(-1);
        optionPane.setOptionType(-1);
        optionPane.setMessage(new Object[]{spMessage});
        optionPane.addPropertyChangeListener(evt -> {
            if (evt.getSource() == optionPane && Objects.equals(evt.getNewValue(), 0)) {
                detailDialog.setVisible(false);
                detailDialog.dispose();
            }
        });
        detailDialog.setContentPane(optionPane);
        detailDialog.setDefaultCloseOperation(2);
        detailDialog.pack();
        txaMessage.setText(message);
        detailDialog.setLocationRelativeTo(this.tblLog);
        detailDialog.setVisible(true);
    }

    private void initComponents() {
        this.toolBar = new JToolBar();
        this.butNew = new JButton();
        this.butLoad = new JButton();
        this.butSave = new JButton();
        this.butSaveAs = new JButton();
        this.spaMain = new JSplitPane();
        this.spaSideBarAndLayer = new JSplitPane();
        this.pnlSidebar = new JPanel();
        this.lblName = new JLabel();
        this.tfName = new JTextField();
        this.lblDescription = new JLabel();
        this.scpDescription = new JScrollPane();
        this.taDescription = new JTextArea();
        this.spaLayerTreeAndAttributes = new JSplitPane();
        this.scpLayerTree = new JScrollPane();
        this.layerTree = new LayerTree(this.scpLayerTree, this.context, null, false, false, false);
        this.scpLayerAttributes = new JScrollPane();
        this.tblLayerAttributes = new FeatureTypeTable(this.currentFeatureType, true);
        this.spaCodeAndLog = new JSplitPane();
        this.pnlCodeAndTemplates = new JPanel();
        this.lblTemplates = new JLabel();
        this.cbTemplates = new JComboBox();
        this.pnlCodeEditor = new JPanel();
        this.spCodeEditor = new RTextScrollPane();
        this.staCodeEditor = new RSyntaxTextArea();
        this.spLog = new JScrollPane();
        this.tblLog = new JTable();
        this.pnaBottom = new JPanel();
        this.butClose = new JButton();
        this.butExecute = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle(I18N.get("geodata-processing"));
        this.getContentPane().setLayout(new GridBagLayout());
        this.toolBar.setRollover(true);
        this.butNew.setIcon(IconLoader.svgIcon((String)"file_new.svg"));
        this.butNew.setToolTipText(I18N.get("new-workflow"));
        this.butNew.addActionListener(this::butNewActionPerformed);
        this.toolBar.add(this.butNew);
        this.butLoad.setIcon(IconLoader.svgIcon((String)"file_open.svg"));
        this.butLoad.setToolTipText(I18N.get("load-workflow"));
        this.butLoad.setHorizontalTextPosition(0);
        this.butLoad.setVerticalTextPosition(3);
        this.butLoad.addActionListener(this::butLoadActionPerformed);
        this.toolBar.add(this.butLoad);
        this.butSave.setIcon(IconLoader.svgIcon((String)"common_save.svg"));
        this.butSave.setToolTipText(I18N.get("save-workflow"));
        this.butSave.setHorizontalTextPosition(0);
        this.butSave.setVerticalTextPosition(3);
        this.butSave.addActionListener(this::butSaveActionPerformed);
        this.toolBar.add(this.butSave);
        this.butSaveAs.setIcon(IconLoader.svgIcon((String)"saveas.svg"));
        this.butSaveAs.setToolTipText(I18N.get("save-workflow-as"));
        this.butSaveAs.addActionListener(this::butSaveAsActionPerformed);
        this.toolBar.add(this.butSaveAs);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.toolBar, gridBagConstraints);
        this.spaSideBarAndLayer.setDividerLocation(200);
        this.spaSideBarAndLayer.setOrientation(0);
        this.pnlSidebar.setLayout(new GridBagLayout());
        this.lblName.setText(I18N.get("label-name"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 0, 3, 0);
        this.pnlSidebar.add((Component)this.lblName, gridBagConstraints);
        this.tfName.setColumns(20);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 0, 3, 0);
        this.pnlSidebar.add((Component)this.tfName, gridBagConstraints);
        this.lblDescription.setText(I18N.get("label-description"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 0, 3, 0);
        this.pnlSidebar.add((Component)this.lblDescription, gridBagConstraints);
        this.scpDescription.setMinimumSize(new Dimension(120, 60));
        this.taDescription.setLineWrap(true);
        this.scpDescription.setViewportView(this.taDescription);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 0, 0, 0);
        this.pnlSidebar.add((Component)this.scpDescription, gridBagConstraints);
        this.spaSideBarAndLayer.setLeftComponent(this.pnlSidebar);
        this.spaLayerTreeAndAttributes.setOrientation(0);
        this.spaLayerTreeAndAttributes.setResizeWeight(1.0);
        this.scpLayerTree.setMinimumSize(new Dimension(120, 120));
        this.scpLayerTree.setPreferredSize(new Dimension(120, 120));
        this.layerTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                GeoDataProcessingEditorDialog.this.layerTreeMousePressed(evt);
            }
        });
        this.scpLayerTree.setViewportView(this.layerTree);
        this.spaLayerTreeAndAttributes.setLeftComponent(this.scpLayerTree);
        this.scpLayerAttributes.setMinimumSize(new Dimension(120, 120));
        this.scpLayerAttributes.setPreferredSize(new Dimension(120, 120));
        this.tblLayerAttributes.getTableHeader().setResizingAllowed(false);
        this.tblLayerAttributes.getTableHeader().setReorderingAllowed(false);
        this.scpLayerAttributes.setViewportView(this.tblLayerAttributes);
        this.spaLayerTreeAndAttributes.setRightComponent(this.scpLayerAttributes);
        this.spaSideBarAndLayer.setBottomComponent(this.spaLayerTreeAndAttributes);
        this.spaMain.setLeftComponent(this.spaSideBarAndLayer);
        this.spaCodeAndLog.setOrientation(0);
        this.spaCodeAndLog.setResizeWeight(1.0);
        this.pnlCodeAndTemplates.setLayout(new GridBagLayout());
        this.lblTemplates.setText(I18N.get("label-template"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 5, 6);
        this.pnlCodeAndTemplates.add((Component)this.lblTemplates, gridBagConstraints);
        this.cbTemplates.setSelectedItem(null);
        this.cbTemplates.setMinimumSize(new Dimension(300, 22));
        this.cbTemplates.setPreferredSize(new Dimension(300, 22));
        this.cbTemplates.addActionListener(this::cbTemplatesActionPerformed);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.pnlCodeAndTemplates.add(this.cbTemplates, gridBagConstraints);
        this.pnlCodeEditor.setBorder((Border)new FlatBorder());
        this.pnlCodeEditor.setLayout(new BorderLayout());
        this.spCodeEditor.setBorder(null);
        this.staCodeEditor.setColumns(40);
        this.staCodeEditor.setRows(20);
        this.staCodeEditor.setCodeFoldingEnabled(true);
        this.staCodeEditor.setFadeCurrentLineHighlight(true);
        this.staCodeEditor.setMarginLineEnabled(true);
        this.staCodeEditor.setMarkOccurrences(true);
        this.staCodeEditor.setPaintTabLines(true);
        this.staCodeEditor.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                GeoDataProcessingEditorDialog.this.staCodeEditorFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                GeoDataProcessingEditorDialog.this.staCodeEditorFocusLost(evt);
            }
        });
        this.spCodeEditor.setViewportView((Component)this.staCodeEditor);
        this.pnlCodeEditor.add((Component)this.spCodeEditor, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.pnlCodeAndTemplates.add((Component)this.pnlCodeEditor, gridBagConstraints);
        this.spaCodeAndLog.setTopComponent(this.pnlCodeAndTemplates);
        this.spLog.setMinimumSize(new Dimension(100, 100));
        this.spLog.setPreferredSize(new Dimension(100, 100));
        this.tblLog.setModel(new DefaultTableModel(new Object[0][], new String[]{"", "Datum", "Beschreibung", ""}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Object.class, Object.class, String.class, String.class};
                this.canEdit = new boolean[]{false, false, false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.tblLog.setAutoResizeMode(3);
        this.tblLog.getTableHeader().setReorderingAllowed(false);
        this.spLog.setViewportView(this.tblLog);
        if (this.tblLog.getColumnModel().getColumnCount() > 0) {
            this.tblLog.getColumnModel().getColumn(0).setCellRenderer(new MessageTypeTableCellRenderer());
            this.tblLog.getColumnModel().getColumn(1).setHeaderValue(I18N.get("date"));
            this.tblLog.getColumnModel().getColumn(1).setCellRenderer(new DateTableCellRenderer());
            this.tblLog.getColumnModel().getColumn(2).setHeaderValue(I18N.get("description"));
        }
        this.spaCodeAndLog.setBottomComponent(this.spLog);
        this.spaMain.setRightComponent(this.spaCodeAndLog);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.getContentPane().add((Component)this.spaMain, gridBagConstraints);
        this.butClose.setText(I18N.get("common.close"));
        this.butClose.addActionListener(this::butCloseActionPerformed);
        this.pnaBottom.add(this.butClose);
        this.butExecute.setText(I18N.get("execute"));
        this.butExecute.addActionListener(this::butExecuteActionPerformed);
        this.pnaBottom.add(this.butExecute);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.pnaBottom, gridBagConstraints);
        this.pack();
    }

    private void butExecuteActionPerformed(ActionEvent evt) {
        Methods.setLogger(message -> this.logMessage(LogMessageType.DEFAULT, (String)message));
        Tasks.submit(() -> {
            try {
                this.logMessage(LogMessageType.DEFAULT, I18N.get("workflow-started"));
                Methods.setupContext(this.context.getWorkbenchContext(), this);
                this.workflowExecutor.validate(this.workflow);
                this.workflowExecutor.execute(this.workflow);
                this.logMessage(LogMessageType.SUCCESS, I18N.get("workflow-finished"));
            }
            catch (ParseException ex) {
                if (this.currentFile != null) {
                    ex.setErrorSourceFile(this.currentFile.getName());
                }
                this.showAndJumpToError(ex.getMessage(true), (EvalError)((Object)((Object)((Object)ex))));
            }
            catch (TargetError ex) {
                Throwable target = ex.getTarget();
                String detailMessageOrException = Objects.requireNonNullElseGet(target.getMessage(), target::toString);
                this.showAndJumpToError(detailMessageOrException, (EvalError)((Object)((Object)((Object)ex))));
            }
            catch (EvalError ex) {
                this.showAndJumpToError(ex.getMessage(), ex);
            }
            catch (Throwable ex) {
                WorkbenchFrame.handleThrowable(ex, this);
            }
        }, false, this);
    }

    private void butCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void butSaveActionPerformed(ActionEvent evt) {
        try {
            if (this.currentFile == null) {
                this.butSaveAsActionPerformed(evt);
                return;
            }
            this.workflowDao.writeToFile(this.workflow, this.currentFile);
            this.setUnsavedChanges(false);
        }
        catch (Exception ex) {
            WorkbenchFrame.handleThrowable(ex, this);
        }
    }

    private void butLoadActionPerformed(ActionEvent evt) {
        try {
            if (this.isUnsavedChanges() && !GUISupport.okcancelbox((Component)this, (String)I18N.get("unsaved-changes-continue-anyway"), (String)I18N.get("geodata-processing"))) {
                return;
            }
            File inputFile = GUISupport.chooseSingleFile((Component)this, (String)I18N.get("common.open"), (FileFilter[])new FileFilter[]{this.workflowFileFilter}, (File)this.getLastUsedFile(), (boolean)true);
            if (inputFile == null) {
                return;
            }
            this.setLastUsedFile(inputFile);
            GeoDataProcessingWorkflow loadedWorkflow = this.workflowDao.readFromFile(inputFile);
            this.setWorkflow(loadedWorkflow);
            this.currentFile = inputFile;
        }
        catch (Exception ex) {
            WorkbenchFrame.handleThrowable(ex, this);
        }
    }

    private void cbTemplatesActionPerformed(ActionEvent evt) {
        CodeTemplate template = (CodeTemplate)this.cbTemplates.getSelectedItem();
        if (template != null && !template.isHeader()) {
            this.staCodeEditor.insert(template.getCodeTemplate(), this.staCodeEditor.getCaretPosition());
            this.staCodeEditor.requestFocusInWindow();
        }
        this.cbTemplates.setSelectedItem(null);
    }

    private void staCodeEditorFocusGained(FocusEvent evt) {
        this.pnlCodeEditor.repaint();
    }

    private void staCodeEditorFocusLost(FocusEvent evt) {
        this.pnlCodeEditor.repaint();
    }

    private void layerTreeMousePressed(MouseEvent evt) {
        if (!SwingUtilities.isRightMouseButton(evt)) {
            return;
        }
        TreePath popupPath = this.layerTree.getPathForLocation(evt.getX(), evt.getY());
        if (popupPath == null) {
            return;
        }
        Object popupNode = popupPath.getLastPathComponent();
        if (popupNode instanceof Layer) {
            Layer layer = (Layer)popupNode;
            this.layerTree.getSelectionModel().addSelectionPath(popupPath);
            this.layerTreePopupMenu.setTitle(layer.getName() + " (" + layer.getKey() + ")");
            this.layerTreePopupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    private void butNewActionPerformed(ActionEvent evt) {
        if (this.isUnsavedChanges() && !GUISupport.okcancelbox((Component)this, (String)I18N.get("unsaved-changes-continue-anyway"), (String)I18N.get("geodata-processing"))) {
            return;
        }
        GeoDataProcessingWorkflow newWorkflow = this.createNewWorkflow();
        this.setWorkflow(newWorkflow);
        this.currentFile = null;
    }

    private void butSaveAsActionPerformed(ActionEvent evt) {
        try {
            JFileChooser fileChooser = GUISupport.createJFileChooserOverwritePrompting();
            fileChooser.setAcceptAllFileFilterUsed(false);
            fileChooser.setFileFilter(this.workflowFileFilter);
            fileChooser.setSelectedFile(this.getLastUsedFile());
            int result = fileChooser.showSaveDialog(this);
            if (result == 1) {
                return;
            }
            File outputFile = fileChooser.getSelectedFile();
            if (outputFile == null) {
                return;
            }
            if (!StringUtils.endsWithIgnoreCase((CharSequence)outputFile.getName(), (CharSequence)".gdp")) {
                outputFile = new File(outputFile.toString() + ".gdp");
            }
            this.setLastUsedFile(outputFile);
            this.workflowDao.writeToFile(this.workflow, outputFile);
            this.currentFile = outputFile;
            this.setUnsavedChanges(false);
        }
        catch (Exception ex) {
            WorkbenchFrame.handleThrowable(ex, this);
        }
    }

    private static final class ShowDetailsCellRenderer
    implements TableCellRenderer {
        private final JButton btnShowDetail = new JButton("...");
        private final DefaultButtonModel buttonModel = new DefaultButtonModel();

        public ShowDetailsCellRenderer() {
            this.btnShowDetail.setModel(this.buttonModel);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.buttonModel.setSelected(isSelected);
            this.buttonModel.setRollover(hasFocus);
            return this.btnShowDetail;
        }
    }

    private static enum LogMessageType {
        DEFAULT,
        SUCCESS,
        ERROR;

    }

    class MessageTypeTableCellRenderer
    extends DefaultTableCellRenderer {
        MessageTypeTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel comp = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            comp.setText(null);
            LogMessageType type = (LogMessageType)((Object)value);
            switch (type.ordinal()) {
                case 1: {
                    comp.setIcon(IconLoader.svgIcon((String)"common_ok.svg"));
                    break;
                }
                case 2: {
                    comp.setIcon(IconLoader.svgIcon((String)"common_attention.svg"));
                    break;
                }
                case 0: {
                    comp.setIcon(null);
                }
            }
            return comp;
        }
    }

    class DateTableCellRenderer
    extends DefaultTableCellRenderer {
        DateFormat df = DateFormat.getDateTimeInstance(3, 1);

        DateTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel comp = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            comp.setText(this.df.format((Date)value));
            return comp;
        }
    }
}

