/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.workbench.ui.plugin.dataprocessing;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import de.riwagis.riwajump.workbench.ui.plugin.dataprocessing.GeoDataProcessingEditorDialog;
import de.riwagis.riwajump.workbench.ui.plugin.dataprocessing.dsl.Methods;
import java.util.Map;
import java.util.function.Function;
import org.fife.rsta.ac.LanguageSupportFactory;
import org.fife.rsta.ac.java.BeanShellLanguageSupport;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;

class GenerateCodeInsertionPlugIn
extends AbstractPlugIn {
    private final GeoDataProcessingEditorDialog dialog;
    private final String methodName;
    private final Function<Layer, String> allowedCheck;

    public GenerateCodeInsertionPlugIn(GeoDataProcessingEditorDialog dialog, String methodName) {
        this(dialog, methodName, layer -> null);
    }

    public GenerateCodeInsertionPlugIn(GeoDataProcessingEditorDialog dialog, String methodName, Function<Layer, String> allowedCheck) {
        this.dialog = dialog;
        this.methodName = methodName;
        this.allowedCheck = allowedCheck;
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        Layer layer = this.dialog.getSelectedLayerFromTree();
        RSyntaxTextArea staCodeEditor = this.dialog.getCodeEditor();
        BeanShellLanguageSupport bshSupport = (BeanShellLanguageSupport)LanguageSupportFactory.get().getSupportFor("text/bsh");
        Map<String, String> argumentReplacements = Map.of("layerKey", "\"" + layer.getKey() + "\"", "cqlFilter", "\"\"", "writeOption", "WriteOption.ADD");
        bshSupport.insertMethod(staCodeEditor, Methods.class, this.methodName, argumentReplacements);
        staCodeEditor.requestFocusInWindow();
        return true;
    }

    @Override
    public EnableCheck createEnableCheck() {
        return c -> this.allowedCheck.apply(this.dialog.getSelectedLayerFromTree());
    }

    @Override
    public String getName() {
        return I18N.getMessage("generate-method", this.methodName);
    }
}

