/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.workbench.ui.plugin.dataprocessing;

import bsh.EvalError;
import bsh.ParseException;
import bsh.TargetError;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.ui.WorkbenchFrame;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import de.riwagis.riwajump.workbench.ui.plugin.dataprocessing.GdpDialog;
import de.riwagis.riwajump.workbench.ui.plugin.dataprocessing.GeoDataProcessingWorkflow;
import de.riwagis.riwajump.workbench.ui.plugin.dataprocessing.GeoDataProcessingWorkflowDao;
import de.riwagis.riwajump.workbench.ui.plugin.dataprocessing.GeoDataProcessingWorkflowExecutor;
import de.riwagis.riwajump.workbench.ui.plugin.dataprocessing.dsl.Methods;
import de.riwagis.util.gui.GUISupport;
import de.riwagis.util.gui.components.WaitDialog;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Objects;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.lang3.StringUtils;

public class ExecuteGeoDataProcessingPanel
extends JPanel {
    private static final String FILE_EXTENSION = "gdp";
    private static final String KEY_LASTUSEDFILE = ExecuteGeoDataProcessingPanel.class.getName() + "_LASTUSEDFILE";
    private final FileFilter workflowFileFilter = GUISupport.createFileFilter((String)I18N.get("geodata-processing-file"), (String[])new String[]{"gdp"});
    private GdpDialog gdpDialog = null;
    private JButton butClose;
    private JButton butExecute;
    private JButton butSave;

    public ExecuteGeoDataProcessingPanel() {
        this.initComponents();
    }

    public void setGdpDialog(GdpDialog gdpDialog) {
        this.gdpDialog = gdpDialog;
    }

    private GeoDataProcessingWorkflow createWorkflow() {
        GeoDataProcessingWorkflow workflow = new GeoDataProcessingWorkflow();
        workflow.setName(this.gdpDialog.getOperationName());
        workflow.setCode(this.gdpDialog.getGdpBeanshell());
        return workflow;
    }

    private File getLastUsedFile() {
        String lastUsedFile = (String)PersistentBlackboardPlugIn.get().get(KEY_LASTUSEDFILE);
        if (lastUsedFile == null) {
            return null;
        }
        return new File(lastUsedFile);
    }

    private void setLastUsedFile(File file) {
        PersistentBlackboardPlugIn.get().put(KEY_LASTUSEDFILE, file.getAbsolutePath());
    }

    private void initComponents() {
        this.butExecute = new JButton();
        this.butSave = new JButton();
        this.butClose = new JButton();
        this.setLayout(new GridBagLayout());
        ResourceBundle bundle = ResourceBundle.getBundle("language/jump");
        this.butExecute.setText(bundle.getString("ExecuteGeoDataProcessingPanel.butExecute.text"));
        this.butExecute.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExecuteGeoDataProcessingPanel.this.butExecuteActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.butExecute, gridBagConstraints);
        this.butSave.setText(bundle.getString("ExecuteGeoDataProcessingPanel.butSave.text"));
        this.butSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExecuteGeoDataProcessingPanel.this.butSaveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.butSave, gridBagConstraints);
        this.butClose.setText(bundle.getString("ExecuteGeoDataProcessingPanel.butClose.text"));
        this.butClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExecuteGeoDataProcessingPanel.this.butCloseActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.butClose, gridBagConstraints);
    }

    private void butExecuteActionPerformed(ActionEvent evt) {
        if (this.validateInput()) {
            return;
        }
        Methods.setLogger(null);
        GeoDataProcessingWorkflow workflow = this.createWorkflow();
        Methods.setupContext(this.gdpDialog.getPlugInContext().getWorkbenchContext(), WorkbenchContext.getFrame());
        GeoDataProcessingWorkflowExecutor executor = new GeoDataProcessingWorkflowExecutor();
        try {
            executor.validate(workflow);
        }
        catch (ParseException ex) {
            GUISupport.msgbox((Component)this, (String)String.format("Should never reach here. Beanshell source code created is invalid.\nMessage: '%s'", ex.getMessage()), (String)I18N.get("common.error"));
        }
        WaitDialog waitDialog = WaitDialog.createWaitDialog((Window)WorkbenchContext.getFrame(), (String)I18N.get("common.wait"), () -> {
            try {
                executor.execute(workflow);
            }
            catch (ParseException ex) {
                GUISupport.msgbox((Component)this, (String)String.format(I18N.get("ExecuteGeoDataProcessingPanel.error-at-execution"), ex.getMessage(true)), (String)I18N.get("common.error"));
            }
            catch (TargetError ex) {
                Throwable target = ex.getTarget();
                String detailMessageOrException = Objects.requireNonNullElseGet(target.getMessage(), target::toString);
                GUISupport.msgbox((Component)this, (String)String.format(I18N.get("ExecuteGeoDataProcessingPanel.error-at-execution"), detailMessageOrException), (String)I18N.get("common.error"));
            }
            catch (EvalError ex) {
                GUISupport.msgbox((Component)this, (String)String.format(I18N.get("ExecuteGeoDataProcessingPanel.error-at-execution"), ex.getMessage()), (String)I18N.get("common.error"));
            }
            catch (Throwable ex) {
                WorkbenchFrame.handleThrowable(ex, this);
            }
        });
        waitDialog.setVisible(true);
    }

    private boolean validateInput() {
        if (this.gdpDialog.validateInput() != null) {
            GUISupport.msgbox((Component)this, (String)this.gdpDialog.validateInput(), (String)I18N.get("common.error"));
            return true;
        }
        return false;
    }

    private void butCloseActionPerformed(ActionEvent evt) {
        this.gdpDialog.closeDialog();
    }

    private void butSaveActionPerformed(ActionEvent evt) {
        if (this.validateInput()) {
            return;
        }
        try {
            JFileChooser fileChooser = GUISupport.createJFileChooserOverwritePrompting();
            fileChooser.setAcceptAllFileFilterUsed(false);
            fileChooser.setFileFilter(this.workflowFileFilter);
            fileChooser.setSelectedFile(this.getLastUsedFile());
            int result = fileChooser.showSaveDialog(this);
            if (result == 1) {
                return;
            }
            File outputFile = fileChooser.getSelectedFile();
            if (outputFile == null) {
                return;
            }
            if (!StringUtils.endsWithIgnoreCase((CharSequence)outputFile.getName(), (CharSequence)".gdp")) {
                outputFile = new File(outputFile.toString() + ".gdp");
            }
            this.setLastUsedFile(outputFile);
            GeoDataProcessingWorkflowDao workflowDao = new GeoDataProcessingWorkflowDao();
            workflowDao.writeToFile(this.createWorkflow(), outputFile);
        }
        catch (Exception ex) {
            WorkbenchFrame.handleThrowable(ex, this);
        }
    }
}

