/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.workbench.ui.plugin.dataprocessing;

import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import de.riwagis.riwajump.workbench.ui.plugin.dataprocessing.ExecuteGeoDataProcessingPanel;
import de.riwagis.riwajump.workbench.ui.plugin.dataprocessing.GdpDialog;
import de.riwagis.riwajump.workbench.ui.plugin.dataprocessing.LayerSelectionPanel;
import de.riwagis.riwajump.workbench.ui.plugin.dataprocessing.TargetPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class ClipDialog
extends JDialog
implements GdpDialog {
    private final PlugInContext context;
    private JCheckBox chkEmptyGeometries;
    private JPanel clipPanel;
    private ExecuteGeoDataProcessingPanel executeGeoDataProcessingPanel;
    private JPanel pnlSelect;
    private LayerSelectionPanel sourcePanel1;
    private LayerSelectionPanel sourcePanel2;
    private TargetPanel targetPanel;

    public ClipDialog(PlugInContext context) {
        super((Frame)context.getWorkbenchFrame(), false);
        this.context = context;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.sourcePanel1.resetTaskByWorkbench();
        this.sourcePanel1.setFeaturesVariableName("sourceFeatures");
        this.sourcePanel2.resetTaskByWorkbench();
        this.sourcePanel2.setFeaturesVariableName("clipFeatures");
        this.executeGeoDataProcessingPanel.setGdpDialog(this);
    }

    private void initComponents() {
        this.clipPanel = new JPanel();
        this.chkEmptyGeometries = new JCheckBox();
        this.targetPanel = new TargetPanel();
        this.executeGeoDataProcessingPanel = new ExecuteGeoDataProcessingPanel();
        this.pnlSelect = new JPanel();
        this.sourcePanel1 = new LayerSelectionPanel();
        this.sourcePanel2 = new LayerSelectionPanel();
        ResourceBundle bundle = ResourceBundle.getBundle("language/jump");
        this.setTitle(bundle.getString("ClipDialog.title"));
        this.setMinimumSize(new Dimension(550, 550));
        this.setSize(new Dimension(550, 550));
        this.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent evt) {
                ClipDialog.this.formWindowGainedFocus(evt);
            }

            @Override
            public void windowLostFocus(WindowEvent evt) {
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.clipPanel.setBorder(BorderFactory.createTitledBorder(bundle.getString("ClipDialog.clipPanel.border.title")));
        this.clipPanel.setLayout(new GridBagLayout());
        this.chkEmptyGeometries.setText(bundle.getString("ClipDialog.chkEmptyGeometries.text"));
        this.chkEmptyGeometries.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ClipDialog.this.chkEmptyGeometriesActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.clipPanel.add((Component)this.chkEmptyGeometries, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.clipPanel, gridBagConstraints);
        this.targetPanel.setBorder(BorderFactory.createTitledBorder(bundle.getString("ClipDialog.targetPanel.border.title")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 25;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.targetPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 20;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.executeGeoDataProcessingPanel, gridBagConstraints);
        this.pnlSelect.setLayout(new GridLayout(1, 2, 2, 0));
        this.sourcePanel1.setBorder(BorderFactory.createTitledBorder(bundle.getString("ClipDialog.sourcePanel1.border.title")));
        this.sourcePanel1.setMinimumSize(new Dimension(270, 230));
        this.sourcePanel1.setName("sourcePanel1");
        this.sourcePanel1.setPreferredSize(new Dimension(250, 219));
        this.pnlSelect.add(this.sourcePanel1);
        this.sourcePanel2.setBorder(BorderFactory.createTitledBorder(bundle.getString("ClipDialog.sourcePanel2.border.title")));
        this.sourcePanel2.setMinimumSize(new Dimension(270, 230));
        this.sourcePanel2.setPreferredSize(new Dimension(250, 219));
        this.pnlSelect.add(this.sourcePanel2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.pnlSelect, gridBagConstraints);
        this.pack();
    }

    private void formWindowGainedFocus(WindowEvent evt) {
        this.sourcePanel1.resetTaskByWorkbench();
        this.sourcePanel2.resetTaskByWorkbench();
        this.targetPanel.resetTaskByWorkbench();
    }

    private void chkEmptyGeometriesActionPerformed(ActionEvent evt) {
    }

    @Override
    public String getGdpBeanshell() {
        StringBuilder sbBeanshell = new StringBuilder();
        sbBeanshell.append(this.sourcePanel1.getGdbBeanshell());
        sbBeanshell.append(this.sourcePanel2.getGdbBeanshell());
        sbBeanshell.append("//Clip features\n");
        sbBeanshell.append(String.format("Features features = clipFeatureGeometries(sourceFeatures, clipFeatures, %s);", this.getFeaturesWithoutGeomText()));
        sbBeanshell.append("\n\n");
        sbBeanshell.append(this.targetPanel.getGdbBeanshell());
        return sbBeanshell.toString();
    }

    @Override
    public void closeDialog() {
        this.setVisible(false);
    }

    @Override
    public String validateInput() {
        StringBuilder sbErrors = new StringBuilder();
        if (this.sourcePanel1.validateInput() != null) {
            sbErrors.append(this.sourcePanel1.validateInput()).append("\n");
        }
        if (this.sourcePanel2.validateInput() != null) {
            sbErrors.append(this.sourcePanel2.validateInput()).append("\n");
        }
        if (this.targetPanel.validateInput() != null) {
            sbErrors.append(this.targetPanel.validateInput()).append("\n");
        }
        if (sbErrors.isEmpty()) {
            return null;
        }
        return sbErrors.toString();
    }

    @Override
    public String getOperationName() {
        return "Clip";
    }

    @Override
    public PlugInContext getPlugInContext() {
        return this.context;
    }

    private String getFeaturesWithoutGeomText() {
        if (this.chkEmptyGeometries.isSelected()) {
            return "false";
        }
        return "true";
    }
}

