/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.workbench.ui.plugin.dataprocessing;

import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import de.riwagis.riwajump.workbench.ui.plugin.dataprocessing.ExecuteGeoDataProcessingPanel;
import de.riwagis.riwajump.workbench.ui.plugin.dataprocessing.GdpDialog;
import de.riwagis.riwajump.workbench.ui.plugin.dataprocessing.LayerSelectionPanel;
import de.riwagis.riwajump.workbench.ui.plugin.dataprocessing.TargetPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class BufferDialog
extends JDialog
implements GdpDialog {
    private final PlugInContext context;
    private final NumberFormat df = new DecimalFormat();
    private JPanel bufferPanel;
    private JCheckBox chkMerge;
    private JComboBox<String> cmbCapStyle;
    private JComboBox<String> cmbJoinStyle;
    private ExecuteGeoDataProcessingPanel executeGeoDataProcessingPanel;
    private JLabel lblCapStyle;
    private JLabel lblDistance;
    private JLabel lblJoinStyle;
    private LayerSelectionPanel sourcePanel;
    private TargetPanel targetPanel;
    private TargetPanel targetPanel1;
    private JFormattedTextField txtDistance;

    public BufferDialog(PlugInContext context) {
        super((Frame)context.getWorkbenchFrame(), false);
        this.context = context;
        this.initComponents();
        this.i18n();
        this.init();
    }

    private void i18n() {
        ResourceBundle bundle = ResourceBundle.getBundle("language/jump");
        this.cmbCapStyle.removeAllItems();
        this.cmbCapStyle.addItem(bundle.getString("BufferDialog.capStyle.ROUND"));
        this.cmbCapStyle.addItem(bundle.getString("BufferDialog.capStyle.FLAT"));
        this.cmbCapStyle.addItem(bundle.getString("BufferDialog.capStyle.SQUARE"));
        this.cmbJoinStyle.removeAllItems();
        this.cmbJoinStyle.addItem(bundle.getString("BufferDialog.joinStyle.ROUND"));
        this.cmbJoinStyle.addItem(bundle.getString("BufferDialog.joinStyle.MITRE"));
        this.cmbJoinStyle.addItem(bundle.getString("BufferDialog.joinStyle.BEVEL"));
    }

    private void init() {
        this.sourcePanel.resetTaskByWorkbench();
        this.txtDistance.setFormatterFactory(GUIUtil.getNumberFormat(this.df));
        this.txtDistance.setValue(20.0);
        this.executeGeoDataProcessingPanel.setGdpDialog(this);
    }

    private void initComponents() {
        this.targetPanel1 = new TargetPanel();
        this.sourcePanel = new LayerSelectionPanel();
        this.bufferPanel = new JPanel();
        this.txtDistance = new JFormattedTextField();
        this.cmbJoinStyle = new JComboBox();
        this.cmbCapStyle = new JComboBox();
        this.lblCapStyle = new JLabel();
        this.lblDistance = new JLabel();
        this.lblJoinStyle = new JLabel();
        this.chkMerge = new JCheckBox();
        this.targetPanel = new TargetPanel();
        this.executeGeoDataProcessingPanel = new ExecuteGeoDataProcessingPanel();
        ResourceBundle bundle = ResourceBundle.getBundle("language/jump");
        this.setTitle(bundle.getString("BufferDialog.title"));
        this.setMinimumSize(new Dimension(460, 550));
        this.setSize(new Dimension(460, 550));
        this.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent evt) {
                BufferDialog.this.formWindowGainedFocus(evt);
            }

            @Override
            public void windowLostFocus(WindowEvent evt) {
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.sourcePanel.setBorder(BorderFactory.createTitledBorder(bundle.getString("BufferDialog.sourcePanel.border.title")));
        this.sourcePanel.setMinimumSize(new Dimension(83, 180));
        this.sourcePanel.setName("sourcePanel");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.sourcePanel, gridBagConstraints);
        this.bufferPanel.setBorder(BorderFactory.createTitledBorder(bundle.getString("BufferDialog.bufferPanel.border.title")));
        this.bufferPanel.setLayout(new GridBagLayout());
        this.txtDistance.setText(bundle.getString("BufferDialog.txtDistance.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 62;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 0);
        this.bufferPanel.add((Component)this.txtDistance, gridBagConstraints);
        this.cmbJoinStyle.setModel(new DefaultComboBoxModel<String>(new String[]{"rund", "spitz", "abgeschnitten"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 0);
        this.bufferPanel.add(this.cmbJoinStyle, gridBagConstraints);
        this.cmbCapStyle.setModel(new DefaultComboBoxModel<String>(new String[]{"rund", "flach", "fl\u00e4chig"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 0);
        this.bufferPanel.add(this.cmbCapStyle, gridBagConstraints);
        this.lblCapStyle.setText(bundle.getString("BufferDialog.lblCapStyle.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.bufferPanel.add((Component)this.lblCapStyle, gridBagConstraints);
        this.lblDistance.setText(bundle.getString("BufferDialog.lblDistance.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.bufferPanel.add((Component)this.lblDistance, gridBagConstraints);
        this.lblJoinStyle.setText(bundle.getString("BufferDialog.lblJoinStyle.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.bufferPanel.add((Component)this.lblJoinStyle, gridBagConstraints);
        this.chkMerge.setText(bundle.getString("BufferDialog.chkMerge.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.bufferPanel.add((Component)this.chkMerge, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.bufferPanel, gridBagConstraints);
        this.targetPanel.setBorder(BorderFactory.createTitledBorder(bundle.getString("BufferDialog.targetPanel.border.title")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.targetPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 20;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.executeGeoDataProcessingPanel, gridBagConstraints);
        this.pack();
    }

    private void formWindowGainedFocus(WindowEvent evt) {
        this.sourcePanel.resetTaskByWorkbench();
        this.targetPanel.resetTaskByWorkbench();
    }

    @Override
    public String getGdpBeanshell() {
        StringBuilder sbBeanshell = new StringBuilder();
        sbBeanshell.append(this.sourcePanel.getGdbBeanshell());
        sbBeanshell.append("//Buffer features\n");
        sbBeanshell.append(String.format("features = buffer(features, %s, %s, %s);", this.getDistanceText(), this.getCapStyleText(), this.getJoinStyleText()));
        sbBeanshell.append("\n\n");
        if (this.chkMerge.isSelected()) {
            sbBeanshell.append("//Merge features\n");
            sbBeanshell.append("features = mergeFeaturesByGeometry(features, MergeOperation.ON_INTERSECTION);");
            sbBeanshell.append("\n\n");
        }
        sbBeanshell.append(this.targetPanel.getGdbBeanshell());
        return sbBeanshell.toString();
    }

    private String getDistanceText() {
        return "" + ((Number)this.txtDistance.getValue()).doubleValue();
    }

    private String getCapStyleText() {
        switch (this.cmbCapStyle.getSelectedIndex()) {
            case 0: {
                return "EndCapStyle.ROUND";
            }
            case 1: {
                return "EndCapStyle.FLAT";
            }
            case 2: {
                return "EndCapStyle.SQUARE";
            }
        }
        throw new AssertionError();
    }

    private String getJoinStyleText() {
        switch (this.cmbJoinStyle.getSelectedIndex()) {
            case 0: {
                return "JoinStyle.ROUND";
            }
            case 1: {
                return "JoinStyle.MITRE";
            }
            case 2: {
                return "JoinStyle.BEVEL";
            }
        }
        throw new AssertionError();
    }

    @Override
    public void closeDialog() {
        this.setVisible(false);
    }

    @Override
    public String validateInput() {
        StringBuilder sbErrors = new StringBuilder();
        if (this.sourcePanel.validateInput() != null) {
            sbErrors.append(this.sourcePanel.validateInput()).append("\n");
        }
        if (this.targetPanel.validateInput() != null) {
            sbErrors.append(this.targetPanel.validateInput()).append("\n");
        }
        if (sbErrors.isEmpty()) {
            return null;
        }
        return sbErrors.toString();
    }

    @Override
    public String getOperationName() {
        return "Buffer";
    }

    @Override
    public PlugInContext getPlugInContext() {
        return this.context;
    }
}

