/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.workbench.ui.plugin;

import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerStyleCollection;
import com.vividsolutions.jump.workbench.model.RiwaJumpModelUtilities;
import com.vividsolutions.jump.workbench.model.StyleCollection;
import de.riwagis.riwajump.model.style.BasicStyleModel;
import de.riwagis.riwajump.model.style.SymbolStyleModel;
import de.riwagis.riwajump.model.style.TextStyleModel;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.commons.lang3.StringUtils;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Lineal;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.Polygonal;
import org.locationtech.jts.geom.Puntal;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class ImportStyleDefaults {
    public static final String FIELD_ROTATION = "rotation";
    public static final String FIELD_TEXT = "text";
    public static final String FIELD_SIZE = "size";
    public static final int RENDER_PRIO_GEOMETRY = 10300;
    public static final int RENDER_PRIO_PUNTAL = 10200;
    public static final int RENDER_PRIO_LINEAL = 10100;
    public static final int RENDER_PRIO_POLYGONAL = 10000;

    public static void setLayerCaching(Layer layer) throws Exception {
        int featureCount = layer.getFeatureCount(false);
        layer.setCacheAll(featureCount <= 10000);
    }

    public static void setLayerStyleDefaults(Layer ly, SimpleFeatureType schema) {
        ImportStyleDefaults.setLayerStyleDefaults(ly, schema, null);
    }

    public static void setLayerStyleDefaults(Layer ly, SimpleFeatureType schema, SimpleFeatureType oldSchema) {
        BasicStyleModel basicStyle;
        LayerStyleCollection layerStyleCollection;
        String[] arrAttributes = ly.getFMD().getAttributes();
        ArrayList<String> lstAttributes = new ArrayList<String>(Arrays.asList(arrAttributes));
        if (ImportStyleDefaults.hasSchemaAttribute(schema, FIELD_TEXT) && !ImportStyleDefaults.hasSchemaAttribute(oldSchema, FIELD_TEXT)) {
            text = ImportStyleDefaults.getSchemaAttribute(schema, FIELD_TEXT);
            if (!lstAttributes.contains(text)) {
                lstAttributes.add(text);
            }
            if (StringUtils.isEmpty((CharSequence)ly.getFMD().getTextAtt())) {
                ly.getFMD().setUseText(true);
                ly.getFMD().setTextAtt(text);
            }
            for (StyleCollection styleCollection : ly.getStyleCollections()) {
                layerStyleCollection = (LayerStyleCollection)styleCollection;
                basicStyle = layerStyleCollection.getBasicStyle();
                if (basicStyle == null || !basicStyle.isEnabled()) continue;
                if (!basicStyle.isRenderingText() || StringUtils.isEmpty((CharSequence)basicStyle.getTextStyle().getStrText())) {
                    basicStyle.setRenderingText(true);
                    basicStyle.getTextStyle().setEnabled(true);
                    basicStyle.getTextStyle().setStrText("str(\"" + text + "\")");
                }
                if (basicStyle.isShowTooltips() && !StringUtils.isEmpty((CharSequence)basicStyle.getTooltipStyle().getStrText())) continue;
                basicStyle.setShowTooltips(true);
                basicStyle.getTooltipStyle().setStrText("str(\"" + text + "\")");
            }
        } else if (!ImportStyleDefaults.hasSchemaAttribute(schema, FIELD_TEXT) && ImportStyleDefaults.hasSchemaAttribute(oldSchema, FIELD_TEXT)) {
            text = ImportStyleDefaults.getSchemaAttribute(oldSchema, FIELD_TEXT);
            if (lstAttributes.contains(text)) {
                lstAttributes.remove(text);
            }
            if (StringUtils.isEmpty((CharSequence)ly.getFMD().getTextAtt()) || StringUtils.equals((CharSequence)ly.getFMD().getTextAtt(), (CharSequence)text)) {
                ly.getFMD().setTextAtt(null);
                ly.getFMD().setUseText(false);
            }
            for (StyleCollection styleCollection : ly.getStyleCollections()) {
                layerStyleCollection = (LayerStyleCollection)styleCollection;
                basicStyle = layerStyleCollection.getBasicStyle();
                if (basicStyle == null || !basicStyle.isEnabled()) continue;
                if (StringUtils.contains((CharSequence)basicStyle.getTextStyle().getStrText(), (CharSequence)text) && StringUtils.equals((CharSequence)basicStyle.getTextStyle().getStrText(), (CharSequence)("str(\"" + text + "\")"))) {
                    basicStyle.setRenderingText(false);
                    basicStyle.getTextStyle().setEnabled(false);
                    basicStyle.getTextStyle().setStrText(null);
                }
                if (!StringUtils.contains((CharSequence)basicStyle.getTooltipStyle().getStrText(), (CharSequence)text) || !StringUtils.equals((CharSequence)basicStyle.getTooltipStyle().getStrText(), (CharSequence)("str(\"" + text + "\")"))) continue;
                basicStyle.setShowTooltips(false);
                basicStyle.getTooltipStyle().setStrText(null);
            }
        }
        if (ImportStyleDefaults.hasSchemaAttribute(schema, FIELD_ROTATION) && !ImportStyleDefaults.hasSchemaAttribute(oldSchema, FIELD_ROTATION)) {
            rotation = ImportStyleDefaults.getSchemaAttribute(schema, FIELD_ROTATION);
            if (!lstAttributes.contains(rotation)) {
                lstAttributes.add(rotation);
            }
            if (StringUtils.isEmpty((CharSequence)ly.getFMD().getOriAtt())) {
                ly.getFMD().setOriAtt(rotation);
            }
            if (StringUtils.isEmpty((CharSequence)ly.getFMD().getTextOriAtt())) {
                ly.getFMD().setTextOriAtt(rotation);
            }
            for (StyleCollection styleCollection : ly.getStyleCollections()) {
                layerStyleCollection = (LayerStyleCollection)styleCollection;
                basicStyle = layerStyleCollection.getBasicStyle();
                if (basicStyle == null || !basicStyle.isEnabled()) continue;
                if (basicStyle.isRenderingText() && StringUtils.isEmpty((CharSequence)basicStyle.getTextStyle().getStrOrient())) {
                    basicStyle.getTextStyle().setStrOrient("num(\"" + rotation + "\")");
                }
                if (!Puntal.class.isAssignableFrom(schema.getGeometryDescriptor().getType().getBinding()) || basicStyle.isRenderingSymbol() && !StringUtils.isEmpty((CharSequence)basicStyle.getSymStyle().getStrPtOri())) continue;
                basicStyle.setRenderingSymbol(true);
                basicStyle.getSymStyle().setStrPtOri("num(\"" + rotation + "\")");
            }
        } else if (!ImportStyleDefaults.hasSchemaAttribute(schema, FIELD_ROTATION) && ImportStyleDefaults.hasSchemaAttribute(oldSchema, FIELD_ROTATION)) {
            rotation = ImportStyleDefaults.getSchemaAttribute(oldSchema, FIELD_ROTATION);
            if (lstAttributes.contains(rotation)) {
                lstAttributes.remove(rotation);
            }
            if (StringUtils.equals((CharSequence)ly.getFMD().getOriAtt(), (CharSequence)rotation)) {
                ly.getFMD().setOriAtt(null);
            }
            if (StringUtils.equals((CharSequence)ly.getFMD().getTextOriAtt(), (CharSequence)rotation)) {
                ly.getFMD().setTextOriAtt(null);
            }
            for (StyleCollection styleCollection : ly.getStyleCollections()) {
                layerStyleCollection = (LayerStyleCollection)styleCollection;
                basicStyle = layerStyleCollection.getBasicStyle();
                if (basicStyle == null || !basicStyle.isEnabled()) continue;
                if (basicStyle.isRenderingText() && StringUtils.contains((CharSequence)basicStyle.getTextStyle().getStrOrient(), (CharSequence)rotation) && StringUtils.equals((CharSequence)basicStyle.getTextStyle().getStrOrient(), (CharSequence)("num(\"" + rotation + "\")"))) {
                    basicStyle.getTextStyle().setStrOrient(null);
                }
                if (!Puntal.class.isAssignableFrom(schema.getGeometryDescriptor().getType().getBinding()) || !StringUtils.contains((CharSequence)basicStyle.getSymStyle().getStrPtOri(), (CharSequence)rotation) || !StringUtils.equals((CharSequence)basicStyle.getSymStyle().getStrPtOri(), (CharSequence)("num(\"" + rotation + "\")"))) continue;
                basicStyle.getSymStyle().setStrPtOri(null);
            }
        }
        if (ImportStyleDefaults.hasSchemaAttribute(schema, FIELD_SIZE) && !ImportStyleDefaults.hasSchemaAttribute(oldSchema, FIELD_SIZE)) {
            size = ImportStyleDefaults.getSchemaAttribute(schema, FIELD_SIZE);
            if (!lstAttributes.contains(size)) {
                lstAttributes.add(size);
            }
            if (StringUtils.isEmpty((CharSequence)ly.getFMD().getTextHeightAtt())) {
                ly.getFMD().setTextHeightAtt(size);
            }
            for (StyleCollection styleCollection : ly.getStyleCollections()) {
                layerStyleCollection = (LayerStyleCollection)styleCollection;
                basicStyle = layerStyleCollection.getBasicStyle();
                if (basicStyle == null || !basicStyle.isEnabled() || !basicStyle.isRenderingText() || !StringUtils.isEmpty((CharSequence)basicStyle.getTextStyle().getStrHeight())) continue;
                basicStyle.getTextStyle().setStrHeight("integer(\"" + size + "\") == 0 ? 12 : integer(\"" + size + "\")");
            }
        } else if (!ImportStyleDefaults.hasSchemaAttribute(schema, FIELD_SIZE) && ImportStyleDefaults.hasSchemaAttribute(oldSchema, FIELD_SIZE)) {
            size = ImportStyleDefaults.getSchemaAttribute(oldSchema, FIELD_SIZE);
            if (lstAttributes.contains(size)) {
                lstAttributes.remove(size);
            }
            if (StringUtils.equals((CharSequence)ly.getFMD().getTextHeightAtt(), (CharSequence)size)) {
                ly.getFMD().setTextHeightAtt(null);
            }
            for (StyleCollection styleCollection : ly.getStyleCollections()) {
                layerStyleCollection = (LayerStyleCollection)styleCollection;
                basicStyle = layerStyleCollection.getBasicStyle();
                if (basicStyle == null || !basicStyle.isEnabled() || !basicStyle.isRenderingText() || !StringUtils.contains((CharSequence)basicStyle.getTextStyle().getStrHeight(), (CharSequence)size) || !StringUtils.equals((CharSequence)basicStyle.getTextStyle().getStrHeight(), (CharSequence)("integer(\"" + size + "\") == 0 ? 12 : integer(\"" + size + "\")"))) continue;
                basicStyle.getTextStyle().setStrHeight(null);
            }
        }
        ly.getFMD().setAttributes(lstAttributes.toArray(new String[lstAttributes.size()]));
    }

    public static void setLayerStylePerGeometryType(Layer ly, SimpleFeatureType schema, Color lyColor) {
        BasicStyleModel basicStyle = ly.getDefaultLayerStyleCollection().getBasicStyle();
        Class binding = schema.getGeometryDescriptor().getType().getBinding();
        if (Geometry.class.equals((Object)binding) || GeometryCollection.class.equals((Object)binding)) {
            basicStyle.setRenderingSymbol(true);
            ImportStyleDefaults.configureSymbolStyle(basicStyle, lyColor);
            ImportStyleDefaults.configureLabelDisplay(basicStyle, true, true, true);
            ly.setRenderPrio(10300);
        }
        if (Puntal.class.isAssignableFrom(binding)) {
            basicStyle.setRenderingFill(false);
            basicStyle.setLineBase(null);
            basicStyle.setLineForeground(null);
            basicStyle.setLineBackground(null);
            basicStyle.setRenderingSymbol(true);
            ImportStyleDefaults.configureSymbolStyle(basicStyle, lyColor);
            ImportStyleDefaults.configureGeometryRestriction(ly, binding);
            ImportStyleDefaults.configureLabelDisplay(basicStyle, true, false, false);
            ly.setRenderPrio(10200);
        }
        if (Lineal.class.isAssignableFrom(binding)) {
            basicStyle.setRenderingFill(false);
            ImportStyleDefaults.configureGeometryRestriction(ly, binding);
            ImportStyleDefaults.configureLabelDisplay(basicStyle, false, true, false);
            ly.setRenderPrio(10100);
        }
        if (Polygonal.class.isAssignableFrom(binding)) {
            ImportStyleDefaults.configureGeometryRestriction(ly, binding);
            ImportStyleDefaults.configureLabelDisplay(basicStyle, false, false, true);
            ly.setRenderPrio(10000);
        }
    }

    public static void configureGeometryRestriction(Layer layer, Class<?> geometryType) {
        layer.getFMD().setRestrictGeomType(true);
        HashSet types = new HashSet();
        types.add(geometryType);
        if (MultiPolygon.class.isAssignableFrom(geometryType)) {
            types.add(Polygon.class);
        }
        if (MultiLineString.class.isAssignableFrom(geometryType)) {
            types.add(LineString.class);
        }
        if (MultiPoint.class.isAssignableFrom(geometryType)) {
            types.add(Point.class);
        }
        layer.getFMD().setGeomTypes((Class[])types.toArray(Class[]::new));
    }

    public static SimpleFeatureType createTemplateType(String typeName, String geometryName, CoordinateReferenceSystem crs) {
        SimpleFeatureTypeBuilder ftBuilder = new SimpleFeatureTypeBuilder();
        ftBuilder.add(FIELD_TEXT, String.class);
        ftBuilder.add(FIELD_ROTATION, Double.class);
        ftBuilder.add(FIELD_SIZE, Integer.class);
        ftBuilder.add(geometryName, Point.class, crs);
        ftBuilder.setName(typeName);
        return ftBuilder.buildFeatureType();
    }

    private static void configureLabelDisplay(BasicStyleModel basicStyle, boolean onSymbol, boolean onLine, boolean onArea) {
        if (basicStyle.isRenderingText()) {
            TextStyleModel textStyle = basicStyle.getTextStyle();
            textStyle.setBolShowPoint(onSymbol);
            textStyle.setBolShowLine(onLine);
            textStyle.setBolShowArea(onArea);
            if (onSymbol) {
                textStyle.setAlignPoint("7");
            }
        }
    }

    private static void configureSymbolStyle(BasicStyleModel basicStyle, Color lyColor) {
        SymbolStyleModel symStyle = basicStyle.getSymStyle();
        symStyle.setStrStorename("_buildIn");
        symStyle.setStrPtSymbol("\"cross.svg\"");
        symStyle.setStrPtWidth("20");
        symStyle.setBolOverwriteLineColor(true);
        symStyle.setBolOverwriteAreaColor(true);
        symStyle.setLineColor(RiwaJumpModelUtilities.colorModelByColor(lyColor));
        symStyle.setFillColor(RiwaJumpModelUtilities.colorModelByColor(lyColor));
    }

    private static boolean hasSchemaAttribute(SimpleFeatureType schema, String attr) {
        if (schema == null) {
            return false;
        }
        if (schema.indexOf(attr) != -1) {
            return true;
        }
        if (schema.indexOf(attr.toUpperCase()) != -1) {
            return true;
        }
        for (AttributeDescriptor ad : schema.getAttributeDescriptors()) {
            if (!ad.getLocalName().equalsIgnoreCase(attr)) continue;
            return true;
        }
        return false;
    }

    private static String getSchemaAttribute(SimpleFeatureType schema, String attr) {
        if (schema == null) {
            return null;
        }
        if (schema.indexOf(attr) != -1) {
            return attr;
        }
        if (schema.indexOf(attr = attr.toUpperCase()) != -1) {
            return attr;
        }
        for (AttributeDescriptor ad : schema.getAttributeDescriptors()) {
            if (!ad.getLocalName().equalsIgnoreCase(attr)) continue;
            return ad.getLocalName();
        }
        return null;
    }
}

