/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.workbench.ui.plugin;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import de.riwagis.crs.CRSDefFactory;
import de.riwagis.crs.CRSDefinition;
import de.riwagis.util.gui.components.SelfClosingMessageBox;
import java.awt.Window;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.CRS;
import org.locationtech.jts.geom.Envelope;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class ImportMessages {
    private final Map<ImportMessagesTypes, Object[]> messages = new HashMap<ImportMessagesTypes, Object[]>();
    private final BiFunction<ImportMessagesTypes, Object[], String> i18nMapper;

    public ImportMessages(BiFunction<ImportMessagesTypes, Object[], String> i18nMapper) {
        this.i18nMapper = i18nMapper;
    }

    public void createWarnings(SimpleFeatureType schema, PlugInContext context, Layer ly, LayerManager lyMngr) {
        CRSDefinition taskCRSDefinition;
        CoordinateReferenceSystem typeCRS = schema.getGeometryDescriptor().getCoordinateReferenceSystem();
        if (typeCRS != null && (taskCRSDefinition = context.getTask().getCRSDefinition()) != null && taskCRSDefinition.getCRS() != null && !CRS.equalsIgnoreMetadata((Object)typeCRS, (Object)taskCRSDefinition.getCRS())) {
            CRSDefinition crsDefinition;
            ReferenceIdentifier identifier = AbstractIdentifiedObject.getIdentifier((IdentifiedObject)typeCRS, (Citation)Citations.EPSG);
            String crsName = identifier != null ? ((crsDefinition = CRSDefFactory.getCRSDefinition((String)identifier.getCode())) != CRSDefFactory.getDefaultCRSDefinition() ? crsDefinition.getName() : identifier.toString()) : typeCRS.getName().toString();
            this.messages.put(ImportMessagesTypes.CRS_DOES_NOT_MATCH, new Object[]{crsName});
        }
        Envelope layerBounds = ly.getEnvelope();
        Envelope projectBounds = lyMngr.getTask().getInitialView();
        Envelope visibleBounds = context.getLayerViewPanel().getViewport().getEnvelopeInModelCoordinates();
        if (!(projectBounds == null || projectBounds.isNull() || visibleBounds == null || visibleBounds.isNull() || layerBounds == null || layerBounds.isNull() || projectBounds.intersects(layerBounds) || visibleBounds.intersects(layerBounds))) {
            this.messages.put(ImportMessagesTypes.OUTSIDE_BOUNDS, new Object[0]);
        }
    }

    public void displayMessageOrThrow() {
        if (this.messages.isEmpty()) {
            return;
        }
        SwingUtilities.invokeLater(() -> {
            if (this.messages.containsKey((Object)ImportMessagesTypes.CRS_DOES_NOT_MATCH)) {
                JOptionPane.showMessageDialog(WorkbenchContext.getFrame(), this.i18nMapper.apply(ImportMessagesTypes.CRS_DOES_NOT_MATCH, this.messages.get((Object)ImportMessagesTypes.CRS_DOES_NOT_MATCH)), I18N.get("common.message"), 2);
            }
            if (this.messages.containsKey((Object)ImportMessagesTypes.OUTSIDE_BOUNDS)) {
                SelfClosingMessageBox msgBox = new SelfClosingMessageBox((Window)JUMPWorkbench.getFrame(), this.i18nMapper.apply(ImportMessagesTypes.OUTSIDE_BOUNDS, this.messages.get((Object)ImportMessagesTypes.OUTSIDE_BOUNDS)), 3000);
                msgBox.setVisible(true);
            }
        });
    }

    public static enum ImportMessagesTypes {
        CRS_DOES_NOT_MATCH,
        OUTSIDE_BOUNDS;

    }
}

