/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.workbench.renderer;

import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.Viewport;
import com.vividsolutions.jump.workbench.ui.WorkbenchFrame;
import com.vividsolutions.jump.workbench.ui.renderer.Renderer;
import com.vividsolutions.jump.workbench.ui.renderer.style.RenderUtil;
import de.riwagis.riwajump.symbol.resources.BuildInSymbolStore;
import de.riwagis.riwajump.workbench.renderer.GenericOverlayFeature;
import de.riwagis.riwajump.workbench.renderer.GenericOverlayPlugin;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.Map;
import org.locationtech.jts.geom.Geometry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericOverlayRenderer
implements Renderer {
    private static final Logger LOG = LoggerFactory.getLogger(GenericOverlayRenderer.class);
    private final LayerViewPanel layerViewPanel;
    private final String contentID;

    public GenericOverlayRenderer(LayerViewPanel layerViewPanel, String contentID) {
        this.layerViewPanel = layerViewPanel;
        this.contentID = contentID;
    }

    @Override
    public void clearImageCache() {
    }

    @Override
    public boolean isRendering() {
        return false;
    }

    @Override
    public Object getContentID() {
        return this.contentID;
    }

    @Override
    public void copyTo(Graphics2D graphics) {
        if (graphics.getRenderingHint(Viewport.KEY_IS4PRINT) != Viewport.VALUE_IS4PRINT) {
            try {
                Viewport viewport = this.layerViewPanel.getViewport();
                Map<String, GenericOverlayFeature> features = GenericOverlayPlugin.getFeatures();
                Collection<String> featuresInvisible = GenericOverlayPlugin.getFeaturesInvisible();
                for (Map.Entry<String, GenericOverlayFeature> featureEntry : features.entrySet()) {
                    GenericOverlayFeature feature = featureEntry.getValue();
                    if (feature.getGeometries() == null || featuresInvisible.contains(featureEntry.getKey())) continue;
                    if (feature.getSymbol() == null) {
                        for (Geometry geom : feature.getGeometries()) {
                            RenderUtil.paint(geom, graphics, viewport, true, feature.getFillStroke(), feature.getFillColor(), true, feature.getLineStroke(), feature.getLineColor(), false, true);
                        }
                        continue;
                    }
                    for (Geometry geom : feature.getGeometries()) {
                        Point2D viewPoint = viewport.toViewPoint(geom.getCentroid().getCoordinate());
                        AffineTransform transe = new AffineTransform();
                        transe.translate(viewPoint.getX(), viewPoint.getY());
                        transe.rotate(Math.toRadians(feature.getOrientation()));
                        BuildInSymbolStore symStore = BuildInSymbolStore.getInstance();
                        symStore.renderSymbol(feature.getSymbol(), graphics, transe, feature.getSymbolSize(), null, null);
                    }
                }
            }
            catch (Throwable t) {
                this.layerViewPanel.getContext().warnUser(WorkbenchFrame.toMessage(t));
                LOG.warn(String.format("Error rendering GlobeSpotter data: %s", t.getMessage()), t);
            }
        }
    }

    @Override
    public Runnable createRunnable() {
        return null;
    }

    @Override
    public void cancel() {
    }
}

