/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.workbench.renderer;

import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.TaskFrame;
import com.vividsolutions.jump.workbench.ui.renderer.Renderer;
import com.vividsolutions.jump.workbench.ui.renderer.factory.RendererFactory;
import de.riwagis.riwajump.workbench.renderer.GenericOverlayFeature;
import de.riwagis.riwajump.workbench.renderer.GenericOverlayRenderer;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericOverlayPlugin
extends AbstractPlugIn {
    private static final Logger LOG = LoggerFactory.getLogger(GenericOverlayPlugin.class);
    public static final String GENERICOVERLAY_FEATURES = "GENERICOVERLAY_FEATURES";
    private static final String GENERICOVERLAY_INVISIBLE = "GENERICOVERLAY_VISIBILTIY";
    private static final Lock FEATURELISTLOCK = new ReentrantLock();

    public static void setVisible(String featureID, boolean visible) {
        FEATURELISTLOCK.lock();
        try {
            Collection<String> featuresVisibility = GenericOverlayPlugin.getFeaturesInvisibleInternal();
            if (visible) {
                featuresVisibility.remove(featureID);
            } else {
                featuresVisibility.add(featureID);
            }
        }
        finally {
            FEATURELISTLOCK.unlock();
        }
    }

    private static Collection<String> getFeaturesInvisibleInternal() {
        if (!WorkbenchContext.getBlackboard().contains(GENERICOVERLAY_INVISIBLE)) {
            WorkbenchContext.getBlackboard().put(GENERICOVERLAY_INVISIBLE, new LinkedHashSet());
        }
        Collection featuresVisibility = (Collection)WorkbenchContext.getBlackboard().get(GENERICOVERLAY_INVISIBLE);
        return featuresVisibility;
    }

    public static Collection<String> getFeaturesInvisible() {
        FEATURELISTLOCK.lock();
        try {
            Collection<String> features = GenericOverlayPlugin.getFeaturesInvisibleInternal();
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(features);
            return linkedHashSet;
        }
        finally {
            FEATURELISTLOCK.unlock();
        }
    }

    public GenericOverlayPlugin() {
        LOG.info("instance created: " + this.getClass().getCanonicalName());
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
        LOG.info(String.format("initializing: %s", this.getName()));
        context.getWorkbenchFrame().getDesktopPane().addContainerListener(new ContainerAdapter(this){

            @Override
            public void componentAdded(ContainerEvent e) {
                if (!(e.getChild() instanceof TaskFrame)) {
                    return;
                }
                final TaskFrame taskFrame = (TaskFrame)e.getChild();
                taskFrame.getLayerViewPanel().getRenderingManager().putAboveLayerables(GenericOverlayPlugin.GENERICOVERLAY_FEATURES, new RendererFactory(){

                    @Override
                    public Renderer create() {
                        return new GenericOverlayRenderer(taskFrame.getLayerViewPanel(), GenericOverlayPlugin.GENERICOVERLAY_FEATURES);
                    }
                });
            }
        });
    }

    @Override
    public boolean isUndoable() {
        return false;
    }

    @Override
    public String getName() {
        return "GenericOverlay";
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        return false;
    }

    public static Map<String, GenericOverlayFeature> getFeatures() {
        FEATURELISTLOCK.lock();
        try {
            Map<String, GenericOverlayFeature> features = GenericOverlayPlugin.getFeaturesInternal();
            LinkedHashMap<String, GenericOverlayFeature> linkedHashMap = new LinkedHashMap<String, GenericOverlayFeature>(features);
            return linkedHashMap;
        }
        finally {
            FEATURELISTLOCK.unlock();
        }
    }

    public static void addFeature(String featID, GenericOverlayFeature feat) {
        FEATURELISTLOCK.lock();
        try {
            Map<String, GenericOverlayFeature> features = GenericOverlayPlugin.getFeaturesInternal();
            features.put(featID, feat);
        }
        finally {
            FEATURELISTLOCK.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GenericOverlayFeature removeFeature(String featID) {
        FEATURELISTLOCK.lock();
        try {
            Collection<String> featuresInvisible = GenericOverlayPlugin.getFeaturesInvisibleInternal();
            featuresInvisible.remove(featID);
            Map<String, GenericOverlayFeature> features = GenericOverlayPlugin.getFeaturesInternal();
            GenericOverlayFeature genericOverlayFeature = features.remove(featID);
            return genericOverlayFeature;
        }
        finally {
            FEATURELISTLOCK.unlock();
        }
    }

    private static Map<String, GenericOverlayFeature> getFeaturesInternal() {
        if (!WorkbenchContext.getBlackboard().contains(GENERICOVERLAY_FEATURES)) {
            WorkbenchContext.getBlackboard().put(GENERICOVERLAY_FEATURES, new LinkedHashMap());
        }
        Map features = (Map)WorkbenchContext.getBlackboard().get(GENERICOVERLAY_FEATURES);
        return features;
    }

    public static GenericOverlayFeature getFeature(String featID) {
        FEATURELISTLOCK.lock();
        try {
            Map<String, GenericOverlayFeature> features = GenericOverlayPlugin.getFeaturesInternal();
            GenericOverlayFeature genericOverlayFeature = features.get(featID);
            return genericOverlayFeature;
        }
        finally {
            FEATURELISTLOCK.unlock();
        }
    }

    public static boolean hasFeature(String featID) {
        FEATURELISTLOCK.lock();
        try {
            Map<String, GenericOverlayFeature> features = GenericOverlayPlugin.getFeaturesInternal();
            boolean bl = features.containsKey(featID);
            return bl;
        }
        finally {
            FEATURELISTLOCK.unlock();
        }
    }
}

