/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.workbench.renderer;

import java.awt.Color;
import java.awt.Stroke;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.locationtech.jts.geom.Geometry;

public class GenericOverlayFeature {
    private final List<Geometry> geometries;
    private final Stroke lineStroke;
    private final Color lineColor;
    private final Stroke fillStroke;
    private final Color fillColor;
    private final String symbol;
    private final Integer symbolSize;
    private final Double orientation;

    public GenericOverlayFeature(Geometry geometry, Stroke lineStroke, Color lineColor, Stroke fillStroke, Color fillColor) {
        this(geometry, lineStroke, lineColor, fillStroke, fillColor, null, (Integer)0, (Double)0.0);
    }

    public GenericOverlayFeature(Collection<Geometry> geometries, Stroke lineStroke, Color lineColor, Stroke fillStroke, Color fillColor) {
        this(geometries, lineStroke, lineColor, fillStroke, fillColor, null, (Integer)0, (Double)0.0);
    }

    public GenericOverlayFeature(Geometry geometry, Stroke lineStroke, Color lineColor, Stroke fillStroke, Color fillColor, String symbol, Integer symbolSize, Double orientation) {
        this(Arrays.asList(geometry), lineStroke, lineColor, fillStroke, fillColor, symbol, symbolSize, orientation);
    }

    public GenericOverlayFeature(Collection<Geometry> geometries, Stroke lineStroke, Color lineColor, Stroke fillStroke, Color fillColor, String symbol, Integer symbolSize, Double orientation) {
        this.geometries = new ArrayList<Geometry>(geometries);
        this.lineStroke = lineStroke;
        this.lineColor = lineColor;
        this.fillStroke = fillStroke;
        this.fillColor = fillColor;
        this.symbol = symbol;
        this.symbolSize = symbolSize;
        this.orientation = orientation;
    }

    public Collection<Geometry> getGeometries() {
        return Collections.unmodifiableCollection(this.geometries);
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public Stroke getFillStroke() {
        return this.fillStroke;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public Stroke getLineStroke() {
        return this.lineStroke;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public Integer getSymbolSize() {
        return this.symbolSize;
    }

    public Double getOrientation() {
        return this.orientation;
    }

    public String toString() {
        return String.format("geom count: %d (line: %s/%s, fill: %s/%s)", this.geometries.size(), this.lineStroke, this.lineStroke, this.fillColor, this.fillStroke);
    }
}

