/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.symbol.resources;

import com.vividsolutions.jump.workbench.model.CadLayerSymbolDefinition;
import com.vividsolutions.jump.workbench.model.redline.RedlineGlobalStyles;
import de.riwagis.riwajump.symbol.AbstractSymbolStore;
import de.riwagis.riwajump.symbol.resources.BuildInSymbolStore;
import de.riwagis.riwajump.symbol.resources.ChainingSymbolStore;
import de.riwagis.riwajump.symbol.resources.InMemorySymbolStore;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.tuple.Pair;

public class RedlineLayerSymbolStore
extends ChainingSymbolStore {
    private final InMemorySymbolStore redlineStore;

    protected RedlineLayerSymbolStore(List<AbstractSymbolStore> stores, InMemorySymbolStore redlineStore) {
        super(stores);
        this.redlineStore = redlineStore;
    }

    public boolean isUserDefinedSymbol(String name) {
        return this.redlineStore.containsSymbol(name);
    }

    public boolean removeSymbol(String name) {
        return this.getUserStore().removeSymbol(name);
    }

    public void addSymbol(CadLayerSymbolDefinition definition, ByteBuffer image) {
        this.getUserStore().addSymbol(definition, image);
    }

    public void addSymbolIfAbsent(CadLayerSymbolDefinition definition, ByteBuffer image) {
        this.getUserStore().addSymbolIfAbsent(definition, image);
    }

    public CadLayerSymbolDefinition renameSymbol(String symbolName, String newDisplayName) {
        return this.getUserStore().renameSymbol(symbolName, newDisplayName);
    }

    public void addSymbol(String name, ByteBuffer image) {
        this.getUserStore().addSymbol(name, image);
    }

    public void clear() {
        this.getUserStore().clear();
    }

    public Collection<Pair<CadLayerSymbolDefinition, ByteBuffer>> getDefinitionsAndData() {
        return this.getUserStore().getDefinitionsAndData();
    }

    @Override
    public String[] getSymbolNames() {
        return this.getUserStore().getSymbolNames();
    }

    public Pair<CadLayerSymbolDefinition, ByteBuffer> getDefinitionAndData(String symbolName) {
        return this.getUserStore().getDefinitionAndData(symbolName);
    }

    private InMemorySymbolStore getUserStore() {
        return this.redlineStore;
    }

    public RedlineLayerSymbolStore copyWithGlobals() {
        RedlineLayerSymbolStore copy = RedlineLayerSymbolStore.createWithGlobals();
        copy.getUserStore().addAll(this.getUserStore());
        return copy;
    }

    public void assign(RedlineLayerSymbolStore source) {
        this.clearCache();
        this.getUserStore().clear();
        this.getUserStore().addAll(source.getUserStore());
    }

    public boolean containsDisplayName(String name) {
        return this.getAllSymbolDefinitions().stream().filter(def -> Objects.equals(name, def.getName())).findFirst().isPresent();
    }

    @Override
    public String getName() {
        return "Redline Layer Symbol Store";
    }

    @Override
    public String getDescription() {
        return "Store holding built-in and custom redline layer symbols.";
    }

    public static RedlineLayerSymbolStore createSimple() {
        InMemorySymbolStore copyStore = new InMemorySymbolStore();
        return new RedlineLayerSymbolStore(Collections.singletonList(copyStore), copyStore);
    }

    public static RedlineLayerSymbolStore createWithGlobals() {
        InMemorySymbolStore copyStore = new InMemorySymbolStore();
        return new RedlineLayerSymbolStore(List.of(copyStore, RedlineGlobalStyles.getInstance().getGlobalStore(), BuildInSymbolStore.getInstance()), copyStore);
    }

    public static RedlineLayerSymbolStore createFromExistingWithGlobals(InMemorySymbolStore userStore) {
        return new RedlineLayerSymbolStore(List.of(userStore, RedlineGlobalStyles.getInstance().getGlobalStore(), BuildInSymbolStore.getInstance()), userStore);
    }

    public static RedlineLayerSymbolStore createWithoutGlobals() {
        InMemorySymbolStore copyStore = new InMemorySymbolStore();
        return new RedlineLayerSymbolStore(List.of(copyStore, BuildInSymbolStore.getInstance()), copyStore);
    }

    public AbstractSymbolStore createReadOnlyWithGlobals() {
        return RedlineLayerSymbolStore.createFromExistingWithGlobals(this.redlineStore);
    }
}

