/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.symbol.resources;

import com.vividsolutions.jump.workbench.model.CadLayerSymbolDefinition;
import de.riwagis.riwajump.symbol.AbstractSymbolStore;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemorySymbolStore
extends AbstractSymbolStore {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InMemorySymbolStore.class);
    private final Map<String, Pair<CadLayerSymbolDefinition, ByteBuffer>> symbols = new HashMap<String, Pair<CadLayerSymbolDefinition, ByteBuffer>>();

    @Override
    public InputStream getStreamByName(String strName) {
        ByteBuffer symbolBuffer = (ByteBuffer)this.symbols.get(strName).getRight();
        if (symbolBuffer != null && symbolBuffer.hasArray()) {
            return new ByteArrayInputStream(symbolBuffer.array());
        }
        return null;
    }

    @Override
    public String getName() {
        return "In-Memory Symbol Store";
    }

    @Override
    public String getDescription() {
        return "Meta Store holding PNG and SVG images in-memory. Symbols must be provided by application";
    }

    @Override
    public String testConnection() {
        return null;
    }

    @Override
    public String[] getSymbolNames() {
        Set<String> names = this.symbols.keySet();
        return names.toArray(new String[names.size()]);
    }

    public boolean removeSymbol(String name) {
        return this.symbols.remove(name) != null;
    }

    public void addSymbol(CadLayerSymbolDefinition definition, ByteBuffer image) {
        this.symbols.put(definition.getSymbolName(), (Pair<CadLayerSymbolDefinition, ByteBuffer>)Pair.of((Object)definition, (Object)image));
    }

    public void addSymbolIfAbsent(CadLayerSymbolDefinition definition, ByteBuffer image) {
        this.symbols.putIfAbsent(definition.getSymbolName(), (Pair<CadLayerSymbolDefinition, ByteBuffer>)Pair.of((Object)definition, (Object)image));
    }

    public void addSymbol(String name, ByteBuffer image) {
        this.symbols.put(name, (Pair<CadLayerSymbolDefinition, ByteBuffer>)Pair.of((Object)new CadLayerSymbolDefinition(name), (Object)image));
    }

    public void addAll(InMemorySymbolStore source) {
        this.symbols.putAll(source.symbols);
    }

    public void clear() {
        this.symbols.clear();
        this.clearCache();
    }

    @Override
    public List<CadLayerSymbolDefinition> getAllSymbolDefinitions() {
        return this.symbols.values().stream().map(Pair::getLeft).sorted().collect(Collectors.toUnmodifiableList());
    }

    public CadLayerSymbolDefinition renameSymbol(String symbolName, String newDisplayName) {
        Pair<CadLayerSymbolDefinition, ByteBuffer> old = this.symbols.get(symbolName);
        if (old != null) {
            this.removeSymbol(symbolName);
            CadLayerSymbolDefinition newDef = new CadLayerSymbolDefinition(newDisplayName, ((CadLayerSymbolDefinition)old.getLeft()).getSymbolName());
            this.addSymbol(newDef, (ByteBuffer)old.getRight());
            return newDef;
        }
        return null;
    }

    public int getSize() {
        return this.symbols.size();
    }

    public Collection<Pair<CadLayerSymbolDefinition, ByteBuffer>> getDefinitionsAndData() {
        return this.symbols.values();
    }

    public Pair<CadLayerSymbolDefinition, ByteBuffer> getDefinitionAndData(String symbolName) {
        return this.symbols.get(symbolName);
    }

    @Override
    public boolean containsSymbol(String name) {
        return this.symbols.containsKey(name);
    }
}

