/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.symbol.resources;

import com.vividsolutions.jump.workbench.model.CadLayerSymbolDefinition;
import de.riwagis.riwajump.symbol.AbstractSymbolStore;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;

public class ChainingSymbolStore
extends AbstractSymbolStore {
    private final List<AbstractSymbolStore> stores;
    private final List<AbstractSymbolStore> reverseStores;

    public ChainingSymbolStore(List<AbstractSymbolStore> stores) {
        this.stores = stores;
        this.reverseStores = new ArrayList<AbstractSymbolStore>(stores);
        Collections.reverse(this.reverseStores);
    }

    @Override
    public InputStream getStreamByName(String strName) throws IOException {
        for (AbstractSymbolStore store : this.stores) {
            if (!store.containsSymbol(strName)) continue;
            return store.getStreamByName(strName);
        }
        return null;
    }

    @Override
    public String getName() {
        return "Chaining Symbol Store";
    }

    @Override
    public String getDescription() {
        return "Store combining multiple stores";
    }

    @Override
    public String testConnection() {
        return null;
    }

    @Override
    public String[] getSymbolNames() {
        String[] identity = new String[]{};
        return this.stores.stream().map(a -> a.getSymbolNames()).reduce(identity, (a, b) -> (String[])ArrayUtils.addAll((Object[])a, (Object[])b));
    }

    @Override
    public boolean containsSymbol(String name) {
        for (AbstractSymbolStore store : this.stores) {
            if (!store.containsSymbol(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<CadLayerSymbolDefinition> getFillDefinitions() {
        return this.stores.stream().flatMap(s -> s.getFillDefinitions().stream()).distinct().collect(Collectors.toUnmodifiableList());
    }

    @Override
    public List<CadLayerSymbolDefinition> getSymbolDefinitions() {
        return this.stores.stream().flatMap(s -> s.getSymbolDefinitions().stream()).distinct().collect(Collectors.toUnmodifiableList());
    }

    @Override
    public List<CadLayerSymbolDefinition> getAllSymbolDefinitions() {
        return this.stores.stream().flatMap(s -> s.getAllSymbolDefinitions().stream()).distinct().collect(Collectors.toUnmodifiableList());
    }

    public int getStoreIndexForSymbol(String symbol) {
        int index = 0;
        for (AbstractSymbolStore store : this.stores) {
            if (store.containsSymbol(symbol)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public AbstractSymbolStore getStoreForSymbol(String symbol) {
        for (AbstractSymbolStore store : this.stores) {
            if (!store.containsSymbol(symbol)) continue;
            return store;
        }
        return null;
    }

    protected List<AbstractSymbolStore> getStores() {
        return Collections.unmodifiableList(this.stores);
    }
}

