/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.symbol.resources;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.model.CadLayerSymbolDefinition;
import de.riwagis.riwajump.symbol.AbstractSymbolStore;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class BuildInSymbolStore
extends AbstractSymbolStore {
    private static final List<CadLayerSymbolDefinition> SYMBOLS = List.of(new CadLayerSymbolDefinition(I18N.get("model.RedlineLayer.symbols.cross"), "cross.svg"), new CadLayerSymbolDefinition(I18N.get("model.RedlineLayer.symbols.circle"), "circle.svg"), new CadLayerSymbolDefinition(I18N.get("model.RedlineLayer.symbols.button-red"), "button-red.svg"), new CadLayerSymbolDefinition(I18N.get("model.RedlineLayer.symbols.button-black"), "button-black.svg"), new CadLayerSymbolDefinition(I18N.get("model.RedlineLayer.symbols.button-blue"), "button-blue.svg"), new CadLayerSymbolDefinition(I18N.get("model.RedlineLayer.symbols.button-green"), "button-green.svg"), new CadLayerSymbolDefinition(I18N.get("model.RedlineLayer.symbols.button-seagreen"), "button-seagreen.svg"), new CadLayerSymbolDefinition(I18N.get("model.RedlineLayer.symbols.triangle-empty"), "triangle-empty.svg"), new CadLayerSymbolDefinition(I18N.get("model.RedlineLayer.symbols.triangle-black"), "triangle-black.svg"), new CadLayerSymbolDefinition(I18N.get("model.RedlineLayer.symbols.triangle-blue"), "triangle-blue.svg"), new CadLayerSymbolDefinition(I18N.get("model.RedlineLayer.symbols.triangle-green"), "triangle-green.svg"), new CadLayerSymbolDefinition(I18N.get("model.RedlineLayer.symbols.triangle-red"), "triangle-red.svg"), new CadLayerSymbolDefinition(I18N.get("model.RedlineLayer.symbols.square-empty"), "square-empty.svg"), new CadLayerSymbolDefinition(I18N.get("model.RedlineLayer.symbols.square-red"), "square-red.svg"), new CadLayerSymbolDefinition(I18N.get("model.RedlineLayer.symbols.square-black"), "square-black.svg"), new CadLayerSymbolDefinition(I18N.get("model.RedlineLayer.symbols.square-blue"), "square-blue.svg"), new CadLayerSymbolDefinition(I18N.get("model.RedlineLayer.symbols.square-green"), "square-green.svg"), new CadLayerSymbolDefinition(I18N.get("model.RedlineLayer.symbols.arrow-red"), "arrow-red.svg"), new CadLayerSymbolDefinition(I18N.get("model.RedlineLayer.symbols.arrow-black"), "arrow-black.svg"), new CadLayerSymbolDefinition(I18N.get("model.RedlineLayer.symbols.arrow-blue"), "arrow-blue.svg"), new CadLayerSymbolDefinition(I18N.get("model.RedlineLayer.symbols.arrow-green"), "arrow-green.svg"), new CadLayerSymbolDefinition(I18N.get("model.RedlineLayer.symbols.flag"), "flag.svg"), new CadLayerSymbolDefinition(I18N.get("model.RedlineLayer.symbols.pin"), "pin.svg"), new CadLayerSymbolDefinition(I18N.get("model.RedlineLayer.symbols.cubo-rosso"), "cubo_rosso.svg"), new CadLayerSymbolDefinition(I18N.get("model.RedlineLayer.symbols.brush"), "brush.svg"), new CadLayerSymbolDefinition(I18N.get("model.RedlineLayer.symbols.pen"), "pen.svg"), new CadLayerSymbolDefinition(I18N.get("model.RedlineLayer.symbols.star"), "star.svg"), new CadLayerSymbolDefinition(I18N.get("model.RedlineLayer.symbols.foot"), "foot.svg"), new CadLayerSymbolDefinition(I18N.get("model.RedlineLayer.symbols.person"), "person.svg"), new CadLayerSymbolDefinition(I18N.get("model.RedlineLayer.symbols.tree"), "tree.svg"), new CadLayerSymbolDefinition(I18N.get("model.RedlineLayer.symbols.world"), "world.svg"), new CadLayerSymbolDefinition(I18N.get("model.RedlineLayer.symbols.xls"), "xls.svg"), new CadLayerSymbolDefinition(I18N.get("model.RedlineLayer.symbols.northarrow"), "northarrow.svg"), new CadLayerSymbolDefinition(I18N.get("model.RedlineLayer.symbols.image"), "image.svg"), new CadLayerSymbolDefinition(I18N.get("model.RedlineLayer.symbols.car-blue"), "car-blue.svg"), new CadLayerSymbolDefinition(I18N.get("model.RedlineLayer.symbols.car-white"), "car-white.svg"), new CadLayerSymbolDefinition(I18N.get("model.RedlineLayer.symbols.car-red"), "car-red.svg"));
    private static final List<CadLayerSymbolDefinition> FILLS = List.of(new CadLayerSymbolDefinition(I18N.get("model.RedlineLayer.symbols.hatch-left-right"), "hatch-left-right.svg"), new CadLayerSymbolDefinition(I18N.get("model.RedlineLayer.symbols.hatch-right-left"), "hatch-right-left.svg"), new CadLayerSymbolDefinition(I18N.get("model.RedlineLayer.symbols.hatch-vertical"), "hatch-vertical.svg"), new CadLayerSymbolDefinition(I18N.get("model.RedlineLayer.symbols.hatch-horizontal"), "hatch-horizontal.svg"), new CadLayerSymbolDefinition(I18N.get("model.RedlineLayer.symbols.hatch-dot"), "hatch-dot.svg"), new CadLayerSymbolDefinition(I18N.get("model.RedlineLayer.symbols.hatch-transparent"), "hatch-transparent.svg"));
    private static BuildInSymbolStore instance;
    private final Set<String> symbolNames = new TreeSet<String>();

    private BuildInSymbolStore() {
        List allSymbolNames = Stream.concat(SYMBOLS.stream(), FILLS.stream()).map(def -> def.getSymbolName()).collect(Collectors.toUnmodifiableList());
        this.symbolNames.addAll(allSymbolNames);
    }

    private BuildInSymbolStore(String[] symbols) {
        this.symbolNames.addAll(Arrays.asList(symbols));
    }

    @Override
    public String getName() {
        return "Build in Symbols";
    }

    @Override
    public String getDescription() {
        return "Build in SVG and PNG files.";
    }

    @Override
    public String[] getSymbolNames() {
        return this.symbolNames.toArray(new String[this.symbolNames.size()]);
    }

    @Override
    public InputStream getStreamByName(String strName) throws IOException {
        URL url = this.getClass().getResource(strName);
        if (url != null) {
            return this.getClass().getResourceAsStream(strName);
        }
        throw new FileNotFoundException(strName);
    }

    public static BuildInSymbolStore createNewBuildInSymbolStore(String[] syms) {
        return new BuildInSymbolStore(syms);
    }

    @Override
    public String testConnection() {
        return null;
    }

    public static synchronized BuildInSymbolStore getInstance() {
        if (instance == null) {
            instance = new BuildInSymbolStore();
        }
        return instance;
    }

    @Override
    public List<CadLayerSymbolDefinition> getFillDefinitions() {
        return FILLS;
    }

    @Override
    public List<CadLayerSymbolDefinition> getSymbolDefinitions() {
        return SYMBOLS;
    }

    @Override
    public List<CadLayerSymbolDefinition> getAllSymbolDefinitions() {
        ArrayList<CadLayerSymbolDefinition> bothSymbols = new ArrayList<CadLayerSymbolDefinition>(SYMBOLS);
        bothSymbols.addAll(FILLS);
        return bothSymbols;
    }
}

