/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.symbol.model;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.StyleCollection;
import de.riwagis.riwajump.model.style.BasicStyleModel;
import de.riwagis.riwajump.model.style.StyleModel;
import de.riwagis.riwajump.model.style.SymbolStyleModel;
import de.riwagis.riwajump.symbol.model.SymbolstoreMetadata;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

@XStreamAlias(value="smdcol")
public class SMDCollection
implements Serializable,
Iterable<SymbolstoreMetadata> {
    @XStreamAlias(value="smdlist")
    private List<SymbolstoreMetadata> stores;

    public SMDCollection(List<SymbolstoreMetadata> stores) {
        this.stores = stores;
        this.sortList();
    }

    public SMDCollection() {
        this(new ArrayList<SymbolstoreMetadata>());
    }

    public List<SymbolstoreMetadata> getInternalList() {
        return Collections.unmodifiableList(this.stores);
    }

    @Override
    public Iterator<SymbolstoreMetadata> iterator() {
        return this.stores.iterator();
    }

    public List<SymbolstoreMetadata> getCloneList() {
        ArrayList<SymbolstoreMetadata> lstClone = new ArrayList<SymbolstoreMetadata>();
        for (SymbolstoreMetadata currEntry : this.stores) {
            lstClone.add(currEntry.clone());
        }
        return lstClone;
    }

    public SymbolstoreMetadata getByName(String strName) {
        for (SymbolstoreMetadata currEntry : this.stores) {
            if (!currEntry.getName().equals(strName)) continue;
            return currEntry;
        }
        return null;
    }

    public final void sortList() {
        this.stores = this.stores.stream().sorted().collect(Collectors.toList());
    }

    public int addSymbolstore(SymbolstoreMetadata dataMeta) {
        if (!this.stores.contains(dataMeta)) {
            this.stores.add(dataMeta);
        }
        return this.stores.indexOf(dataMeta);
    }

    public void replaceSymbolstore(SymbolstoreMetadata oldMeta, SymbolstoreMetadata newMeta) {
        if (this.stores.contains(oldMeta)) {
            this.removeSymbolstore(oldMeta);
            this.addSymbolstore(newMeta);
            if (!oldMeta.getName().equals(newMeta.getName())) {
                for (Layerable layerable : WorkbenchContext.getTask().getLayerManager().getRootCatLocal().getAllLayerables()) {
                    this.updateDMDs(oldMeta, newMeta, layerable);
                }
            }
        }
    }

    private void updateDMDs(SymbolstoreMetadata oldMeta, SymbolstoreMetadata newMeta, Layerable layerable) {
        if (layerable instanceof Layer) {
            Layer layer = (Layer)layerable;
            for (StyleCollection styleCol : layer.getStyleCollections()) {
                for (StyleModel styleModel : styleCol.getStyles()) {
                    this.updateDMD(oldMeta, newMeta, styleModel);
                }
            }
        }
    }

    private void updateDMD(SymbolstoreMetadata oldMeta, SymbolstoreMetadata newMeta, StyleModel styleModel) {
        if (styleModel instanceof BasicStyleModel) {
            SymbolStyleModel symbolStyleModel;
            if (oldMeta.getName().equals(((BasicStyleModel)styleModel).getStrFillSymStore())) {
                ((BasicStyleModel)styleModel).setStrFillSymStore(newMeta.getName());
            }
            if ((symbolStyleModel = ((BasicStyleModel)styleModel).getSymStyle()) != null && oldMeta.getName().equals(symbolStyleModel.getStrStorename())) {
                symbolStyleModel.setStrStorename(newMeta.getName());
            }
        }
    }

    public int removeSymbolstore(SymbolstoreMetadata dataMeta) {
        int index = this.stores.indexOf(dataMeta);
        if (this.stores.contains(dataMeta)) {
            this.stores.remove(dataMeta);
        }
        return index;
    }

    public void addAll(SMDCollection other) {
        this.stores.addAll(other.getInternalList());
    }
}

