/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.symbol.gui;

import com.vividsolutions.jump.I18N;
import de.riwagis.riwajump.symbol.SymbolStoreFinder;
import de.riwagis.riwajump.symbol.model.SymbolstoreMetadata;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class SymbolstorePanel
extends JPanel {
    private SymbolstoreMetadata smd = new SymbolstoreMetadata();
    private boolean blockEvents = false;
    private final JFileChooser dirChooser = new JFileChooser();
    private JButton butTest;
    private JButton butURL;
    private JLabel lblName;
    private JLabel lblSymbolstore;
    private JLabel lblURL;
    private JComboBox lstSymbolstore;
    private JTextField txtName;
    private JTextField txtURL;

    public SymbolstorePanel() {
        this.initComponents();
        this.i18n();
        this.dirChooser.setFileSelectionMode(1);
        for (String arrPrefixe : SymbolStoreFinder.getPrefixes()) {
            this.lstSymbolstore.addItem(arrPrefixe);
        }
    }

    private void i18n() {
        this.lblName.setText(I18N.get("de.riwagis.riwajump.SymbolstorePanel.store-name"));
        this.lblURL.setText(I18N.get("de.riwagis.riwajump.SymbolstorePanel.store-url"));
        this.lblSymbolstore.setText(I18N.get("de.riwagis.riwajump.SymbolstorePanel.symbolstore"));
        this.butTest.setText(I18N.get("de.riwagis.riwajump.SymbolstorePanel.test-connection"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSMD(SymbolstoreMetadata _smd) {
        this.smd = _smd;
        this.blockEvents = true;
        try {
            this.txtName.setText(this.smd.getName());
            String strURL = this.smd.getURL();
            int idxPrefix = strURL.indexOf(58);
            if (idxPrefix != -1) {
                String strPrefix = strURL.substring(0, idxPrefix);
                this.lstSymbolstore.setSelectedItem(strPrefix);
                strURL = strURL.substring(idxPrefix + 1);
            }
            this.txtURL.setText(strURL);
        }
        finally {
            this.blockEvents = false;
        }
    }

    private void updateURL() {
        this.smd.setURL(this.lstSymbolstore.getSelectedItem().toString() + ":" + this.txtURL.getText());
    }

    private void initComponents() {
        this.lblName = new JLabel();
        this.lblURL = new JLabel();
        this.txtName = new JTextField();
        this.txtURL = new JTextField();
        this.butURL = new JButton();
        this.butTest = new JButton();
        this.lblSymbolstore = new JLabel();
        this.lstSymbolstore = new JComboBox();
        this.setLayout(new GridBagLayout());
        this.lblName.setText("Name:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(9, 9, 3, 3);
        this.add((Component)this.lblName, gridBagConstraints);
        this.lblURL.setText("URL:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 9, 3, 3);
        this.add((Component)this.lblURL, gridBagConstraints);
        this.txtName.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                SymbolstorePanel.this.txtName_onKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(9, 3, 3, 9);
        this.add((Component)this.txtName, gridBagConstraints);
        this.txtURL.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                SymbolstorePanel.this.txtURL_onKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.txtURL, gridBagConstraints);
        this.butURL.setText("...");
        this.butURL.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SymbolstorePanel.this.butURL_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 9);
        this.add((Component)this.butURL, gridBagConstraints);
        this.butTest.setText("Verbindung testen");
        this.butTest.setMaximumSize(new Dimension(140, 23));
        this.butTest.setPreferredSize(new Dimension(140, 23));
        this.butTest.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SymbolstorePanel.this.butTest_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 9);
        this.add((Component)this.butTest, gridBagConstraints);
        this.lblSymbolstore.setText("Symbolquelle:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 9, 3, 3);
        this.add((Component)this.lblSymbolstore, gridBagConstraints);
        this.lstSymbolstore.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SymbolstorePanel.this.lstSymbolstoreActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.lstSymbolstore, gridBagConstraints);
    }

    private void butURL_onActionPerformed(ActionEvent evt) {
        Window parent = SwingUtilities.windowForComponent(this);
        int intReturn = this.dirChooser.showOpenDialog(parent);
        if (intReturn == 1) {
            return;
        }
        this.txtURL.setText(this.dirChooser.getSelectedFile().toString());
        this.updateURL();
    }

    private void txtURL_onKeyReleased(KeyEvent evt) {
        if (this.blockEvents) {
            return;
        }
        this.updateURL();
    }

    private void txtName_onKeyReleased(KeyEvent evt) {
        if (this.blockEvents) {
            return;
        }
        this.smd.setName(this.txtName.getText());
    }

    private void butTest_onActionPerformed(ActionEvent evt) {
        if (this.blockEvents) {
            return;
        }
        String strError = null;
        try {
            strError = this.smd.getSymbolStore().testConnection();
        }
        catch (Exception e) {
            strError = e.getMessage();
        }
        if (strError == null) {
            JOptionPane.showMessageDialog(this, I18N.get("de.riwagis.riwajump.SymbolstorePanel.test-succeeded"));
        } else {
            JOptionPane.showMessageDialog(this, I18N.get("common.error") + ": " + strError);
        }
    }

    private void lstSymbolstoreActionPerformed(ActionEvent evt) {
        if (this.blockEvents) {
            return;
        }
        this.updateURL();
    }
}

