/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.symbol.gui;

import com.vividsolutions.jump.I18N;
import de.riwagis.guitools.GUIUtil;
import de.riwagis.guitools.Validator;
import de.riwagis.riwajump.symbol.gui.SymbolstoreDialog;
import de.riwagis.riwajump.symbol.gui.SymbolstoreListModel;
import de.riwagis.riwajump.symbol.model.SMDCollection;
import de.riwagis.riwajump.symbol.model.SymbolstoreMetadata;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SymbolstoreListPanel
extends JPanel {
    private static final Logger LOG = LoggerFactory.getLogger(SymbolstoreListPanel.class);
    private SMDCollection smdCol = new SMDCollection();
    private final SymbolstoreListModel listModel;
    private SymbolstoreDialog dlg = null;
    private String editName = "";
    private JButton butAdd;
    private JButton butDelCache;
    private JButton butDelete;
    private JButton butEdit;
    private JLabel jLabel1;
    private JLabel lblSymbolstores;
    private JList lstSymbolstores;
    private JPanel pnlBut;
    private JScrollPane scrSymbolstores;

    public SymbolstoreListPanel() {
        this.initComponents();
        this.i18n();
        this.listModel = new SymbolstoreListModel(this.smdCol);
        this.lstSymbolstores.setModel(this.listModel);
    }

    private void i18n() {
        this.lblSymbolstores.setText(I18N.get("de.riwagis.riwajump.SymbolstoreListPanel.symbolstores"));
        this.butAdd.setText(I18N.get("common.new"));
        this.butEdit.setText(I18N.get("common.change"));
        this.butDelete.setText(I18N.get("common.delete"));
        this.butDelCache.setText(I18N.get("de.riwagis.riwajump.SymbolstoreListPanel.delete-cache"));
    }

    public void setSMDCollection(SMDCollection _smdCol) {
        this.smdCol = _smdCol;
        this.listModel.setSMDCollection(this.smdCol);
    }

    public SymbolstoreDialog getDialog(int _intMode, SymbolstoreMetadata _mData) {
        if (this.dlg == null) {
            Window parent = SwingUtilities.windowForComponent(this);
            if (parent instanceof Frame) {
                this.dlg = new SymbolstoreDialog((Frame)parent, true, _intMode, _mData);
            }
            if (parent instanceof Dialog) {
                this.dlg = new SymbolstoreDialog((Dialog)parent, true, _intMode, _mData);
            }
            Validator validator = new Validator(){

                @Override
                public String check(Object obj) {
                    try {
                        int count = 0;
                        SymbolstoreMetadata smData = (SymbolstoreMetadata)obj;
                        for (SymbolstoreMetadata tmpData : SymbolstoreListPanel.this.smdCol) {
                            if (!tmpData.getName().equals(smData.getName())) continue;
                            ++count;
                        }
                        if (0 == SymbolstoreListPanel.this.dlg.getMode() && count > 0) {
                            return "\"" + smData.getName() + "\". " + I18N.get("de.riwagis.riwajump.SymbolstoreListPanel.duplicate-name");
                        }
                        if (1 == SymbolstoreListPanel.this.dlg.getMode() && count > 0 && !SymbolstoreListPanel.this.editName.equals(smData.getName())) {
                            return "\"" + smData.getName() + "\". " + I18N.get("de.riwagis.riwajump.SymbolstoreListPanel.duplicate-name");
                        }
                        return null;
                    }
                    catch (Exception e) {
                        return I18N.get("common.error") + " in check: " + e.getMessage();
                    }
                }
            };
            this.dlg.addValidator(validator);
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            this.dlg.setLocation((screenSize.width - this.dlg.getWidth()) / 2, (screenSize.height - this.dlg.getHeight()) / 2);
            GUIUtil.centreOnScreen(this.dlg);
            return this.dlg;
        }
        this.dlg.setMode(_intMode);
        this.dlg.setSMD(_mData);
        return this.dlg;
    }

    private void initComponents() {
        this.lblSymbolstores = new JLabel();
        this.scrSymbolstores = new JScrollPane();
        this.lstSymbolstores = new JList();
        this.pnlBut = new JPanel();
        this.butAdd = new JButton();
        this.butEdit = new JButton();
        this.butDelete = new JButton();
        this.jLabel1 = new JLabel();
        this.butDelCache = new JButton();
        this.setLayout(new GridBagLayout());
        this.lblSymbolstores.setText("Symbolquellen:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(9, 9, 3, 9);
        this.add((Component)this.lblSymbolstores, gridBagConstraints);
        this.scrSymbolstores.setMinimumSize(new Dimension(150, 200));
        this.scrSymbolstores.setPreferredSize(new Dimension(150, 200));
        this.lstSymbolstores.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SymbolstoreListPanel.this.lstSymbolstores_onMouseClicked(evt);
            }
        });
        this.scrSymbolstores.setViewportView(this.lstSymbolstores);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 9, 9, 3);
        this.add((Component)this.scrSymbolstores, gridBagConstraints);
        this.pnlBut.setLayout(new GridLayout(5, 1, 3, 4));
        this.butAdd.setText("neu");
        this.butAdd.setMinimumSize(new Dimension(80, 23));
        this.butAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SymbolstoreListPanel.this.butAdd_onActionPerformed(evt);
            }
        });
        this.pnlBut.add(this.butAdd);
        this.butEdit.setText("\u00e4ndern");
        this.butEdit.setMinimumSize(new Dimension(80, 23));
        this.butEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SymbolstoreListPanel.this.butEdit_onActionPerformed(evt);
            }
        });
        this.pnlBut.add(this.butEdit);
        this.butDelete.setText("l\u00f6schen");
        this.butDelete.setMinimumSize(new Dimension(80, 23));
        this.butDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SymbolstoreListPanel.this.butDelete_onActionPerformed(evt);
            }
        });
        this.pnlBut.add(this.butDelete);
        this.jLabel1.setMinimumSize(new Dimension(80, 23));
        this.pnlBut.add(this.jLabel1);
        this.butDelCache.setText("neu laden");
        this.butDelCache.setToolTipText("l\u00f6schen aller zwischengespeicherten Symbole");
        this.butDelCache.setMinimumSize(new Dimension(80, 23));
        this.butDelCache.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SymbolstoreListPanel.this.butDelCache_onActionPerformed(evt);
            }
        });
        this.pnlBut.add(this.butDelCache);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 9, 9);
        this.add((Component)this.pnlBut, gridBagConstraints);
    }

    private void butDelCache_onActionPerformed(ActionEvent evt) {
        Iterator<SymbolstoreMetadata> i = this.smdCol.iterator();
        while (i.hasNext()) {
            try {
                i.next().getSymbolStore().clearCache();
            }
            catch (Exception e) {
                LOG.error("Error deleting Cache", (Throwable)e);
            }
        }
    }

    private void lstSymbolstores_onMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.butEdit_onActionPerformed(null);
        }
    }

    private void butEdit_onActionPerformed(ActionEvent evt) {
        if (this.lstSymbolstores.getSelectedValues().length != 1) {
            return;
        }
        SymbolstoreMetadata oldMData = (SymbolstoreMetadata)this.lstSymbolstores.getSelectedValue();
        SymbolstoreMetadata newMData = oldMData.clone();
        this.editName = oldMData.getName();
        this.dlg = this.getDialog(1, newMData);
        this.dlg.setVisible(true);
        if (this.dlg.wasOKPressed()) {
            this.listModel.replaceSymbolstore(oldMData, newMData);
            this.lstSymbolstores.setSelectedValue(newMData, true);
        }
    }

    private void butAdd_onActionPerformed(ActionEvent evt) {
        SymbolstoreMetadata mData = new SymbolstoreMetadata();
        mData.setName("new");
        this.dlg = this.getDialog(0, mData);
        this.dlg.setVisible(true);
        if (this.dlg.wasOKPressed()) {
            this.listModel.addSymbolstore(mData);
            this.lstSymbolstores.setSelectedValue(mData, true);
        }
    }

    private void butDelete_onActionPerformed(ActionEvent evt) {
        JOptionPane optYesNo = new JOptionPane();
        Object[] arrDS = this.lstSymbolstores.getSelectedValues();
        if (arrDS.length == 0) {
            return;
        }
        int option = JOptionPane.showConfirmDialog(this, I18N.get("de.riwagis.riwajump.SymbolstoreListPanel.delete-question"), I18N.get("common.message"), 0);
        if (option == 0) {
            for (Object arrDS1 : arrDS) {
                this.listModel.removeSymbolstore((SymbolstoreMetadata)arrDS1);
            }
        }
    }
}

