/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.symbol.gui;

import de.riwagis.riwajump.symbol.model.SMDCollection;
import de.riwagis.riwajump.symbol.model.SymbolstoreMetadata;
import javax.swing.AbstractListModel;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SymbolstoreListModel
extends AbstractListModel {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SymbolstoreListModel.class);
    SMDCollection smdCol = null;

    public SymbolstoreListModel(SMDCollection _smdCol) {
        this.smdCol = _smdCol;
    }

    @Override
    public Object getElementAt(int index) {
        return this.smdCol.getInternalList().get(index);
    }

    @Override
    public int getSize() {
        return this.smdCol.getInternalList().size();
    }

    public void setSMDCollection(SMDCollection smdCol) {
        this.smdCol = smdCol;
        this.smdCol.getInternalList().forEach(smd -> {
            try {
                smd.getSymbolStore();
            }
            catch (Exception ex) {
                log.error("Could not open Symbol Store", (Throwable)ex);
            }
        });
        this.fireContentsChanged(this, 0, this.getSize());
    }

    public void addSymbolstore(SymbolstoreMetadata dataMeta) {
        int index = this.smdCol.addSymbolstore(dataMeta);
        this.fireIntervalAdded(this, index, index);
    }

    public void replaceSymbolstore(SymbolstoreMetadata oldMeta, SymbolstoreMetadata newMeta) {
        this.smdCol.replaceSymbolstore(oldMeta, newMeta);
        this.fireContentsChanged(this, 0, this.getSize());
    }

    public void removeSymbolstore(SymbolstoreMetadata dataMeta) {
        int index = this.smdCol.removeSymbolstore(dataMeta);
        if (index != -1) {
            this.fireIntervalRemoved(this, index, index);
        }
    }

    private void sortSymbolstoreList() {
        this.smdCol.sortList();
        this.fireContentsChanged(this, 0, this.getSize());
    }
}

