/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.symbol.gui;

import com.vividsolutions.jump.I18N;
import de.riwagis.guitools.Validator;
import de.riwagis.riwajump.symbol.gui.SymbolstoreListPanel;
import de.riwagis.riwajump.symbol.model.SMDCollection;
import de.riwagis.riwajump.symbol.model.SymbolstoreMetadata;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class SymbolstoreListDialog
extends JDialog {
    private SMDCollection smdOri = new SMDCollection();
    private SMDCollection smdClone = new SMDCollection();
    private final Collection<Validator> lstValidator = new LinkedHashSet<Validator>();
    private boolean bolOKPressed = false;
    private JButton butCancel;
    private JButton butOK;
    private JPanel pnlOKCancel;
    private SymbolstoreListPanel pnlSymbolstoreList;

    public SymbolstoreListDialog(Dialog owner, boolean modal) {
        super(owner, modal);
        this.initComponents();
        this.i18n();
    }

    public SymbolstoreListDialog(Frame owner, boolean modal) {
        super(owner, modal);
        this.initComponents();
        this.i18n();
    }

    private void i18n() {
        this.butCancel.setText(I18N.get("common.cancel"));
        this.butOK.setText(I18N.get("common.ok"));
        this.setTitle(I18N.get("de.riwagis.riwajump.SymbolstoreListDialog.title"));
    }

    public void setSMDCollection(SMDCollection _smdCol) {
        this.smdOri = _smdCol;
        this.smdClone = new SMDCollection(this.smdOri.getCloneList());
        this.pnlSymbolstoreList.setSMDCollection(this.smdClone);
    }

    public SymbolstoreListPanel getPanel() {
        return this.pnlSymbolstoreList;
    }

    public void addValidator(Validator val) {
        if (!this.lstValidator.contains(val)) {
            this.lstValidator.add(val);
        }
    }

    public void removeValidator(Validator val) {
        if (this.lstValidator.contains(val)) {
            this.lstValidator.remove(val);
        }
    }

    public void clearValidators() {
        this.lstValidator.clear();
    }

    public boolean wasOKPressed() {
        return this.bolOKPressed;
    }

    private void initComponents() {
        this.pnlOKCancel = new JPanel();
        this.butOK = new JButton();
        this.butCancel = new JButton();
        this.pnlSymbolstoreList = new SymbolstoreListPanel();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(0);
        this.butOK.setText("OK");
        this.butOK.setMinimumSize(new Dimension(110, 23));
        this.butOK.setPreferredSize(new Dimension(110, 23));
        this.butOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SymbolstoreListDialog.this.butOK_onActionPerformed(evt);
            }
        });
        this.pnlOKCancel.add(this.butOK);
        this.butCancel.setText("abbrechen");
        this.butCancel.setMinimumSize(new Dimension(110, 23));
        this.butCancel.setPreferredSize(new Dimension(110, 23));
        this.butCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SymbolstoreListDialog.this.butCancel_onActionPerformed(evt);
            }
        });
        this.pnlOKCancel.add(this.butCancel);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.getContentPane().add((Component)this.pnlOKCancel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.getContentPane().add((Component)this.pnlSymbolstoreList, gridBagConstraints);
        this.pack();
    }

    private void butCancel_onActionPerformed(ActionEvent evt) {
        this.bolOKPressed = false;
        this.setVisible(false);
    }

    private void butOK_onActionPerformed(ActionEvent evt) {
        for (Validator val : this.lstValidator) {
            String strError = val.check(this.smdClone);
            if (strError == null) continue;
            JOptionPane.showMessageDialog(this, I18N.get("common.error") + ": " + strError);
            return;
        }
        this.smdOri.getInternalList().clear();
        Iterator<Object> i = this.smdClone.iterator();
        while (i.hasNext()) {
            this.smdOri.getInternalList().add((SymbolstoreMetadata)i.next());
        }
        this.bolOKPressed = true;
        this.setVisible(false);
    }
}

