/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.symbol.gui;

import com.vividsolutions.jump.I18N;
import de.riwagis.guitools.Validator;
import de.riwagis.riwajump.symbol.gui.SymbolstorePanel;
import de.riwagis.riwajump.symbol.model.SymbolstoreMetadata;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class SymbolstoreDialog
extends JDialog {
    public static final int MODE_ADD = 0;
    public static final int MODE_EDIT = 1;
    private int intMode = 0;
    private SymbolstoreMetadata smdori = new SymbolstoreMetadata();
    private SymbolstoreMetadata smdclone = new SymbolstoreMetadata();
    private List<Validator> lstValidator = new ArrayList<Validator>();
    private boolean bolOKPressed = false;
    private JButton butCancel;
    private JButton butOK;
    private JPanel jPanel1;
    private SymbolstorePanel pnlSMD;

    public SymbolstoreDialog(Dialog owner, boolean modal, int _intMode, SymbolstoreMetadata _mData) {
        super(owner, modal);
        this.init(_intMode, _mData);
    }

    public SymbolstoreDialog(Frame owner, boolean modal, int _intMode, SymbolstoreMetadata _mData) {
        super(owner, modal);
        this.init(_intMode, _mData);
    }

    private void init(int _intMode, SymbolstoreMetadata _mData) {
        this.initComponents();
        this.setSMD(_mData);
        this.setMode(_intMode);
        this.i18n();
        this.setSize(350, 210);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                SymbolstoreDialog.this.handleCancelAction();
            }
        });
    }

    public void setMode(int _intMode) {
        this.intMode = _intMode;
        if (this.intMode != 0 && this.intMode != 1) {
            this.intMode = 0;
        }
        if (this.intMode == 1) {
            this.setTitle(I18N.get("de.riwagis.riwajump.SymbolstoreDialog.edit-title"));
        } else {
            this.setTitle(I18N.get("de.riwagis.riwajump.SymbolstoreDialog.add-title"));
        }
    }

    public int getMode() {
        return this.intMode;
    }

    private void i18n() {
        this.butCancel.setText(I18N.get("common.cancel"));
        this.butOK.setText(I18N.get("common.ok"));
    }

    public void setSMD(SymbolstoreMetadata _smd) {
        this.smdori = _smd;
        this.smdclone = this.smdori.clone();
        this.pnlSMD.setSMD(this.smdclone);
    }

    public void addValidator(Validator val) {
        if (!this.lstValidator.contains(val)) {
            this.lstValidator.add(val);
        }
    }

    public void removeValidator(Validator val) {
        if (this.lstValidator.contains(val)) {
            this.lstValidator.remove(val);
        }
    }

    public void clearValidators() {
        this.lstValidator.clear();
    }

    public boolean wasOKPressed() {
        return this.bolOKPressed;
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.butOK = new JButton();
        this.butCancel = new JButton();
        this.pnlSMD = new SymbolstorePanel();
        this.setDefaultCloseOperation(2);
        this.getContentPane().setLayout(new GridBagLayout());
        this.butOK.setText("OK");
        this.butOK.setMaximumSize(new Dimension(130, 23));
        this.butOK.setPreferredSize(new Dimension(100, 23));
        this.butOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SymbolstoreDialog.this.butOK_onActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.butOK);
        this.butCancel.setText("Abbrechen");
        this.butCancel.setMaximumSize(new Dimension(130, 23));
        this.butCancel.setPreferredSize(new Dimension(100, 23));
        this.butCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SymbolstoreDialog.this.butCancel_onActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.butCancel);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.pnlSMD, gridBagConstraints);
        this.pack();
    }

    private void butOK_onActionPerformed(ActionEvent evt) {
        for (Validator val : this.lstValidator) {
            String strError = val.check(this.smdclone);
            if (strError == null) continue;
            JOptionPane.showMessageDialog(this, I18N.get("common.error") + ": " + strError);
            return;
        }
        this.smdori.takeProperties(this.smdclone);
        this.bolOKPressed = true;
        this.setVisible(false);
    }

    private void butCancel_onActionPerformed(ActionEvent evt) {
        this.handleCancelAction();
    }

    private void handleCancelAction() {
        this.bolOKPressed = false;
        this.setVisible(false);
    }
}

