/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.symbol.gui;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.model.AbstractCadLayer;
import com.vividsolutions.jump.workbench.model.CadLayerSymbolDefinition;
import com.vividsolutions.jump.workbench.model.RedlineLayer;
import de.riwagis.riwajump.symbol.SymbolStore;
import de.riwagis.riwajump.symbol.gui.RedlineLayerSymbolListCellRenderer;
import de.riwagis.riwajump.symbol.gui.RedlineUserSymbolPanel;
import de.riwagis.riwajump.symbol.resources.RedlineLayerSymbolStore;
import de.riwagis.util.gui.models.ListListModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SymbolListDialog
extends JDialog {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SymbolListDialog.class);
    private boolean bolOKPressed = false;
    private SymbolStore store = null;
    private boolean displaySymbols;
    private JButton butCancel;
    private JButton butOK;
    private JScrollPane jScrollPane1;
    private JLabel lblPrev;
    private JLabel lblPreview;
    private JLabel lblSymbol;
    private JList lstSymbol;
    private JPanel pnlOKCancel;
    private JPanel pnlPreview;
    private RedlineUserSymbolPanel redlineUserSymbolPanel;

    public SymbolListDialog(Dialog owner, boolean modal) {
        super(owner, modal);
        this.init();
    }

    public SymbolListDialog(Frame owner, boolean modal) {
        super(owner, modal);
        this.init();
    }

    private void init() {
        this.initComponents();
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                int code = e.getKeyCode();
                if (code == 27) {
                    SymbolListDialog.this.butCancel_onActionPerformed(null);
                } else if (code == 10) {
                    SymbolListDialog.this.butOK_onActionPerformed(null);
                }
            }
        });
        this.i18n();
        this.setSize(300, 300);
    }

    private void i18n() {
        this.setTitle(I18N.get("de.riwagis.riwajump.SymbolListDialog.title"));
        this.lblSymbol.setText(I18N.get("de.riwagis.riwajump.SymbolListDialog.title") + ":");
        this.butCancel.setText(I18N.get("common.cancel"));
        this.butOK.setText(I18N.get("common.ok"));
    }

    public void setSymbolStore(SymbolStore store) {
        this.store = store;
        this.updateModel(Arrays.stream(this.store.getSymbolNames()).sorted(String.CASE_INSENSITIVE_ORDER).map(CadLayerSymbolDefinition::new).collect(Collectors.toList()));
        this.setupUserDefinedOperations(null);
    }

    public void setup(SymbolStore store, boolean displaySymbols, AbstractCadLayer layer) {
        this.store = store;
        this.displaySymbols = displaySymbols;
        this.updateModel();
        this.setupUserDefinedOperations(layer);
    }

    private void setupUserDefinedOperations(AbstractCadLayer layer) {
        if (layer instanceof RedlineLayer) {
            this.lstSymbol.setCellRenderer(new RedlineLayerSymbolListCellRenderer((RedlineLayerSymbolStore)this.store));
            this.lstSymbol.addListSelectionListener(e -> this.redlineUserSymbolPanel.setEnableStates(this.getSymbolName()));
            this.redlineUserSymbolPanel.setup((RedlineLayerSymbolStore)this.store, (RedlineLayer)layer, this.lstSymbol, symbol -> {
                this.updateModel();
                this.selectSymbol((CadLayerSymbolDefinition)symbol);
            });
            this.redlineUserSymbolPanel.setVisible(true);
        } else {
            this.lstSymbol.setCellRenderer(new DefaultListCellRenderer());
            this.redlineUserSymbolPanel.setVisible(false);
        }
    }

    private List<CadLayerSymbolDefinition> retrieveSymbolList() {
        return this.displaySymbols ? this.store.getSymbolDefinitions() : this.store.getFillDefinitions();
    }

    private void updateModel(List<CadLayerSymbolDefinition> symbolDefs) {
        this.lstSymbol.setModel(new ListListModel(symbolDefs));
    }

    private void updateModel() {
        this.updateModel(this.retrieveSymbolList());
    }

    public String getSymbolName() {
        CadLayerSymbolDefinition obj = (CadLayerSymbolDefinition)this.lstSymbol.getSelectedValue();
        if (obj == null) {
            return "";
        }
        return obj.getSymbolName();
    }

    public void selectSymbol(CadLayerSymbolDefinition symbol) {
        Objects.requireNonNull(symbol);
        this.lstSymbol.setSelectedValue(symbol, true);
    }

    public void selectSymbol(String symName) {
        if ((symName = ObjectUtils.toString((Object)symName)).startsWith("\"")) {
            symName = symName.substring(1);
        }
        if (symName.endsWith("\"")) {
            symName = symName.substring(0, symName.length() - 1);
        }
        String trimmedName = symName;
        Optional<Object> findFirst = ((ListListModel)this.lstSymbol.getModel()).getList().stream().filter(symbol -> Objects.equals(((CadLayerSymbolDefinition)symbol).getSymbolName(), trimmedName)).findFirst();
        findFirst.ifPresent(name -> this.lstSymbol.setSelectedValue(name, true));
    }

    public boolean wasOKPressed() {
        return this.bolOKPressed;
    }

    public boolean isUserSymbolsChanged() {
        return this.redlineUserSymbolPanel.isUserSymbolsChanged();
    }

    private void initComponents() {
        this.lblSymbol = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.lstSymbol = new JList();
        this.pnlOKCancel = new JPanel();
        this.butOK = new JButton();
        this.butCancel = new JButton();
        this.pnlPreview = new JPanel();
        this.lblPrev = new JLabel();
        this.lblPreview = new JLabel();
        this.redlineUserSymbolPanel = new RedlineUserSymbolPanel();
        this.getContentPane().setLayout(new GridBagLayout());
        this.lblSymbol.setText("Attribute:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(9, 9, 3, 9);
        this.getContentPane().add((Component)this.lblSymbol, gridBagConstraints);
        this.lstSymbol.setSelectionMode(0);
        this.lstSymbol.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SymbolListDialog.this.lstSymbol_onMouseClicked(evt);
            }
        });
        this.lstSymbol.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                SymbolListDialog.this.lstSymbol_onValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.lstSymbol);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 9, 3, 9);
        this.getContentPane().add((Component)this.jScrollPane1, gridBagConstraints);
        this.butOK.setText("OK");
        this.butOK.setMinimumSize(new Dimension(110, 23));
        this.butOK.setPreferredSize(new Dimension(110, 23));
        this.butOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SymbolListDialog.this.butOK_onActionPerformed(evt);
            }
        });
        this.pnlOKCancel.add(this.butOK);
        this.butCancel.setText("abbrechen");
        this.butCancel.setMinimumSize(new Dimension(110, 23));
        this.butCancel.setPreferredSize(new Dimension(110, 23));
        this.butCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SymbolListDialog.this.butCancel_onActionPerformed(evt);
            }
        });
        this.pnlOKCancel.add(this.butCancel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.getContentPane().add((Component)this.pnlOKCancel, gridBagConstraints);
        this.pnlPreview.setBackground(new Color(255, 255, 255));
        this.pnlPreview.setBorder(BorderFactory.createEtchedBorder());
        this.pnlPreview.setMinimumSize(new Dimension(60, 60));
        this.pnlPreview.setPreferredSize(new Dimension(60, 60));
        this.pnlPreview.setLayout(new BorderLayout());
        this.lblPrev.setHorizontalAlignment(0);
        this.pnlPreview.add((Component)this.lblPrev, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(3, 3, 3, 9);
        this.getContentPane().add((Component)this.pnlPreview, gridBagConstraints);
        this.lblPreview.setText("Vorschau:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(9, 3, 3, 9);
        this.getContentPane().add((Component)this.lblPreview, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(3, 0, 3, 9);
        this.getContentPane().add((Component)this.redlineUserSymbolPanel, gridBagConstraints);
        this.pack();
    }

    private void lstSymbol_onMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.bolOKPressed = true;
            this.setVisible(false);
        }
    }

    private void butCancel_onActionPerformed(ActionEvent evt) {
        this.bolOKPressed = false;
        this.setVisible(false);
    }

    private void butOK_onActionPerformed(ActionEvent evt) {
        this.bolOKPressed = true;
        this.setVisible(false);
    }

    private void lstSymbol_onValueChanged(ListSelectionEvent evt) {
        String strSym = this.getSymbolName();
        try {
            int width = (int)((double)this.pnlPreview.getWidth() * 0.7);
            BufferedImage img = this.store.getSymbol(strSym, width, null, null, false);
            if (img.getHeight() > this.pnlPreview.getHeight()) {
                width = (int)((double)width * ((double)this.pnlPreview.getHeight() / (double)img.getHeight()));
                img = this.store.getSymbol(strSym, width, null, null, false);
            }
            this.lblPrev.setIcon(new ImageIcon(img));
        }
        catch (Exception e) {
            this.lblPrev.setIcon(null);
        }
    }
}

