/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.symbol.gui;

import com.google.common.hash.Hashing;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.workbench.model.CadLayerSymbolDefinition;
import com.vividsolutions.jump.workbench.model.RedlineLayer;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.layer.cad.CadFeatureAtts;
import de.riwagis.geotools.feature.util.FeatureUtil;
import de.riwagis.riwajump.symbol.resources.RedlineLayerSymbolStore;
import de.riwagis.util.gui.GUISupport;
import de.riwagis.util.gui.dialogs.ExpandableDialog;
import de.riwagis.util.gui.models.ListListModel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import lombok.Generated;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.geotools.feature.FeatureIterator;
import org.locationtech.jts.geom.Envelope;
import org.opengis.feature.simple.SimpleFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedlineUserSymbolPanel
extends JPanel {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RedlineUserSymbolPanel.class);
    private static final FileFilter IMAGE_FILE_FILTER = GUISupport.createFileFilter((String)"Scalable Vector Graphics", (String[])new String[]{"svg"});
    private static final String SYMBOL_FILE_PATH = RedlineUserSymbolPanel.class.getName() + "_LAST_USED_FILE";
    private final JFileChooser fileChooser = GUISupport.createJFileChooser((boolean)true);
    private final Blackboard blackBoard = PersistentBlackboardPlugIn.get();
    private boolean userSymbolsChanged = false;
    private Consumer<CadLayerSymbolDefinition> resetModelAndSelectConsumer;
    private JList list;
    private RedlineLayerSymbolStore store;
    private RedlineLayer layer;
    private JButton btnAdd;
    private JButton btnDelete;
    private JButton btnRename;

    public RedlineUserSymbolPanel() {
        this.initComponents();
        this.fileChooser.setFileFilter(IMAGE_FILE_FILTER);
        this.fileChooser.setMultiSelectionEnabled(true);
        this.fileChooser.removeChoosableFileFilter(this.fileChooser.getAcceptAllFileFilter());
    }

    public void setup(RedlineLayerSymbolStore store, RedlineLayer layer, JList list, Consumer<CadLayerSymbolDefinition> resetModelAndSelectConsumer) {
        this.store = store;
        this.layer = layer;
        this.list = list;
        this.resetModelAndSelectConsumer = resetModelAndSelectConsumer;
    }

    public boolean isUserSymbolsChanged() {
        return this.userSymbolsChanged;
    }

    private boolean isSymbolUsed(String name) throws Exception {
        FeatureIterator<SimpleFeature> features = this.layer.getFeatureIterator((Envelope)null);
        while (features.hasNext()) {
            SimpleFeature feature = (SimpleFeature)features.next();
            Object symbolName = FeatureUtil.getAttribute((SimpleFeature)feature, (String)CadFeatureAtts.SYMBOL.getName());
            Object fillName = FeatureUtil.getAttribute((SimpleFeature)feature, (String)CadFeatureAtts.FILL.getName());
            if (!Objects.equals(name, symbolName) && !Objects.equals(name, fillName)) continue;
            return true;
        }
        return false;
    }

    private String buildUniqueName(String name, Function<String, Boolean> checker) {
        String newName;
        if (!checker.apply(name).booleanValue()) {
            return name;
        }
        int i = 0;
        while (checker.apply(newName = name + " (" + ++i + ")").booleanValue()) {
        }
        return newName;
    }

    public void setEnableStates(String symbolName) {
        boolean isUserDefinedIcon = this.store.isUserDefinedSymbol(symbolName);
        this.btnDelete.setEnabled(isUserDefinedIcon);
        this.btnRename.setEnabled(isUserDefinedIcon);
    }

    private void setLastUsedLocationFromChooser(JFileChooser chooser) {
        this.blackBoard.put(SYMBOL_FILE_PATH, chooser.getSelectedFile().getAbsolutePath());
    }

    private void setCurrentChooserLocation(JFileChooser chooser) {
        String lastUsedFile = this.blackBoard.getString(SYMBOL_FILE_PATH);
        if (StringUtils.isNotBlank((String)lastUsedFile)) {
            chooser.setSelectedFile(new File(lastUsedFile));
        }
    }

    private void initComponents() {
        this.btnAdd = new JButton();
        this.btnDelete = new JButton();
        this.btnRename = new JButton();
        this.setLayout(new GridBagLayout());
        this.btnAdd.setText("Hinzuf\u00fcgen...");
        this.btnAdd.setToolTipText("");
        this.btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RedlineUserSymbolPanel.this.btnAddActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.add((Component)this.btnAdd, gridBagConstraints);
        this.btnDelete.setText("L\u00f6schen");
        this.btnDelete.setAutoscrolls(true);
        this.btnDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RedlineUserSymbolPanel.this.btnDeleteActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.add((Component)this.btnDelete, gridBagConstraints);
        this.btnRename.setText("Umbenennen...");
        this.btnRename.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RedlineUserSymbolPanel.this.btnRenameActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.add((Component)this.btnRename, gridBagConstraints);
    }

    private void btnAddActionPerformed(ActionEvent evt) {
        Objects.requireNonNull(this.store);
        this.setCurrentChooserLocation(this.fileChooser);
        int chooseResult = this.fileChooser.showOpenDialog(this);
        if (chooseResult != 1) {
            this.setLastUsedLocationFromChooser(this.fileChooser);
            File[] imageFiles = this.fileChooser.getSelectedFiles();
            AtomicReference selectedSymbol = new AtomicReference();
            List duplicates = Arrays.stream(imageFiles).filter(file -> {
                try {
                    byte[] bytes = Files.readAllBytes(file.toPath());
                    String absolutePath = file.getAbsolutePath();
                    String displayName = FilenameUtils.getBaseName((String)absolutePath);
                    String symbolName = Hashing.sha512().hashBytes(bytes).toString() + "." + FilenameUtils.getExtension((String)absolutePath);
                    CadLayerSymbolDefinition definition = new CadLayerSymbolDefinition(this.buildUniqueName(displayName, this.store::containsDisplayName), symbolName);
                    if (this.store.containsSymbol(definition.getSymbolName())) {
                        return true;
                    }
                    this.store.addSymbol(definition, ByteBuffer.wrap(bytes));
                    selectedSymbol.compareAndExchange(null, definition);
                }
                catch (IOException ex) {
                    log.error("Could not add symbol to redline layer.", (Throwable)ex);
                }
                return false;
            }).collect(Collectors.toList());
            if (selectedSymbol.get() != null) {
                this.resetModelAndSelectConsumer.accept((CadLayerSymbolDefinition)selectedSymbol.get());
            }
            if (!duplicates.isEmpty()) {
                ExpandableDialog.showInfo((Component)this.getRootPane(), (String)I18N.get("de.riwagis.riwajump.SymbolListDialog.info-ignored-duplicates"), (String)org.apache.commons.lang3.StringUtils.join(duplicates, (String)"\n"));
            }
            this.userSymbolsChanged = true;
        }
    }

    private void btnDeleteActionPerformed(ActionEvent evt) {
        try {
            CadLayerSymbolDefinition symbolDef = (CadLayerSymbolDefinition)this.list.getSelectedValue();
            if (this.layer.isSymbolRequiredByStyle(symbolDef.getSymbolName()) || this.isSymbolUsed(symbolDef.getSymbolName())) {
                JOptionPane.showMessageDialog(this, I18N.get("de.riwagis.riwajump.SymbolListDialog.error-symbol-in-use"), I18N.get("common.error"), 0);
                return;
            }
            if (this.store.removeSymbol(symbolDef.getSymbolName())) {
                int lastIndex = this.list.getSelectedIndex();
                ListListModel listModel = (ListListModel)this.list.getModel();
                listModel.removeListObject((Object)symbolDef);
                this.resetModelAndSelectConsumer.accept(symbolDef);
                if (this.list.getModel().getSize() > 0) {
                    this.list.setSelectedIndex(Math.max(0, lastIndex - 1));
                } else {
                    this.list.setSelectedIndex(Math.max(-1, lastIndex - 1));
                }
            }
            this.userSymbolsChanged = true;
        }
        catch (Exception ex) {
            log.error("Could not delete symbol.", (Throwable)ex);
        }
    }

    private void btnRenameActionPerformed(ActionEvent evt) {
        CadLayerSymbolDefinition symbolDef = (CadLayerSymbolDefinition)this.list.getSelectedValue();
        String newName = JOptionPane.showInputDialog(this, I18N.get("de.riwagis.riwajump.SymbolListDialog.new-symbol-name"), symbolDef.getName());
        if (newName == null) {
            return;
        }
        String trimmedName = newName.trim();
        if (!Objects.equals(trimmedName, symbolDef.getName())) {
            if (trimmedName.isEmpty()) {
                JOptionPane.showMessageDialog(this, I18N.get("de.riwagis.riwajump.SymbolListDialog.error-symbol-name-empty"), I18N.get("common.error"), 0);
            } else if (!this.store.containsDisplayName(trimmedName)) {
                CadLayerSymbolDefinition newDef = this.store.renameSymbol(symbolDef.getSymbolName(), trimmedName);
                this.resetModelAndSelectConsumer.accept(newDef);
                this.userSymbolsChanged = true;
            } else {
                JOptionPane.showMessageDialog(this, I18N.get("de.riwagis.riwajump.SymbolListDialog.error-symbol-name-exists"), I18N.get("common.error"), 0);
            }
        }
    }
}

