/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.symbol.gui;

import com.vividsolutions.jump.workbench.model.CadLayerSymbolDefinition;
import com.vividsolutions.jump.workbench.model.redline.RedlineGlobalStyles;
import de.riwagis.riwajump.symbol.resources.RedlineLayerSymbolStore;
import java.awt.Color;
import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class RedlineLayerSymbolListCellRenderer
implements ListCellRenderer<CadLayerSymbolDefinition> {
    private static final Color UNSELECTED_EDITABLE_SYMBOL_COLOR = Color.GREEN.darker();
    private static final Color SELECTED_EDITABLE_SYMBOL_COLOR = Color.GREEN;
    private final DefaultListCellRenderer renderer = new DefaultListCellRenderer();
    private final RedlineGlobalStyles globalStyles = RedlineGlobalStyles.getInstance();
    private RedlineLayerSymbolStore store;

    public RedlineLayerSymbolListCellRenderer() {
    }

    public RedlineLayerSymbolListCellRenderer(RedlineLayerSymbolStore store) {
        this.store = store;
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends CadLayerSymbolDefinition> list, CadLayerSymbolDefinition value, int index, boolean isSelected, boolean cellHasFocus) {
        Component label = this.renderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        if (value != null) {
            String name = value.getSymbolName();
            if (this.store != null && this.store.isUserDefinedSymbol(name)) {
                label.setForeground(isSelected ? SELECTED_EDITABLE_SYMBOL_COLOR : UNSELECTED_EDITABLE_SYMBOL_COLOR);
            }
            if (!isSelected && this.globalStyles.getGlobalStore().containsSymbol(value.getSymbolName())) {
                label.setBackground(Color.YELLOW);
            }
        }
        return label;
    }

    public RedlineLayerSymbolStore getStore() {
        return this.store;
    }

    public void setStore(RedlineLayerSymbolStore store) {
        this.store = store;
    }
}

