/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.symbol;

import de.riwagis.gis.context.AppStartup;
import de.riwagis.riwajump.symbol.RiwaSrvSymbolStore;
import de.riwagis.riwajump.symbol.SymbolStore;
import de.riwagis.riwajump.symbol.SymbolStoreFactorySpi;
import de.riwagis.service.ServiceProvider;
import de.riwagis.util.StringSupport;
import de.riwagis.util.exception.SystemException;
import java.util.Map;

public class RiwaSrvSymbolStoreFactory
implements SymbolStoreFactorySpi {
    public static final String PREFIX = "svg/png-riwasym";

    @Override
    public boolean canHandle(Map<String, Object> parameters) {
        String strURL = SymbolStore.getURL(parameters);
        if (!AppStartup.isModuleUp()) {
            return false;
        }
        if (!strURL.toLowerCase().startsWith("svg/png-riwasym:")) {
            return false;
        }
        String[] arrTest = strURL.split("\\:");
        return arrTest.length == 2 && StringSupport.isNumeric((String)arrTest[1]);
    }

    @Override
    public String getPrefix() {
        return PREFIX;
    }

    @Override
    public SymbolStore create(Map<String, Object> parameters) throws SystemException {
        ServiceProvider srvProv = null;
        if (!AppStartup.isModuleUp()) {
            throw new SystemException(RiwaSrvSymbolStore.class, "GisContext is not initialized.");
        }
        try {
            srvProv = AppStartup.gisContext.getModuleApp().getServiceProvider();
            if (srvProv == null) {
                throw new Exception("No service provider found in module application.");
            }
        }
        catch (Exception e) {
            throw new SystemException(RiwaSrvSymbolStore.class, (Throwable)e);
        }
        int intModuleKey = -1;
        try {
            intModuleKey = Integer.parseInt(SymbolStore.getURL(parameters).split("\\:")[1]);
        }
        catch (NumberFormatException e) {
            throw new SystemException(RiwaSrvSymbolStore.class, "Error parsing URL");
        }
        return new RiwaSrvSymbolStore(srvProv, intModuleKey);
    }
}

