/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.symbol;

import de.riwagis.riwajump.symbol.AbstractSymbolStore;
import de.riwagis.service.MethodMData;
import de.riwagis.service.ParameterMData;
import de.riwagis.service.ServiceException;
import de.riwagis.service.ServiceMData;
import de.riwagis.service.ServiceProvider;
import de.riwagis.service.ServiceRequest;
import de.riwagis.service.StreamProcessor;
import de.riwagis.service.stream.ByteArrayStreamProcessor;
import de.riwagis.util.exception.SystemException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RiwaSrvSymbolStore
extends AbstractSymbolStore {
    private static final int MAX_SYMBOLS_FOR_CACHING = 200;
    private static final Logger LOG = LoggerFactory.getLogger(RiwaSrvSymbolStore.class);
    private static final ByteArrayStreamProcessor BSP = new ByteArrayStreamProcessor();
    private static final ParameterMData pModKey = new ParameterMData("module_key", Integer.class);
    private static final ParameterMData pSymName = new ParameterMData("sym_name", String.class);
    private static final MethodMData methTestConnection = new MethodMData("test_connection", new ParameterMData[]{pModKey}, MethodMData.MethodHTTPType.HTTP_POST_REQUEST, MethodMData.MethodResponseType.RETURN_OBJECT);
    private static final MethodMData methGetSymbolNames = new MethodMData("get_symbol_names", new ParameterMData[]{pModKey}, MethodMData.MethodHTTPType.HTTP_POST_REQUEST, MethodMData.MethodResponseType.RETURN_OBJECT);
    private static final MethodMData methGetAllSymbols = new MethodMData("get_all_symbols", new ParameterMData[]{pModKey}, MethodMData.MethodHTTPType.HTTP_POST_REQUEST, MethodMData.MethodResponseType.RETURN_STREAM);
    private static final MethodMData methGetSymbol = new MethodMData("get_symbol", new ParameterMData[]{pModKey, pSymName}, MethodMData.MethodHTTPType.HTTP_POST_REQUEST, MethodMData.MethodResponseType.RETURN_STREAM);
    private static final ServiceMData symbolService = new ServiceMData("symbol", 0, new MethodMData[]{methTestConnection, methGetSymbolNames, methGetSymbol, methGetAllSymbols});
    private final ServiceProvider svProv;
    private final int intModule;
    private transient Set<String> setSymNames = null;
    private transient Boolean bolCacheSymbols = null;
    private transient Map<String, byte[]> mapCacheAllSyms = null;

    RiwaSrvSymbolStore(ServiceProvider _svProv, int _intModule) {
        this.svProv = _svProv;
        this.intModule = _intModule;
    }

    @Override
    public String getName() {
        return "Riwa Symbols";
    }

    @Override
    public String getDescription() {
        return "SVG/PNG files provided by a web service.";
    }

    @Override
    public synchronized String[] getSymbolNames() {
        try {
            if (this.setSymNames == null) {
                LOG.debug("Retrieving Symbolnames...");
                HashMap<String, Integer> params = new HashMap<String, Integer>();
                params.put("module_key", this.intModule);
                ServiceRequest req = symbolService.createRequest("get_symbol_names", params);
                String[] arrSymNames = (String[])this.svProv.execRequest(req).getResult();
                this.setSymNames = new HashSet<String>();
                Collections.addAll(this.setSymNames, arrSymNames);
                LOG.debug("Symbolnames retrieved");
            }
            return this.setSymNames.toArray(new String[this.setSymNames.size()]);
        }
        catch (Exception e) {
            LOG.error("Error retrieving symbolnames in RiwaSrvDataStore.", (Throwable)e);
            return new String[]{"error"};
        }
    }

    @Override
    public synchronized InputStream getStreamByName(String strName) throws IOException {
        block12: {
            if (strName.startsWith("/") || strName.startsWith("\\")) {
                strName = strName.substring(1);
            }
            if (!this.containsSymbol(strName)) {
                throw new IOException(String.format("Symbol not found: %s.", strName));
            }
            if (this.mapCacheAllSyms != null && this.mapCacheAllSyms.containsKey(strName)) {
                byte[] arrSymData = this.mapCacheAllSyms.get(strName);
                return new ByteArrayInputStream(arrSymData);
            }
            if (this.bolCacheSymbols == null) {
                this.bolCacheSymbols = this.getSymbolNames().length <= 200;
            }
            try {
                byte[] arrSymData;
                if (!this.bolCacheSymbols.booleanValue()) break block12;
                if (this.mapCacheAllSyms == null) {
                    try {
                        HashMap<String, Integer> params = new HashMap<String, Integer>();
                        params.put("module_key", this.intModule);
                        ServiceRequest req = symbolService.createRequest("get_all_symbols", params);
                        req.setStreamProcessor((StreamProcessor)new AllSymbolsProcessor());
                        this.mapCacheAllSyms = (Map)this.svProv.execRequest(req).getResult();
                    }
                    catch (Throwable t) {
                        this.bolCacheSymbols = false;
                        throw t;
                    }
                }
                if ((arrSymData = this.mapCacheAllSyms.get(strName)) == null) {
                    throw new SystemException(String.format("Symbol not found - should never reach here: %s.", strName));
                }
                return new ByteArrayInputStream(arrSymData);
            }
            catch (Throwable t) {
                LOG.error("Error retrieving Symbol from cache. Trying now on to retrieve symbols from server.", t);
            }
        }
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("module_key", this.intModule);
            params.put("sym_name", strName);
            ServiceRequest req = symbolService.createRequest("get_symbol", params);
            req.setStreamProcessor((StreamProcessor)BSP);
            byte[] arrSym = (byte[])this.svProv.execRequest(req).getResult();
            return new ByteArrayInputStream(arrSym);
        }
        catch (ServiceException sysex) {
            throw new IOException(String.format("error reading symbol '%s' from symbolservice at '%s': %s", strName, this.svProv, sysex.getMessage()), sysex);
        }
    }

    @Override
    public void clearCache() {
        super.clearCache();
        this.mapCacheAllSyms = null;
        this.bolCacheSymbols = null;
    }

    @Override
    public String testConnection() {
        try {
            HashMap<String, Integer> params = new HashMap<String, Integer>();
            params.put("module_key", this.intModule);
            ServiceRequest req = symbolService.createRequest("test_connection", params);
            String strError = (String)this.svProv.execRequest(req).getResult();
            if (strError.length() == 0) {
                return null;
            }
            return strError;
        }
        catch (Exception e) {
            return "error: " + e.getMessage();
        }
    }

    private static class AllSymbolsProcessor
    implements StreamProcessor<Map<String, byte[]>> {
        private final Map<String, byte[]> mapCacheInternal = new HashMap<String, byte[]>();

        private AllSymbolsProcessor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Map<String, byte[]> processStream(InputStream in) throws IOException {
            try {
                ZipEntry entry;
                ZipInputStream zis = new ZipInputStream(in);
                while ((entry = zis.getNextEntry()) != null) {
                    ByteArrayOutputStream bout = new ByteArrayOutputStream();
                    try {
                        IOUtils.copy((InputStream)zis, (OutputStream)bout);
                    }
                    finally {
                        IOUtils.closeQuietly((OutputStream)bout);
                    }
                    this.mapCacheInternal.put(entry.getName(), bout.toByteArray());
                }
                Map<String, byte[]> map = this.mapCacheInternal;
                return map;
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            finally {
                IOUtils.closeQuietly((InputStream)in);
            }
        }
    }
}

