/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.symbol;

import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Task;
import com.vividsolutions.jump.workbench.ui.plugin.io.project.RelativePaths;
import de.riwagis.riwajump.symbol.AbstractSymbolStore;
import de.riwagis.riwajump.symbol.SymbolStore;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DirectorySymbolStore
extends AbstractSymbolStore {
    private FilenameFilter symbolFilter;
    private final Map<String, Object> parameters;

    DirectorySymbolStore(Map<String, Object> parameters) {
        this.parameters = parameters;
        this.updateAbsolutePath();
    }

    @Override
    public String getName() {
        return "Directory Symbols";
    }

    @Override
    public String getDescription() {
        return "SVG files in a local directory.";
    }

    @Override
    public String[] getSymbolNames() {
        File file = this.getSymbolDirectory();
        if (!file.exists() || !file.isDirectory()) {
            return new String[0];
        }
        ArrayList<String> lstSymbols = new ArrayList<String>();
        this.addSymbols(file, file, lstSymbols);
        return lstSymbols.toArray(new String[lstSymbols.size()]);
    }

    private void addSymbols(File dir, File rootDir, List<String> lstSymbols) {
        File[] arrFile = dir.listFiles(this.getSymbolFilter());
        int rootlenth = rootDir.getAbsolutePath().length();
        for (File arrFile1 : arrFile) {
            if (arrFile1.isDirectory()) {
                this.addSymbols(arrFile1, rootDir, lstSymbols);
                continue;
            }
            lstSymbols.add(arrFile1.getAbsolutePath().substring(rootlenth + 1).replaceAll("\\\\", "/"));
        }
    }

    private FilenameFilter getSymbolFilter() {
        if (this.symbolFilter == null) {
            this.symbolFilter = (dir, strFileName) -> new File(dir, strFileName).isDirectory() || strFileName.toLowerCase().endsWith(".svg") || strFileName.toLowerCase().endsWith(".png");
        }
        return this.symbolFilter;
    }

    private File getSymbolDirectory() {
        return new File(this.getUrlWithoutScheme());
    }

    @Override
    public InputStream getStreamByName(String strName) throws IOException {
        File symFile = new File(this.getSymbolDirectory(), strName);
        if (symFile.exists()) {
            return new FileInputStream(symFile);
        }
        throw new FileNotFoundException(symFile.toString());
    }

    @Override
    public String testConnection() {
        try {
            File file = this.getSymbolDirectory();
            if (!file.exists()) {
                return "URL doesn't exist.";
            }
            if (!file.isDirectory()) {
                return "no directory";
            }
            return null;
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    private void updateAbsolutePath() {
        Task task = WorkbenchContext.getTask();
        RelativePaths.constructAbsolutePath(task, this.parameters, this.getUrlWithoutScheme()).ifPresent(obj -> SymbolStore.setURL(this.parameters, "svg/png-local:" + String.valueOf(obj)));
    }

    private String getUrlWithoutScheme() {
        return SymbolStore.removePrefix(SymbolStore.getURL(this.parameters));
    }
}

