/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.symbol;

import com.vividsolutions.jump.workbench.model.CadLayerSymbolDefinition;
import com.vividsolutions.jump.workbench.ui.Viewport;
import de.riwagis.riwajump.symbol.SymbolStore;
import de.riwagis.riwajump.symbol.resources.BuildInSymbolStore;
import de.riwagis.util.svg.SVGSupport;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public abstract class AbstractSymbolStore
implements SymbolStore {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractSymbolStore.class);
    public static final String EXT_SVG = ".svg";
    public static final String EXT_PNG = ".png";
    private transient int intCacheSize = 400;
    private transient Map<String, Object> fileCache = new LinkedHashMap<String, Object>();
    private transient Map<String, Document> docCache = new LinkedHashMap<String, Document>();
    private transient Map<String, BufferedImage> scaledImgCache = new LinkedHashMap<String, BufferedImage>();
    private transient Map<String, Double> ratioCache = new LinkedHashMap<String, Double>();
    private transient Lock cacheLock = new ReentrantLock();
    private transient BufferedImage defaultSym = null;
    private Set<String> cachedSymbolNames;

    private Object readResolve() {
        this.intCacheSize = 400;
        this.fileCache = new LinkedHashMap<String, Object>();
        this.docCache = new LinkedHashMap<String, Document>();
        this.scaledImgCache = new LinkedHashMap<String, BufferedImage>();
        this.ratioCache = new LinkedHashMap<String, Double>();
        this.cacheLock = new ReentrantLock();
        return this;
    }

    public synchronized BufferedImage getDefaultSymbol() throws IOException {
        if (this.defaultSym == null) {
            this.defaultSym = ImageIO.read(BuildInSymbolStore.class.getResourceAsStream("default.png"));
        }
        return this.defaultSym;
    }

    @Override
    public void clearCache() {
        this.cacheLock.lock();
        try {
            this.fileCache.clear();
            this.docCache.clear();
            this.scaledImgCache.clear();
            this.ratioCache.clear();
        }
        finally {
            this.cacheLock.unlock();
        }
    }

    public abstract InputStream getStreamByName(String var1) throws IOException;

    private String getCacheName(String strName, Color line, Color fill, int alphaOverwrite, boolean is4Print) {
        return this.getCacheName(strName, -1, -1, line, fill, alphaOverwrite, is4Print);
    }

    private String getCacheName(String strName, int width, int height, Color line, Color fill, int alphaOverwrite, boolean is4Print) {
        StringBuilder builder = new StringBuilder(48);
        builder.append(strName).append("_").append(width).append("_").append(height).append("_").append(alphaOverwrite).append("_").append(is4Print);
        if (line != null || fill != null) {
            builder.append("_").append(line == null ? "null" : Integer.valueOf(line.getRGB())).append("_").append(fill == null ? "null" : Integer.valueOf(fill.getRGB()));
        }
        return builder.toString();
    }

    private String getCacheName(String strName, int width, int height, int alphaOverwrite, boolean is4Print) {
        return this.getCacheName(strName, width, height, null, null, alphaOverwrite, is4Print);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Document getSVGDoc(String strName, Color line, Color fill, int alphaOverwrite, boolean is4Print) throws IOException {
        this.cacheLock.lock();
        try {
            if (this.docCache.containsKey(this.getCacheName(strName, line, fill, alphaOverwrite, is4Print))) {
                Document document = this.docCache.get(this.getCacheName(strName, line, fill, alphaOverwrite, is4Print));
                return document;
            }
            LOG.debug("Retrieving SVG Document: {} ...", (Object)strName);
            Document doc = SVGSupport.readSVG((String)("http://" + strName), (InputStream)this.getStreamByName(strName));
            LOG.debug("SVG Document retrieved.");
            if (doc != null) {
                if (line != null || fill != null) {
                    SVGSupport.replaceColor((Document)doc, (Color)line, (Color)fill, (int)alphaOverwrite, (boolean)is4Print);
                }
                if (this.docCache.size() > this.intCacheSize) {
                    this.docCache.clear();
                }
                this.docCache.put(this.getCacheName(strName, line, fill, alphaOverwrite, is4Print), doc);
            }
            Document document = doc;
            return document;
        }
        finally {
            this.cacheLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] getSVGNode(String strName, Color line, Color fill, int alphaOverwrite, boolean is4Print) throws IOException {
        this.cacheLock.lock();
        try {
            String fileCacheName = this.getCacheName(strName, line, fill, alphaOverwrite, is4Print);
            if (this.fileCache.containsKey(fileCacheName)) {
                Object[] objectArray = (Object[])this.fileCache.get(fileCacheName);
                return objectArray;
            }
            LOG.debug("Retrieving SVG Document: {} ...", (Object)strName);
            Document doc = SVGSupport.readSVG((String)("http://" + strName), (InputStream)this.getStreamByName(strName));
            LOG.debug("SVG Document retrieved.");
            if (line != null || fill != null || alphaOverwrite != 255) {
                SVGSupport.replaceColor((Document)doc, (Color)line, (Color)fill, (int)(is4Print ? alphaOverwrite : 255), (boolean)is4Print);
            }
            Object[] arrNode = null;
            if (doc != null) {
                if (this.fileCache.size() > this.intCacheSize) {
                    this.fileCache.clear();
                }
                Rectangle2D.Double rect = new Rectangle2D.Double();
                GraphicsNode gNode = SVGSupport.getGraphicsNode((Document)doc, (Rectangle2D)rect);
                arrNode = new Object[]{rect, gNode};
                this.fileCache.put(fileCacheName, arrNode);
            }
            Object[] objectArray = arrNode;
            return objectArray;
        }
        finally {
            this.cacheLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage getRasterFile(String strName) throws IOException {
        this.cacheLock.lock();
        try {
            if (this.fileCache.containsKey(strName)) {
                BufferedImage bufferedImage = (BufferedImage)this.fileCache.get(strName);
                return bufferedImage;
            }
            BufferedImage img = ImageIO.read(this.getStreamByName(strName));
            if (this.fileCache.size() > this.intCacheSize) {
                this.fileCache.clear();
            }
            this.fileCache.put(strName, img);
            BufferedImage bufferedImage = img;
            return bufferedImage;
        }
        finally {
            this.cacheLock.unlock();
        }
    }

    public void addToScaledImgCache(String strCache, BufferedImage img) {
        this.cacheLock.lock();
        try {
            if (this.scaledImgCache.size() > this.intCacheSize) {
                this.scaledImgCache.clear();
            }
            this.scaledImgCache.put(strCache, img);
        }
        finally {
            this.cacheLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addToRatioCache(String strName, double width, double height) {
        this.cacheLock.lock();
        try {
            if (this.ratioCache.size() > this.intCacheSize) {
                this.ratioCache.clear();
            }
            Double ratio = height / width;
            this.ratioCache.put(strName, ratio);
        }
        finally {
            this.cacheLock.unlock();
        }
    }

    private Shape renderDefault(Graphics2D g2d, AffineTransform trans) {
        try {
            BufferedImage defaultImg = this.getDefaultSymbol();
            trans.translate(defaultImg.getWidth() / -2, defaultImg.getHeight() / -2);
            g2d.drawImage(defaultImg, trans, null);
            return trans.createTransformedShape(new Rectangle(defaultImg.getWidth(), defaultImg.getHeight()));
        }
        catch (Exception e) {
            throw new RuntimeException("Error rendering default symbol");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Shape renderSymbol(String name, Graphics2D g2d, AffineTransform trans, int width, int height, Color line, Color fill, int alphaOverwrite) {
        this.cacheLock.lock();
        try {
            boolean is4Print;
            width = Math.max(width, 1);
            height = Math.max(height, 1);
            boolean bl = is4Print = g2d.getRenderingHint(Viewport.KEY_IS4PRINT) != null;
            if (StringUtils.endsWithIgnoreCase((CharSequence)name, (CharSequence)EXT_SVG)) {
                Object[] arrNode = this.getSVGNode(name, line, fill, alphaOverwrite, is4Print);
                GraphicsNode gNode = (GraphicsNode)arrNode[1];
                AffineTransform aff = new AffineTransform();
                Rectangle2D rect = (Rectangle2D)arrNode[0];
                aff.scale((double)width / rect.getWidth(), (double)height / rect.getHeight());
                aff.translate(rect.getWidth() / -2.0, rect.getHeight() / -2.0);
                trans.concatenate(aff);
                Color g2dDefaultColor = g2d.getColor();
                Composite g2dDefaultComposite = g2d.getComposite();
                Composite gNodeDefaultComposite = gNode.getComposite();
                if (!is4Print) {
                    g2d.setColor(new Color(255, 255, 255, alphaOverwrite));
                    gNode.setComposite((Composite)this.getComposite(alphaOverwrite));
                }
                Shape shp = SVGSupport.renderToGraphics((Graphics2D)g2d, (AffineTransform)trans, (GraphicsNode)gNode);
                g2d.setColor(g2dDefaultColor);
                g2d.setComposite(g2dDefaultComposite);
                gNode.setComposite(gNodeDefaultComposite);
                Shape shape = shp;
                return shape;
            }
            if (StringUtils.endsWithIgnoreCase((CharSequence)name, (CharSequence)EXT_PNG)) {
                BufferedImage scaledImg;
                String imgCacheName = this.getCacheName(name, width, height, line, fill, alphaOverwrite, is4Print);
                if (this.scaledImgCache.containsKey(imgCacheName)) {
                    scaledImg = this.scaledImgCache.get(imgCacheName);
                } else {
                    BufferedImage img = this.getRasterFile(name);
                    AffineTransform aff = new AffineTransform();
                    aff.scale((double)width / (double)img.getWidth(), (double)height / (double)img.getHeight());
                    AffineTransformOp op = new AffineTransformOp(aff, 2);
                    scaledImg = new BufferedImage(width, height, 2);
                    if (alphaOverwrite == 255) {
                        op.filter(img, scaledImg);
                    } else {
                        Graphics2D alphaG2d = scaledImg.createGraphics();
                        alphaG2d.setComposite(this.getComposite(alphaOverwrite));
                        alphaG2d.drawImage(img, op, 0, 0);
                        alphaG2d.dispose();
                    }
                    this.addToScaledImgCache(this.getCacheName(name, width, height, alphaOverwrite, is4Print), scaledImg);
                }
                trans.translate(scaledImg.getWidth() / -2, scaledImg.getHeight() / -2);
                g2d.drawImage(scaledImg, trans, null);
                Shape shape = trans.createTransformedShape(new Rectangle(scaledImg.getWidth(), scaledImg.getHeight()));
                return shape;
            }
            try {
                throw new Exception(this.getClass().getName() + ": invalid file type - " + name);
            }
            catch (Exception e) {
                LOG.warn(String.format("Error rendering symbol '%s': %s", name, e.getMessage()), (Throwable)e);
                Shape shape = this.renderDefault(g2d, trans);
                return shape;
            }
        }
        finally {
            this.cacheLock.unlock();
        }
    }

    private AlphaComposite getComposite(int alphaOverwrite) {
        return AlphaComposite.getInstance(3, (float)alphaOverwrite / 255.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Shape renderSymbol(String name, Graphics2D g2d, AffineTransform trans, int width, Color line, Color fill, int alphaOverwrite) {
        this.cacheLock.lock();
        try {
            int height = width;
            if (this.ratioCache.containsKey(name)) {
                double ratio = this.ratioCache.get(name);
                height = (int)((double)width * ratio);
            } else {
                if (StringUtils.endsWithIgnoreCase((CharSequence)name, (CharSequence)EXT_SVG)) {
                    Object[] arrNode = this.getSVGNode(name, line, fill, alphaOverwrite, false);
                    Rectangle2D rect = (Rectangle2D)arrNode[0];
                    height = (int)(rect.getHeight() / rect.getWidth() * (double)width);
                    this.addToRatioCache(name, rect.getWidth(), rect.getHeight());
                }
                if (StringUtils.endsWithIgnoreCase((CharSequence)name, (CharSequence)EXT_PNG)) {
                    BufferedImage img = this.getRasterFile(name);
                    height = (int)((double)width * ((double)img.getHeight() / (double)img.getWidth()));
                    this.addToRatioCache(name, img.getWidth(), img.getHeight());
                }
            }
            Shape shape = this.renderSymbol(name, g2d, trans, width, height, line, fill, alphaOverwrite);
            return shape;
        }
        catch (Exception e) {
            LOG.warn(String.format("Error rendering symbol '%s': %s", name, e.getMessage()), (Throwable)e);
            Shape shape = this.renderDefault(g2d, trans);
            return shape;
        }
        finally {
            this.cacheLock.unlock();
        }
    }

    @Override
    public BufferedImage getSymbol(String name, int width, int height, Color line, Color fill, int alphaOverwrite, boolean is4Print) throws IOException {
        this.cacheLock.lock();
        try {
            width = Math.max(width, 1);
            height = Math.max(height, 1);
            String cacheName = this.getCacheName(name, width, height, line, fill, alphaOverwrite, is4Print);
            if (this.scaledImgCache.containsKey(cacheName)) {
                BufferedImage bufferedImage = this.scaledImgCache.get(cacheName);
                return bufferedImage;
            }
            if (StringUtils.endsWithIgnoreCase((CharSequence)name, (CharSequence)EXT_SVG)) {
                Document doc = this.getSVGDoc(name, line, fill, alphaOverwrite, is4Print);
                BufferedImage bufImg = SVGSupport.renderToImage((Document)doc, (int)width, (int)height);
                this.addToScaledImgCache(cacheName, bufImg);
                BufferedImage bufferedImage = bufImg;
                return bufferedImage;
            }
            if (StringUtils.endsWithIgnoreCase((CharSequence)name, (CharSequence)EXT_PNG)) {
                BufferedImage img = this.getRasterFile(name);
                AffineTransform aff = new AffineTransform();
                aff.scale((double)width / (double)img.getWidth(), (double)height / (double)img.getHeight());
                AffineTransformOp op = new AffineTransformOp(aff, 2);
                BufferedImage scaledImg = new BufferedImage(width, height, 2);
                scaledImg = op.filter(img, scaledImg);
                this.addToScaledImgCache(cacheName, scaledImg);
                BufferedImage bufferedImage = scaledImg;
                return bufferedImage;
            }
            throw new IOException(this.getClass().getName() + ": invalid file type");
        }
        finally {
            this.cacheLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BufferedImage getSymbol(String name, int width, Color line, Color fill, int alphaOverwrite, boolean is4Print) throws IOException {
        this.cacheLock.lock();
        try {
            int height = width;
            if (this.ratioCache.containsKey(name)) {
                double ratio = this.ratioCache.get(name);
                height = (int)((double)width * ratio);
            } else {
                if (StringUtils.endsWithIgnoreCase((CharSequence)name, (CharSequence)EXT_SVG)) {
                    Document doc = this.getSVGDoc(name, line, fill, alphaOverwrite, is4Print);
                    Rectangle2D rect = SVGSupport.getBounds((Document)doc);
                    height = (int)(rect.getHeight() / rect.getWidth() * (double)width);
                    this.addToRatioCache(name, rect.getWidth(), rect.getHeight());
                }
                if (StringUtils.endsWithIgnoreCase((CharSequence)name, (CharSequence)EXT_PNG)) {
                    BufferedImage img = this.getRasterFile(name);
                    height = (int)((double)width * ((double)img.getHeight() / (double)img.getWidth()));
                    this.addToRatioCache(name, img.getWidth(), img.getHeight());
                }
            }
            BufferedImage bufferedImage = this.getSymbol(name, width, height, line, fill, alphaOverwrite, is4Print);
            return bufferedImage;
        }
        finally {
            this.cacheLock.unlock();
        }
    }

    @Override
    public boolean containsSymbol(String name) {
        if (this.cachedSymbolNames == null) {
            this.cachedSymbolNames = Set.of(this.getSymbolNames());
        }
        return this.cachedSymbolNames.contains(name);
    }

    public List<CadLayerSymbolDefinition> getAllSymbolDefinitions() {
        return Arrays.stream(this.getSymbolNames()).sorted(String.CASE_INSENSITIVE_ORDER).map(CadLayerSymbolDefinition::new).collect(Collectors.toList());
    }

    @Override
    public List<CadLayerSymbolDefinition> getSymbolDefinitions() {
        return this.getAllSymbolDefinitions();
    }

    @Override
    public List<CadLayerSymbolDefinition> getFillDefinitions() {
        return this.getAllSymbolDefinitions();
    }
}

