/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.search.intelligence;

import com.vividsolutions.jump.I18N;
import de.riwagis.riwajump.data.model.DMDCollection;
import de.riwagis.riwajump.data.model.FeaturestoreMetadata;
import de.riwagis.riwajump.model.event.JumpModelEvent;
import de.riwagis.riwajump.model.intelligence.IntelligenceFactory;
import de.riwagis.riwajump.model.search.SearchModel;
import de.riwagis.riwajump.model.search.SubSearchModel;
import de.riwagis.riwajump.search.intelligence.SearchIntelligence;
import de.riwagis.riwajump.search.intelligence.SearchSupport;
import de.riwagis.riwajump.search.intelligence.SearchValue;
import de.riwagis.util.gui.GUISupport;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import org.geotools.data.FeatureReader;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubSearchIntelligence
extends SearchIntelligence {
    private static final Logger LOG = LoggerFactory.getLogger(SubSearchIntelligence.class);
    private final SubSearchModel model;

    public SubSearchIntelligence(SubSearchModel model) {
        this.model = model;
    }

    public SubSearchModel getModel() {
        return this.model;
    }

    @Override
    public void fireJumpModelChanged(JumpModelEvent modelEvent) {
        super.fireJumpModelChanged(modelEvent);
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public SearchValue[] executeSearch(DMDCollection dmdCol, Component comp, Object objLink) {
        try {
            FeaturestoreMetadata fmd = new FeaturestoreMetadata();
            fmd.setDatastoreName(this.model.getRootSearchModel().getDatastore());
            fmd.setDatatypeName(this.model.getDatatypeName());
            fmd.setAttributes(this.model.getAttributes());
            Filter filt = SearchSupport.appendMatchingFilter((Filter)Filter.INCLUDE, this.model.getDatatypeName(), this.model.getLinkAttribute(), objLink);
            ArrayList<SearchValue> lstData = new ArrayList<SearchValue>();
            try (FeatureReader<SimpleFeatureType, SimpleFeature> fr = fmd.getFeatureReader(dmdCol, filt);){
                while (fr.hasNext()) {
                    SimpleFeature f = (SimpleFeature)fr.next();
                    SearchValue sv = new SearchValue((SearchModel)this.model, SearchSupport.getFeatureAtt(f, this.model.getKeyAttribute()), this.getValue4Feature(f), f.getID());
                    sv.setCompareByNumber(this.model.isOrderNumeric());
                    lstData.add(sv);
                }
            }
            SearchValue[] arrSV = (SearchValue[])lstData.toArray(SearchValue[]::new);
            Arrays.sort((Object[])arrSV);
            return arrSV;
        }
        catch (Exception e) {
            LOG.error("Could not execute sub search", (Throwable)e);
            GUISupport.msgbox((Component)comp, (String)(I18N.get("common.error") + ": " + e.getMessage()), (String)I18N.get("common.error"));
            return new SearchValue[0];
        }
    }

    static {
        IntelligenceFactory.register(SubSearchModel.class, SubSearchIntelligence::new);
    }
}

