/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.search.intelligence;

import de.riwagis.geotools.feature.util.FilterUtil;
import de.riwagis.riwajump.model.search.WildcardSearchEnum;
import de.riwagis.util.StringSupport;
import de.riwagis.util.exception.SystemException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.factory.Hints;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.identity.FeatureId;

public class SearchSupport {
    public static final String IS_NULL = "|null|";
    public static final String IS_NOT_NULL = "|!null|";
    private static final FilterFactory2 ffac = CommonFactoryFinder.getFilterFactory2((Hints)GeoTools.getDefaultHints());
    private static final String PATTERN_DECIMAL = SearchSupport.createLocalizedDecimalPattern();
    private static final Map<Pattern, BiFunction<Matcher, Expression, Filter>> DECIMAL_PATTERNS_TO_CQL = Map.of(Pattern.compile("<(?<literal>" + PATTERN_DECIMAL + ")"), (matcher, property) -> {
        Literal literal = ffac.literal(SearchSupport.parseNumberToType(matcher.group("literal")));
        return ffac.less(property, (Expression)literal);
    }, Pattern.compile(">(?<literal>" + PATTERN_DECIMAL + ")"), (matcher, property) -> {
        Literal literal = ffac.literal(SearchSupport.parseNumberToType(matcher.group("literal")));
        return ffac.greater(property, (Expression)literal);
    }, Pattern.compile("(?:<=|=<)(?<literal>" + PATTERN_DECIMAL + ")"), (matcher, property) -> {
        Literal literal = ffac.literal(SearchSupport.parseNumberToType(matcher.group("literal")));
        return ffac.lessOrEqual(property, (Expression)literal);
    }, Pattern.compile("(?:>=|=>)(?<literal>" + PATTERN_DECIMAL + ")"), (matcher, property) -> {
        Literal literal = ffac.literal(SearchSupport.parseNumberToType(matcher.group("literal")));
        return ffac.greaterOrEqual(property, (Expression)literal);
    }, Pattern.compile("(?<literal>" + PATTERN_DECIMAL + ")"), (matcher, property) -> {
        Literal literal = ffac.literal(SearchSupport.parseNumberToType(matcher.group("literal")));
        return ffac.equals(property, (Expression)literal);
    }, Pattern.compile("(?<lower>" + PATTERN_DECIMAL + ")-(?<upper>" + PATTERN_DECIMAL + ")"), (matcher, property) -> {
        Literal literalLower = ffac.literal(SearchSupport.parseNumberToType(matcher.group("lower")));
        Literal literalUpper = ffac.literal(SearchSupport.parseNumberToType(matcher.group("upper")));
        return ffac.between(property, (Expression)literalLower, (Expression)literalUpper);
    });
    private static final String PATTERN_DATE = "(?:\\d{1,2}\\.(?:\\d{1,2}\\.)?)?(?:\\d{2})?\\d{2}";
    private static final Map<Pattern, BiFunction<Matcher, Expression, Filter>> DATE_PATTERNS_TO_CQL = Map.of(Pattern.compile("<(?<literal>(?:\\d{1,2}\\.(?:\\d{1,2}\\.)?)?(?:\\d{2})?\\d{2})"), (matcher, property) -> {
        Literal literal = ffac.literal((Object)SearchSupport.parseDateLowerBound(matcher.group("literal")));
        return ffac.less(property, (Expression)literal);
    }, Pattern.compile(">(?<literal>(?:\\d{1,2}\\.(?:\\d{1,2}\\.)?)?(?:\\d{2})?\\d{2})"), (matcher, property) -> {
        Literal literal = ffac.literal((Object)SearchSupport.parseDateUpperBound(matcher.group("literal")));
        return ffac.greater(property, (Expression)literal);
    }, Pattern.compile("(?:<=|=<)(?<literal>(?:\\d{1,2}\\.(?:\\d{1,2}\\.)?)?(?:\\d{2})?\\d{2})"), (matcher, property) -> {
        Literal literal = ffac.literal((Object)SearchSupport.parseDateUpperBound(matcher.group("literal")));
        return ffac.lessOrEqual(property, (Expression)literal);
    }, Pattern.compile("(?:>=|=>)(?<literal>(?:\\d{1,2}\\.(?:\\d{1,2}\\.)?)?(?:\\d{2})?\\d{2})"), (matcher, property) -> {
        Literal literal = ffac.literal((Object)SearchSupport.parseDateLowerBound(matcher.group("literal")));
        return ffac.greaterOrEqual(property, (Expression)literal);
    }, Pattern.compile("(?<literal>(?:\\d{1,2}\\.(?:\\d{1,2}\\.)?)?(?:\\d{2})?\\d{2})"), (matcher, property) -> {
        String rawLiteral = matcher.group("literal");
        Literal literalLower = ffac.literal((Object)SearchSupport.parseDateLowerBound(rawLiteral));
        Literal literalUpper = ffac.literal((Object)SearchSupport.parseDateUpperBound(rawLiteral));
        return ffac.between(property, (Expression)literalLower, (Expression)literalUpper);
    }, Pattern.compile("(?<lower>(?:\\d{1,2}\\.(?:\\d{1,2}\\.)?)?(?:\\d{2})?\\d{2})-(?<upper>(?:\\d{1,2}\\.(?:\\d{1,2}\\.)?)?(?:\\d{2})?\\d{2})"), (matcher, property) -> {
        Literal literalLower = ffac.literal((Object)SearchSupport.parseDateLowerBound(matcher.group("lower")));
        Literal literalUpper = ffac.literal((Object)SearchSupport.parseDateUpperBound(matcher.group("upper")));
        return ffac.between(property, (Expression)literalLower, (Expression)literalUpper);
    });
    private static final Map<Class<?>, FilterCreator> TYPE_TO_FILTER = Map.of(Number.class, SearchSupport::createFilterForNumericalSearch, Date.class, SearchSupport::createFilterForTemporalSearch);

    static String[] getAttributes(String[] arrAtts) {
        ArrayList<String> lstAtt = new ArrayList<String>();
        for (String arrAtt : arrAtts) {
            if (arrAtt.equals("_PrimaryKey") || lstAtt.contains(arrAtt)) continue;
            lstAtt.add(arrAtt);
        }
        return (String[])lstAtt.toArray(String[]::new);
    }

    public static Object getFeatureAtt(SimpleFeature f, String strAttName) {
        if ("_PrimaryKey".equals(strAttName)) {
            String id = f.getID().toLowerCase();
            if (id == null) {
                return null;
            }
            int intDot = id.toLowerCase().indexOf(".");
            if (intDot > -1) {
                return id.substring(intDot + 1);
            }
            return id;
        }
        return f.getAttribute(strAttName);
    }

    public static String nullIfPrimaryKey(String themeAttribute) {
        if ("_PrimaryKey".equals(themeAttribute)) {
            return null;
        }
        return themeAttribute;
    }

    public static Filter appendFilter(Filter filt, String strDatatypeName, String strAttName, Class<?> binding, Object objValue, WildcardSearchEnum wildcardSearch) throws Exception {
        if (objValue == null || objValue.toString().isBlank()) {
            return filt;
        }
        Filter filtNew = SearchSupport.createFilterForType(binding, objValue, strAttName, strDatatypeName, wildcardSearch);
        return FilterUtil.getAndFilter((Filter)filt, (Filter)filtNew);
    }

    static Filter appendMatchingFilter(Filter filt, String strDatatypeName, String strAttName, Object objValue) throws Exception {
        if (objValue == null || objValue.toString().isBlank()) {
            return filt;
        }
        Filter filtNew = SearchSupport.createMatchingFilter(objValue, strAttName, strDatatypeName);
        return FilterUtil.getAndFilter((Filter)filt, (Filter)filtNew);
    }

    private static Filter createFilterForType(Class<?> binding, Object objValue, String strAttName, String strDatatypeName, WildcardSearchEnum wildcardSearch) throws SystemException, CQLException {
        if (!Objects.isNull(objValue)) {
            String value = objValue.toString().trim();
            if ("_PrimaryKey".equals(strAttName)) {
                return ffac.id(new FeatureId[]{ffac.featureId(value)});
            }
            if (IS_NULL.equalsIgnoreCase(value)) {
                return ffac.isNull((Expression)ffac.property(strAttName));
            }
            if (IS_NOT_NULL.equalsIgnoreCase(value)) {
                return ffac.not((Filter)ffac.isNull((Expression)ffac.property(strAttName)));
            }
        }
        if (binding != null) {
            for (Map.Entry entry : TYPE_TO_FILTER.entrySet()) {
                if (!((Class)entry.getKey()).isAssignableFrom(binding)) continue;
                return ((FilterCreator)entry.getValue()).create(objValue, strAttName);
            }
        }
        String strSearchValue = SearchSupport.adjustStringSearchRegardingWildcard(objValue, wildcardSearch);
        return SearchSupport.createFilterForStringSearch(strSearchValue, strAttName, strDatatypeName);
    }

    static boolean isQueryValidForType(Class<?> binding, String strAttName, Object objValue) {
        if (objValue == null || objValue.toString().isBlank() || binding == null) {
            return true;
        }
        try {
            for (Map.Entry<Class<?>, FilterCreator> entry : TYPE_TO_FILTER.entrySet()) {
                if (!entry.getKey().isAssignableFrom(binding)) continue;
                entry.getValue().create(objValue, strAttName);
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static Filter createFilterForNumericalSearch(Object objValue, String strAttName) throws SystemException {
        return SearchSupport.matchQueryOrThrow(objValue, strAttName, DECIMAL_PATTERNS_TO_CQL);
    }

    private static Filter createFilterForTemporalSearch(Object objValue, String strAttName) throws SystemException {
        return SearchSupport.matchQueryOrThrow(objValue, strAttName, DATE_PATTERNS_TO_CQL);
    }

    private static Filter matchQueryOrThrow(Object objValue, String strAttName, Map<Pattern, BiFunction<Matcher, Expression, Filter>> patternsAndQuerySupplier) throws SystemException {
        String strValue = objValue.toString();
        PropertyName property = ffac.property(strAttName);
        String queryWithoutWhitespaces = strValue.replaceAll("\\s", "");
        for (Map.Entry<Pattern, BiFunction<Matcher, Expression, Filter>> kv : patternsAndQuerySupplier.entrySet()) {
            Matcher matcher = kv.getKey().matcher(queryWithoutWhitespaces);
            if (!matcher.matches()) continue;
            return kv.getValue().apply(matcher, (Expression)property);
        }
        throw new SystemException("Invalid format '" + strValue + "' for attribute " + strAttName);
    }

    private static Filter createFilterForStringSearch(String strValue, String strAttName, String strDatatypeName) {
        if (strAttName.equals("_PrimaryKey")) {
            throw new IllegalArgumentException(String.format("Unable to create 'like'-filter on primary key: %s.%s==%s", strDatatypeName, strAttName, strValue));
        }
        PropertyName property = ffac.property(strAttName);
        return ffac.like((Expression)property, strValue, "%", "_", "\\", false);
    }

    private static String adjustStringSearchRegardingWildcard(Object objValue, WildcardSearchEnum wildcardSearch) {
        String strValue = objValue == null ? "" : objValue.toString().replace("*", "%");
        switch (wildcardSearch) {
            case WILDCARD_LEADING: {
                return "%" + strValue;
            }
            case WILDCARD_LEADING_AND_TRAILING: {
                return "%" + strValue + "%";
            }
            case NO_WILDCARD: {
                return strValue;
            }
        }
        return strValue + "%";
    }

    private static Filter createMatchingFilter(Object objValue, String strAttName, String strDatatypeName) throws Exception {
        if (strAttName.equals("_PrimaryKey")) {
            return FilterUtil.getFidFilter((String)(strDatatypeName + "." + String.valueOf(objValue)));
        }
        PropertyName property = ffac.property(strAttName);
        return ffac.equals((Expression)property, (Expression)ffac.literal(objValue));
    }

    private static Object parseNumberToType(String raw) {
        try {
            NumberFormat format = NumberFormat.getInstance();
            return format.parse(raw);
        }
        catch (ParseException ex) {
            throw new IllegalArgumentException("Could not parse numerical value. Regular Expression is probably missing something.", ex);
        }
    }

    private static String createLocalizedDecimalPattern() {
        DecimalFormatSymbols symbols = DecimalFormatSymbols.getInstance();
        String sep = Pattern.quote(String.valueOf(symbols.getDecimalSeparator()));
        String minus = Pattern.quote(String.valueOf(symbols.getMinusSign()));
        String zero = Pattern.quote(String.valueOf(symbols.getZeroDigit()));
        return "[" + minus + "+]?[" + zero + "\\d]+(?:" + sep + "\\d+)?";
    }

    private static Timestamp parseDateLowerBound(String rawDate) {
        LocalDate localDate = SearchSupport.expandDateAndParse(rawDate, true);
        return Timestamp.from(localDate.atStartOfDay(ZoneId.systemDefault()).toInstant());
    }

    private static Timestamp parseDateUpperBound(String rawDate) {
        LocalDate localDate = SearchSupport.expandDateAndParse(rawDate, false);
        return Timestamp.from(localDate.atTime(LocalTime.MAX).atZone(ZoneId.systemDefault()).toInstant());
    }

    private static LocalDate expandDateAndParse(String rawDate, boolean useStartOfRange) {
        String fullDate = StringSupport.shortDate2Date((String)rawDate, (boolean)false, (boolean)useStartOfRange, (DateFormat)DateFormat.getDateInstance(2, Locale.GERMAN));
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("[dd][d].[MM][M].[yyyy][yy]");
        TemporalAccessor accessor = formatter.parse(fullDate);
        return LocalDate.from(accessor);
    }

    private SearchSupport() {
    }

    @FunctionalInterface
    static interface FilterCreator {
        public Filter create(Object var1, String var2) throws SystemException;
    }
}

