/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.search.intelligence;

import com.vividsolutions.jump.I18N;
import de.riwagis.geotools.feature.util.FeatureUtil;
import de.riwagis.gis.context.map.LayerContext;
import de.riwagis.gis.context.map.MapContext;
import de.riwagis.gis.context.map.VectorLayerContext;
import de.riwagis.riwajump.data.model.DMDCollection;
import de.riwagis.riwajump.data.model.FeaturestoreMetadata;
import de.riwagis.riwajump.model.event.JumpModelEvent;
import de.riwagis.riwajump.model.intelligence.IntelligenceFactory;
import de.riwagis.riwajump.model.search.FieldInputModel;
import de.riwagis.riwajump.model.search.ListInputModel;
import de.riwagis.riwajump.model.search.RootSearchModel;
import de.riwagis.riwajump.model.search.SearchInputModel;
import de.riwagis.riwajump.model.search.SearchModel;
import de.riwagis.riwajump.model.search.SubSearchModel;
import de.riwagis.riwajump.model.search.WildcardSearchEnum;
import de.riwagis.riwajump.search.intelligence.ListInputIntelligence;
import de.riwagis.riwajump.search.intelligence.SearchIntelligence;
import de.riwagis.riwajump.search.intelligence.SearchSupport;
import de.riwagis.riwajump.search.intelligence.SearchValue;
import de.riwagis.util.exception.SystemException;
import de.riwagis.util.gui.GUISupport;
import de.riwagis.util.gui.models.KeyValue;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.geotools.data.FeatureReader;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.IncludeFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RootSearchIntelligence
extends SearchIntelligence {
    private static final Logger LOG = LoggerFactory.getLogger(RootSearchIntelligence.class);
    private SearchValue[] arrResult = null;
    private RootSearchModel model = null;

    private RootSearchIntelligence(RootSearchModel model) {
        this.model = model;
    }

    public RootSearchModel getModel() {
        return this.model;
    }

    @Override
    public void fireJumpModelChanged(JumpModelEvent modelEvent) {
        super.fireJumpModelChanged(modelEvent);
        this.arrResult = null;
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public RootSearchIntelligence getRootSearchIntelligence() {
        return this;
    }

    public void emptySearch() {
        this.arrResult = new SearchValue[0];
    }

    public void reloadLists(DMDCollection dmdCol, Component comp) {
        try {
            for (SearchInputModel si : this.model.getInput()) {
                if (!(si instanceof ListInputModel)) continue;
                ListInputIntelligence li = (ListInputIntelligence)si.createAndGetIntelligence(null);
                li.refillList(dmdCol.getByName(this.model.getDatastore()));
            }
        }
        catch (Exception e) {
            LOG.error("Could not reload lists", (Throwable)e);
            GUISupport.msgbox((Component)comp, (String)(I18N.get("common.error") + ": " + e.getMessage()), (String)I18N.get("common.error"));
        }
    }

    public void clearSearch() {
        this.arrResult = null;
    }

    public void zoomMap(DMDCollection dmdCol, Component comp, MapContext ctx, Object objKey) {
        try {
            SimpleFeatureType fType;
            String strZoomDatatype = this.model.getDatatypeName();
            String strZoomKeyAtt = this.model.getKeyAttribute();
            List lstSubSearches = this.model.getSubSearches();
            if (!lstSubSearches.isEmpty()) {
                SubSearchModel subSearchModel = (SubSearchModel)lstSubSearches.get(lstSubSearches.size() - 1);
                strZoomDatatype = subSearchModel.getDatatypeName();
                strZoomKeyAtt = subSearchModel.getKeyAttribute();
            }
            if ((fType = dmdCol.getByName(this.model.getDatastore()).getDataStore().getSchema(strZoomDatatype)).getGeometryDescriptor() == null) {
                throw new IllegalArgumentException("No geometry column found.");
            }
            String strGeomAtt = fType.getGeometryDescriptor().getLocalName();
            FeaturestoreMetadata fmd = new FeaturestoreMetadata();
            fmd.setDatastoreName(this.model.getDatastore());
            fmd.setDatatypeName(strZoomDatatype);
            fmd.setAttributes(SearchSupport.getAttributes(new String[]{strZoomKeyAtt, strGeomAtt}));
            Filter filt = SearchSupport.appendMatchingFilter((Filter)Filter.INCLUDE, strZoomDatatype, strZoomKeyAtt, objKey);
            try (FeatureReader<SimpleFeatureType, SimpleFeature> fr = fmd.getFeatureReader(dmdCol, filt);){
                SimpleFeature f = (SimpleFeature)fr.next();
                if (f.getDefaultGeometry() == null) {
                    GUISupport.msgbox((Component)comp, (String)I18N.get("de.riwagis.riwajump.search.model.RootSearch.no-geometry-found"), (String)I18N.get("common.error"));
                    return;
                }
                List lstLayer = this.model.getLayers();
                for (String strLy : lstLayer) {
                    LayerContext lctx = ctx.getMapLayer(strLy);
                    if (!(lctx instanceof VectorLayerContext) || lctx.isVisible()) continue;
                    lctx.setVisible(true);
                }
                Runnable runSel = () -> {
                    try {
                        int counter = 0;
                        for (String strLy : lstLayer) {
                            LayerContext lctx = ctx.getMapLayer(strLy);
                            if (lctx instanceof VectorLayerContext) {
                                ((VectorLayerContext)lctx).setSelection(new String[]{objKey.toString()}, false, 500.0, counter == 0);
                            }
                            ++counter;
                        }
                    }
                    catch (Exception e) {
                        LOG.error("Error at zoomMap", (Throwable)e);
                        GUISupport.msgbox((Component)comp, (String)(I18N.get("common.error") + ": " + e.getMessage()), (String)I18N.get("common.error"));
                    }
                };
                ctx.zoomGeometry((Geometry)f.getDefaultGeometry(), (double)this.model.getScale(), runSel, null);
            }
        }
        catch (Exception e) {
            LOG.error("Error at zoomMap", (Throwable)e);
            GUISupport.msgbox((Component)comp, (String)(I18N.get("common.error") + ": " + e.getMessage()), (String)I18N.get("common.error"));
        }
    }

    @Override
    public SearchValue[] executeSearch(DMDCollection dmdCol, Component comp, Object objLink) {
        try {
            return this.executeRootSearch(dmdCol, comp, objLink);
        }
        catch (SystemException e) {
            LOG.error("Error executing Search", (Throwable)e);
            return new SearchValue[0];
        }
        catch (Exception e) {
            LOG.error("Error executing Search", (Throwable)e);
            GUISupport.msgbox((Component)comp, (String)e.getMessage(), (String)I18N.get("common.error"));
            return new SearchValue[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SearchValue[] executeRootSearch(DMDCollection dmdCol, Component comp, Object objLink) throws Exception {
        if (this.arrResult == null) {
            FeaturestoreMetadata fmd = new FeaturestoreMetadata();
            fmd.setDatastoreName(this.model.getDatastore());
            fmd.setDatatypeName(this.model.getDatatypeName());
            fmd.setAttributes(this.model.getAttributes());
            SimpleFeatureType schema = fmd.getSchema(dmdCol);
            List lstInput = this.model.getInput();
            IncludeFilter filt = Filter.INCLUDE;
            for (SearchInputModel si : lstInput) {
                Class binding = schema.getDescriptor(si.getAttribute()).getType().getBinding();
                if (si instanceof FieldInputModel) {
                    FieldInputModel fi = (FieldInputModel)si;
                    if (!SearchSupport.isQueryValidForType(binding, si.getAttribute(), si.getSearchValue())) {
                        throw new SystemException(I18N.getMessage("de.riwagis.riwajump.search.model.RootSearch.invalid-search-for-field", si.getName()));
                    }
                    WildcardSearchEnum searchType = WildcardSearchEnum.byValue((String)fi.getWildcard());
                    filt = SearchSupport.appendFilter((Filter)filt, fmd.getDatatypeName(), si.getAttribute(), binding, si.getSearchValue(), searchType);
                    continue;
                }
                KeyValue kv = (KeyValue)si.getSearchValue();
                if (kv == null) continue;
                Object objKey = kv.getKey();
                filt = SearchSupport.appendMatchingFilter((Filter)filt, fmd.getDatatypeName(), si.getAttribute(), objKey);
            }
            if (filt == Filter.INCLUDE) {
                throw new SystemException(I18N.get("de.riwagis.riwajump.search.model.RootSearch.insert-search-input"));
            }
            ArrayList<SearchValue> lstData = new ArrayList<SearchValue>();
            FeatureReader<SimpleFeatureType, SimpleFeature> fr = fmd.getFeatureReader(dmdCol, (Filter)filt);
            try {
                while (fr.hasNext()) {
                    SimpleFeature f = (SimpleFeature)fr.next();
                    SearchValue sv = new SearchValue((SearchModel)this.model, SearchSupport.getFeatureAtt(f, this.model.getKeyAttribute()), this.getValue4Feature(f), f.getID());
                    sv.setCompareByNumber(this.model.isOrderNumeric());
                    lstData.add(sv);
                }
            }
            finally {
                FeatureUtil.closeQuietly(fr);
            }
            this.arrResult = (SearchValue[])lstData.toArray(SearchValue[]::new);
            Arrays.sort((Object[])this.arrResult);
        }
        return this.arrResult;
    }

    static {
        IntelligenceFactory.register(RootSearchModel.class, RootSearchIntelligence::new);
    }
}

