/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.search.intelligence;

import de.riwagis.geotools.feature.bsh.FeatBshStringBuilder;
import de.riwagis.riwajump.data.model.DatastoreMetadata;
import de.riwagis.riwajump.data.model.FeaturestoreMetadata;
import de.riwagis.riwajump.model.event.JumpModelEvent;
import de.riwagis.riwajump.model.intelligence.IntelligenceFactory;
import de.riwagis.riwajump.model.intelligence.JumpModelIntelligence;
import de.riwagis.riwajump.model.search.ListInputModel;
import de.riwagis.riwajump.search.intelligence.SearchSupport;
import de.riwagis.util.exception.SystemException;
import de.riwagis.util.gui.models.KeyValue;
import java.util.ArrayList;
import java.util.Arrays;
import org.geotools.data.FeatureReader;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;

public class ListInputIntelligence
implements JumpModelIntelligence {
    private final ListInputModel model;
    private KeyValue[] arrListCache = null;
    private Filter tmpFilter = null;
    private FeatBshStringBuilder valueBuilder = null;

    private ListInputIntelligence(ListInputModel model) {
        this.model = model;
    }

    public ListInputModel getModel() {
        return this.model;
    }

    public void fireJumpModelChanged(JumpModelEvent modelEvent) {
        this.arrListCache = null;
        this.valueBuilder = null;
    }

    private FeatBshStringBuilder getValueBuilder() throws Exception {
        if (this.valueBuilder == null) {
            this.valueBuilder = FeatBshStringBuilder.getInstance((String)this.getModel().getValueAttribute());
        }
        return this.valueBuilder;
    }

    protected String getValue4Feature(SimpleFeature f) throws Exception {
        this.getValueBuilder().setFeature(f);
        return this.getValueBuilder().getString();
    }

    public void setTmpFilter(Filter _tmpFilter) {
        this.tmpFilter = _tmpFilter;
        this.arrListCache = null;
    }

    public void refillList(DatastoreMetadata dmd) throws SystemException {
        try {
            FeaturestoreMetadata fmd = new FeaturestoreMetadata();
            fmd.setDatastoreName(dmd.getName());
            fmd.setDatatypeName(this.model.getDatatypeName());
            fmd.setAttributes(new String[]{"*"});
            FeatureReader<SimpleFeatureType, SimpleFeature> fr = this.tmpFilter == null ? fmd.getFeatureReader(dmd.getDataStore(), (Filter)Filter.INCLUDE) : fmd.getFeatureReader(dmd.getDataStore(), this.tmpFilter);
            try (FeatureReader<SimpleFeatureType, SimpleFeature> featureReader = fr;){
                ArrayList<KeyValue> lstData = new ArrayList<KeyValue>();
                while (fr.hasNext()) {
                    SimpleFeature f = (SimpleFeature)fr.next();
                    KeyValue kv = new KeyValue(SearchSupport.getFeatureAtt(f, this.model.getKeyAttribute()), (Object)this.getValue4Feature(f));
                    if (lstData.contains(kv)) continue;
                    lstData.add(kv);
                }
                this.arrListCache = (KeyValue[])lstData.toArray(KeyValue[]::new);
                Arrays.sort(this.arrListCache);
            }
        }
        catch (Exception e) {
            throw new SystemException(this.getClass(), String.format("Fehler in refillList: '%s'", e.getMessage()), (Throwable)e);
        }
    }

    public KeyValue[] getList(DatastoreMetadata dmd) throws SystemException {
        if (this.arrListCache == null) {
            this.refillList(dmd);
        }
        return this.arrListCache;
    }

    static {
        IntelligenceFactory.register(ListInputModel.class, ListInputIntelligence::new);
    }
}

