/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.search.gui;

import com.vividsolutions.jump.I18N;
import de.riwagis.geotools.feature.bsh.FeatBshValidator;
import de.riwagis.riwajump.data.gui.AttributeListDialog;
import de.riwagis.riwajump.data.gui.DatatypeListDialog;
import de.riwagis.riwajump.data.model.DMDCollection;
import de.riwagis.riwajump.data.model.DatastoreMetadata;
import de.riwagis.riwajump.model.search.SearchModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.geotools.data.DataStore;
import org.geotools.data.FeatureReader;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchPanel
extends JPanel {
    private static final Logger LOG = LoggerFactory.getLogger(SearchPanel.class);
    private DMDCollection dmdCol = null;
    private SearchModel search = null;
    private boolean blockEvents = false;
    private final List<JComboBox<String>> lstCmbAtt = new ArrayList<JComboBox<String>>();
    private DatatypeListDialog dlgDatatype = null;
    private AttributeListDialog dlgAttribute = null;
    private SimpleFeatureType fType = null;
    private JButton butAtt;
    private JButton butTable;
    private JCheckBox chkNumeric;
    private JComboBox<String> cmbKey;
    private JComboBox<String> cmbLink;
    private JLabel lblAtt;
    private JLabel lblDatatype;
    private JLabel lblDesc;
    private JLabel lblKey;
    private JLabel lblLink;
    private JLabel lblName;
    private JLabel lblValue;
    private JScrollPane spDesc;
    private JTextArea txaDesc;
    private JTextField txtAtt;
    private JTextField txtName;
    private JTextField txtTable;
    private JTextField txtValue;

    public SearchPanel() {
        this.initComponents();
        this.init();
        this.i18n();
    }

    public SearchPanel(SearchModel _search, DMDCollection _dmdCol) {
        this();
        this.setSearch(_search, _dmdCol);
    }

    public final void setSearch(SearchModel _search, DMDCollection _dmdCol) {
        this.dmdCol = _dmdCol;
        this.search = _search;
        this.fType = null;
        this.blockEvents = true;
        try {
            this.txtName.setText(this.search.getName());
            this.txaDesc.setText(this.search.getDescription());
            this.txtTable.setText(this.search.getDatatypeName());
            this.updateAttributesText();
            this.addAttributes();
            this.chkNumeric.setSelected(this.search.isOrderNumeric());
            this.validateValueExpression();
        }
        finally {
            this.blockEvents = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAttributesText() {
        boolean blockEventsTmp = this.blockEvents;
        this.blockEvents = true;
        try {
            StringBuilder sbAtt = new StringBuilder();
            for (String attribute : this.search.getAttributes()) {
                if (sbAtt.length() > 0) {
                    sbAtt.append(',');
                }
                sbAtt.append(attribute);
            }
            this.txtAtt.setText(sbAtt.toString());
        }
        finally {
            this.blockEvents = blockEventsTmp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAttributes() {
        boolean blockEventsTmp = this.blockEvents;
        this.blockEvents = true;
        try {
            String[] arrAtt = this.search.getAttributes();
            Arrays.sort(arrAtt, String.CASE_INSENSITIVE_ORDER);
            for (JComboBox<String> cmb : this.lstCmbAtt) {
                cmb.removeAllItems();
                cmb.addItem("_PrimaryKey");
                for (String arrAtt1 : arrAtt) {
                    cmb.addItem(arrAtt1);
                }
            }
            this.cmbLink.setSelectedItem(this.search.getLinkAttribute());
            this.cmbKey.setSelectedItem(this.search.getKeyAttribute());
            this.txtValue.setText(this.search.getValueAttribute());
            this.search.setKeyAttribute(this.cmbKey.getSelectedItem().toString());
            this.search.setLinkAttribute(this.cmbLink.getSelectedItem().toString());
            this.search.setValueAttribute(this.txtValue.getText());
        }
        finally {
            this.blockEvents = blockEventsTmp;
        }
    }

    private void i18n() {
        this.lblDatatype.setText(I18N.get("de.riwagis.riwajump.SearchPanel.table"));
        this.lblName.setText(I18N.get("de.riwagis.riwajump.SearchPanel.name"));
        this.lblDesc.setText(I18N.get("de.riwagis.riwajump.SearchPanel.desc"));
        this.lblLink.setText(I18N.get("de.riwagis.riwajump.SearchPanel.link"));
        this.lblKey.setText(I18N.get("de.riwagis.riwajump.SearchPanel.key"));
        this.lblValue.setText(I18N.get("de.riwagis.riwajump.SearchPanel.value"));
        this.chkNumeric.setText(I18N.get("de.riwagis.riwajump.SearchPanel.numeric"));
        this.lblAtt.setText(I18N.get("de.riwagis.riwajump.SearchPanel.atts"));
    }

    private void init() {
        this.lstCmbAtt.add(this.cmbKey);
        this.lstCmbAtt.add(this.cmbLink);
    }

    public String isInputValid() {
        if (this.search.getName() == null || this.search.getName().trim().length() == 0) {
            return I18N.get("de.riwagis.riwajump.SearchPanel.no-name");
        }
        if (this.search.getDatatypeName() == null || this.search.getDatatypeName().trim().length() == 0) {
            return I18N.get("de.riwagis.riwajump.SearchPanel.no-datatypename");
        }
        if (this.search.getAttributes() == null || this.search.getAttributes().length == 0) {
            return I18N.get("de.riwagis.riwajump.SearchPanel.no-atts");
        }
        if (!this.validateValueExpression()) {
            return I18N.get("de.riwagis.riwajump.SearchPanel.wrong-value-statement");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SimpleFeatureType retrieveFeatureType() throws IOException {
        if (this.fType == null) {
            DatastoreMetadata dmd = this.dmdCol.getByName(this.search.getRootSearchModel().getDatastore());
            DataStore store = dmd.getDataStore();
            Query query = new Query(this.search.getDatatypeName(), (Filter)Filter.EXCLUDE, this.search.getAttributes());
            FeatureReader fr = null;
            try {
                fr = store.getFeatureReader(query, Transaction.AUTO_COMMIT);
                this.fType = (SimpleFeatureType)fr.getFeatureType();
            }
            finally {
                try {
                    fr.close();
                }
                catch (Exception exception) {}
            }
        }
        return this.fType;
    }

    private boolean validateValueExpression() {
        try {
            if (FeatBshValidator.validateTextExpression((String)this.txtValue.getText(), (SimpleFeatureType)this.retrieveFeatureType()) == null) {
                this.txtValue.setForeground(Color.GREEN.darker());
                return true;
            }
            this.txtValue.setForeground(Color.RED.darker());
        }
        catch (Exception e) {
            this.txtValue.setForeground(Color.RED.darker());
        }
        return false;
    }

    private void initComponents() {
        this.lblDatatype = new JLabel();
        this.lblName = new JLabel();
        this.lblDesc = new JLabel();
        this.lblLink = new JLabel();
        this.lblKey = new JLabel();
        this.lblValue = new JLabel();
        this.txtName = new JTextField();
        this.spDesc = new JScrollPane();
        this.txaDesc = new JTextArea();
        this.cmbLink = new JComboBox();
        this.cmbKey = new JComboBox();
        this.chkNumeric = new JCheckBox();
        this.txtTable = new JTextField();
        this.butTable = new JButton();
        this.lblAtt = new JLabel();
        this.txtAtt = new JTextField();
        this.butAtt = new JButton();
        this.txtValue = new JTextField();
        this.setLayout(new GridBagLayout());
        this.lblDatatype.setText("Tabelle:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(4, 3, 3, 3);
        this.add((Component)this.lblDatatype, gridBagConstraints);
        this.lblName.setText("Name:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.lblName, gridBagConstraints);
        this.lblDesc.setText("Beschreibung:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.lblDesc, gridBagConstraints);
        this.lblLink.setText("Verkn\u00fcpfung:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(4, 3, 3, 3);
        this.add((Component)this.lblLink, gridBagConstraints);
        this.lblKey.setText("Schl\u00fcssel:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(4, 3, 3, 3);
        this.add((Component)this.lblKey, gridBagConstraints);
        this.lblValue.setText("Wert:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(4, 3, 3, 3);
        this.add((Component)this.lblValue, gridBagConstraints);
        this.txtName.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                SearchPanel.this.txtName_onKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.txtName, gridBagConstraints);
        this.txaDesc.setColumns(20);
        this.txaDesc.setFont(this.txtName.getFont());
        this.txaDesc.setRows(2);
        this.txaDesc.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                SearchPanel.this.txaDesc_onKeyReleased(evt);
            }
        });
        this.spDesc.setViewportView(this.txaDesc);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.spDesc, gridBagConstraints);
        this.cmbLink.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchPanel.this.cmbLink_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add(this.cmbLink, gridBagConstraints);
        this.cmbKey.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchPanel.this.cmbKey_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add(this.cmbKey, gridBagConstraints);
        this.chkNumeric.setText("numerisch");
        this.chkNumeric.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.chkNumeric.setMargin(new Insets(0, 0, 0, 0));
        this.chkNumeric.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchPanel.this.chkNumeric_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 3, 3, 3);
        this.add((Component)this.chkNumeric, gridBagConstraints);
        this.txtTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                SearchPanel.this.txtTable_onKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 3, 3, 3);
        this.add((Component)this.txtTable, gridBagConstraints);
        this.butTable.setText("...");
        this.butTable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchPanel.this.butTable_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.butTable, gridBagConstraints);
        this.lblAtt.setText("Attribute:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(4, 3, 3, 3);
        this.add((Component)this.lblAtt, gridBagConstraints);
        this.txtAtt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                SearchPanel.this.txtAtt_onKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 3, 3, 3);
        this.add((Component)this.txtAtt, gridBagConstraints);
        this.butAtt.setText("...");
        this.butAtt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchPanel.this.butAtt_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.butAtt, gridBagConstraints);
        this.txtValue.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                SearchPanel.this.txtValueKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.txtValue, gridBagConstraints);
    }

    private void txaDesc_onKeyReleased(KeyEvent evt) {
        if (this.blockEvents) {
            return;
        }
        this.search.setDescription(this.txaDesc.getText());
    }

    private void txtName_onKeyReleased(KeyEvent evt) {
        if (this.blockEvents) {
            return;
        }
        this.search.setName(this.txtName.getText());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void txtAtt_onKeyReleased(KeyEvent evt) {
        if (this.blockEvents) {
            return;
        }
        try {
            String[] arrAtt = this.txtAtt.getText().split(",");
            ArrayList<String> lstAtt = new ArrayList<String>();
            for (int i = 0; i < arrAtt.length; ++i) {
                if (arrAtt[i] == null) {
                    return;
                }
                arrAtt[i] = arrAtt[i].trim();
                if (arrAtt[i].isEmpty()) continue;
                lstAtt.add(arrAtt[i]);
            }
            arrAtt = lstAtt.toArray(new String[lstAtt.size()]);
            this.search.setAttributes(arrAtt);
            this.addAttributes();
        }
        finally {
            this.fType = null;
            this.validateValueExpression();
        }
    }

    private void txtTable_onKeyReleased(KeyEvent evt) {
        if (this.blockEvents) {
            return;
        }
        try {
            this.search.setDatatypeName(this.txtTable.getText());
            this.fType = null;
        }
        finally {
            this.fType = null;
            this.validateValueExpression();
        }
    }

    private void chkNumeric_onActionPerformed(ActionEvent evt) {
        if (this.blockEvents) {
            return;
        }
        this.search.setOrderNumeric(this.chkNumeric.isSelected());
    }

    private void cmbKey_onActionPerformed(ActionEvent evt) {
        if (this.blockEvents) {
            return;
        }
        this.search.setKeyAttribute(this.cmbKey.getSelectedItem().toString());
    }

    private void cmbLink_onActionPerformed(ActionEvent evt) {
        if (this.blockEvents) {
            return;
        }
        this.search.setLinkAttribute(this.cmbLink.getSelectedItem().toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void butAtt_onActionPerformed(ActionEvent evt) {
        try {
            DatastoreMetadata dmd = this.dmdCol.getByName(this.search.getRootSearchModel().getDatastore());
            DataStore store = dmd.getDataStore();
            SimpleFeatureType ftype = store.getSchema(this.search.getDatatypeName());
            if (this.dlgAttribute == null) {
                this.dlgAttribute = AttributeListDialog.createCenteredToWindow(this);
            }
            this.dlgAttribute.setFeatureType(ftype);
            this.dlgAttribute.setAttributeNames(this.search.getAttributes());
            this.dlgAttribute.setVisible(true);
            if (this.dlgAttribute.wasOKPressed()) {
                String[] arrAttNames = this.dlgAttribute.getAttributeNames();
                this.search.setAttributes(arrAttNames);
                this.updateAttributesText();
                this.addAttributes();
            }
        }
        catch (Exception e) {
            LOG.error(I18N.get("common.error") + ": " + e.getMessage(), (Throwable)e);
            JOptionPane.showMessageDialog(this, I18N.get("common.error") + ": " + e.getMessage());
        }
        finally {
            this.fType = null;
            this.validateValueExpression();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void butTable_onActionPerformed(ActionEvent evt) {
        try {
            DatastoreMetadata dmd = this.dmdCol.getByName(this.search.getRootSearchModel().getDatastore());
            DataStore store = dmd.getDataStore();
            if (this.dlgDatatype == null) {
                this.dlgDatatype = DatatypeListDialog.createCenteredToWindow(this);
            }
            this.dlgDatatype.setTypeNames(store.getTypeNames());
            if (this.search.getDatatypeName() != null) {
                this.dlgDatatype.setDatatype(this.search.getDatatypeName());
            }
            this.dlgDatatype.setVisible(true);
            if (this.dlgDatatype.wasOKPressed()) {
                this.search.setDatatypeName(this.dlgDatatype.getDatatype());
                this.txtTable.setText(this.dlgDatatype.getDatatype());
            }
        }
        catch (Exception e) {
            LOG.error(I18N.get("common.error") + ": " + e.getMessage(), (Throwable)e);
            JOptionPane.showMessageDialog(this, I18N.get("common.error") + ": " + e.getMessage());
        }
        finally {
            this.fType = null;
            this.validateValueExpression();
        }
    }

    private void txtValueKeyReleased(KeyEvent evt) {
        if (this.blockEvents) {
            return;
        }
        this.validateValueExpression();
        this.search.setValueAttribute(this.txtValue.getText());
    }
}

