/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.search.gui;

import de.riwagis.icons.IconLoader;
import de.riwagis.riwajump.search.gui.ListEditor;
import de.riwagis.util.gui.models.ListListModel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;

public class SearchListPanel<T>
extends JPanel {
    private ListListModel<T> lstModel = null;
    private ListEditor<T> lsEdit = null;
    private JButton butDelete;
    private JButton butDown;
    private JButton butEdit;
    private JButton butNew;
    private JButton butUp;
    private JScrollPane jScrollPane1;
    private JList<T> lstDataList;

    public SearchListPanel() {
        this.initComponents();
        this.init(new ArrayList());
        this.butDelete.setIcon(IconLoader.svgIcon((String)"common_delete.svg"));
        this.butEdit.setIcon(IconLoader.svgIcon((String)"common_edit.svg"));
        this.butNew.setIcon(IconLoader.svgIcon((String)"common_add.svg"));
        this.butUp.setIcon(IconLoader.svgIcon((String)"common_triangle_up.svg"));
        this.butDown.setIcon(IconLoader.svgIcon((String)"common_triangle_down.svg"));
    }

    private void init(List<T> _lstData) {
        this.lstModel = new ListListModel(_lstData);
        this.lstDataList.setModel((ListModel<T>)this.lstModel);
        if (_lstData.size() > 0) {
            this.lstDataList.setSelectedIndex(0);
        }
    }

    public void setData(List<T> _lstData) {
        this.init(_lstData);
    }

    public List<T> getData() {
        return new ArrayList(this.lstModel.getList());
    }

    public void setListEditor(ListEditor<T> _lsEdit) {
        this.lsEdit = _lsEdit;
    }

    private void initComponents() {
        this.butNew = new JButton();
        this.butEdit = new JButton();
        this.butDelete = new JButton();
        this.butUp = new JButton();
        this.butDown = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.lstDataList = new JList();
        this.setLayout(new GridBagLayout());
        this.butNew.setMargin(new Insets(2, 2, 2, 2));
        this.butNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchListPanel.this.butNew_onActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.butNew, gridBagConstraints);
        this.butEdit.setMargin(new Insets(2, 2, 2, 2));
        this.butEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchListPanel.this.butEdit_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.butEdit, gridBagConstraints);
        this.butDelete.setMargin(new Insets(2, 2, 2, 2));
        this.butDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchListPanel.this.butDelete_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.butDelete, gridBagConstraints);
        this.butUp.setMargin(new Insets(2, 2, 2, 2));
        this.butUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchListPanel.this.butUp_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.butUp, gridBagConstraints);
        this.butDown.setMargin(new Insets(2, 2, 2, 2));
        this.butDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchListPanel.this.butDown_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.butDown, gridBagConstraints);
        this.lstDataList.setSelectionMode(0);
        this.lstDataList.setVerifyInputWhenFocusTarget(false);
        this.lstDataList.setVisibleRowCount(5);
        this.lstDataList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SearchListPanel.this.lstDataList_onMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.lstDataList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
    }

    private void lstDataList_onMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            this.butEdit_onActionPerformed(null);
        }
    }

    private void butDown_onActionPerformed(ActionEvent evt) {
        if (this.lstDataList.getSelectedIndices().length == 0) {
            return;
        }
        if (this.lstDataList.getSelectedIndex() >= this.lstModel.getSize() - 1) {
            return;
        }
        int intIdx = this.lstDataList.getSelectedIndex();
        Object objUp = this.lstModel.getElementAt(intIdx);
        Object objDown = this.lstModel.getElementAt(intIdx + 1);
        String strDummy = "dummy";
        this.lstModel.replaceListObject(objUp, (Object)strDummy);
        this.lstModel.replaceListObject(objDown, objUp);
        this.lstModel.replaceListObject((Object)strDummy, objDown);
        this.lstDataList.setSelectedIndex(intIdx + 1);
    }

    private void butUp_onActionPerformed(ActionEvent evt) {
        if (this.lstDataList.getSelectedIndices().length == 0) {
            return;
        }
        if (this.lstDataList.getSelectedIndex() <= 0) {
            return;
        }
        int intIdx = this.lstDataList.getSelectedIndex();
        Object objDown = this.lstModel.getElementAt(intIdx);
        Object objUp = this.lstModel.getElementAt(intIdx - 1);
        String strDummy = "dummy";
        this.lstModel.replaceListObject(objUp, (Object)strDummy);
        this.lstModel.replaceListObject(objDown, objUp);
        this.lstModel.replaceListObject((Object)strDummy, objDown);
        this.lstDataList.setSelectedIndex(intIdx - 1);
    }

    private void butDelete_onActionPerformed(ActionEvent evt) {
        if (this.lstDataList.getSelectedIndices().length == 0) {
            return;
        }
        T objSearch = this.lstDataList.getSelectedValue();
        this.lstModel.removeListObject(objSearch);
        if (this.lstModel.getSize() > 0) {
            this.lstDataList.setSelectedIndex(0);
        }
    }

    private void butEdit_onActionPerformed(ActionEvent evt) {
        if (this.lstDataList.getSelectedIndices().length == 0) {
            return;
        }
        T objSearch = this.lstDataList.getSelectedValue();
        T objSearchNew = this.lsEdit.editObject(objSearch);
        if (objSearchNew != null) {
            this.lstModel.replaceListObject(objSearch, objSearchNew);
        }
    }

    private void butNew_onActionPerformed(ActionEvent evt) {
        T objSearchNew = this.lsEdit.newObject();
        if (objSearchNew != null) {
            this.lstModel.addListObject(objSearchNew);
            this.lstDataList.setSelectedValue(objSearchNew, true);
        }
    }
}

