/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.search.gui;

import com.vividsolutions.jump.I18N;
import de.riwagis.geotools.feature.bsh.FeatBshValidator;
import de.riwagis.riwajump.data.gui.DatatypeListDialog;
import de.riwagis.riwajump.data.model.DMDCollection;
import de.riwagis.riwajump.data.model.DatastoreMetadata;
import de.riwagis.riwajump.model.search.FieldInputModel;
import de.riwagis.riwajump.model.search.ListInputModel;
import de.riwagis.riwajump.model.search.SearchInputModel;
import de.riwagis.riwajump.model.search.WildcardSearchEnum;
import de.riwagis.util.gui.GUISupport;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.geotools.data.DataStore;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchInputDialog
extends JDialog {
    private static final Logger LOG = LoggerFactory.getLogger(SearchInputDialog.class);
    private final String strKey = I18N.get("de.riwagis.riwajump.SearchInputDialog.key");
    private final String strValue = I18N.get("de.riwagis.riwajump.SearchInputDialog.value");
    private SearchInputModel si = null;
    private String[] arrAtts = new String[0];
    private DMDCollection dmdCol = null;
    private String strDatastore = "";
    private boolean blockEvents = false;
    private boolean bolOKpressed = false;
    private final List<JComboBox<String>> lstCmbAtt = new ArrayList<JComboBox<String>>();
    private final List<JComboBox<String>> lstCmbListAtt = new ArrayList<JComboBox<String>>();
    private DatatypeListDialog dlgDatatype = null;
    private SimpleFeatureType fType = null;
    private JButton butCancel;
    private JButton butList;
    private JButton butOK;
    private JComboBox<String> cmbLink;
    private JComboBox<String> cmbType;
    private JComboBox<String> cmbValue;
    private JComboBox<String> cmbWildcard;
    private JPanel jPanel1;
    private JLabel lblLink;
    private JLabel lblList;
    private JLabel lblListValue;
    private JLabel lblName;
    private JLabel lblType;
    private JLabel lblValue;
    private JLabel lblWildcard;
    private JTextField txtList;
    private JTextField txtListValue;
    private JTextField txtName;

    public SearchInputDialog(Frame parent) {
        super(parent, true);
        this.init();
    }

    public SearchInputDialog(Dialog parent) {
        super(parent, true);
        this.init();
    }

    private void init() {
        this.initComponents();
        this.i18n();
        this.setSize(400, 280);
        this.blockEvents = true;
        try {
            this.lstCmbAtt.add(this.cmbValue);
            this.lstCmbListAtt.add(this.cmbLink);
            this.cmbType.addItem(I18N.get("de.riwagis.riwajump.SearchInputDialog.field-type"));
            this.cmbType.addItem(I18N.get("de.riwagis.riwajump.SearchInputDialog.list-type"));
            this.cmbWildcard.addItem(I18N.get("de.riwagis.riwajump.SearchInputDialog.wildcard-type-none"));
            this.cmbWildcard.addItem(I18N.get("de.riwagis.riwajump.SearchInputDialog.wildcard-type-trailing"));
            this.cmbWildcard.addItem(I18N.get("de.riwagis.riwajump.SearchInputDialog.wildcard-type-leading"));
            this.cmbWildcard.addItem(I18N.get("de.riwagis.riwajump.SearchInputDialog.wildcard-type-trailing-and-leading"));
            this.cmbWildcard.setToolTipText(I18N.get("de.riwagis.riwajump.SearchInputDialog.wildcard-tooltip"));
            this.lblWildcard.setToolTipText(I18N.get("de.riwagis.riwajump.SearchInputDialog.wildcard-tooltip"));
        }
        finally {
            this.blockEvents = false;
        }
    }

    private void i18n() {
        this.setTitle(I18N.get("de.riwagis.riwajump.SearchInputDialog.title"));
        this.lblType.setText(I18N.get("de.riwagis.riwajump.SearchInputDialog.type"));
        this.lblName.setText(I18N.get("de.riwagis.riwajump.SearchInputDialog.name"));
        this.lblValue.setText(I18N.get("de.riwagis.riwajump.SearchInputDialog.value"));
        this.lblList.setText(I18N.get("de.riwagis.riwajump.SearchInputDialog.list"));
        this.lblLink.setText(I18N.get("de.riwagis.riwajump.SearchInputDialog.link"));
        this.lblListValue.setText(I18N.get("de.riwagis.riwajump.SearchInputDialog.list-value"));
        this.lblName.setText(I18N.get("de.riwagis.riwajump.SearchInputDialog.name"));
        this.butCancel.setText(I18N.get("common.cancel"));
        this.butOK.setText(I18N.get("common.ok"));
    }

    public boolean wasOkPressed() {
        return this.bolOKpressed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSearchInput(SearchInputModel _si, String[] _arrAtts, DMDCollection _dmdCol, String _strDatastore) {
        this.bolOKpressed = false;
        this.si = _si;
        this.arrAtts = _arrAtts;
        this.dmdCol = _dmdCol;
        this.strDatastore = _strDatastore;
        this.fType = null;
        this.blockEvents = true;
        try {
            this.txtName.setText(this.si.getName());
            if (this.si instanceof FieldInputModel) {
                this.cmbType.setSelectedIndex(0);
                this.txtList.setEnabled(false);
                this.butList.setEnabled(false);
                this.lblList.setEnabled(false);
                this.lblLink.setEnabled(false);
                this.cmbLink.setEnabled(false);
                this.txtListValue.setEnabled(false);
                this.lblListValue.setEnabled(false);
                this.cmbWildcard.setEnabled(true);
                this.lblValue.setText(this.strValue);
            } else {
                this.cmbType.setSelectedIndex(1);
                this.txtList.setEnabled(true);
                this.butList.setEnabled(true);
                this.lblList.setEnabled(true);
                this.lblLink.setEnabled(true);
                this.cmbLink.setEnabled(true);
                this.txtListValue.setEnabled(true);
                this.lblListValue.setEnabled(true);
                this.cmbWildcard.setEnabled(false);
                ListInputModel li = (ListInputModel)this.si;
                this.txtList.setText(li.getDatatypeName());
                this.lblValue.setText(this.strKey);
            }
            this.addAttributes();
        }
        finally {
            this.blockEvents = false;
            this.validateListValueExpression();
        }
    }

    public SearchInputModel getSearchInput() {
        this.si.setAttribute(this.cmbValue.getSelectedItem().toString());
        SearchInputModel searchInputModel = this.si;
        if (searchInputModel instanceof ListInputModel) {
            ListInputModel li = (ListInputModel)searchInputModel;
            li.setKeyAttribute(this.cmbLink.getSelectedItem().toString());
            li.setValueAttribute(this.txtListValue.getText());
        }
        return this.si;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAttributes() {
        block12: {
            boolean blockEventsTmp = this.blockEvents;
            this.blockEvents = true;
            try {
                ListInputModel li;
                SearchInputModel searchInputModel;
                Arrays.sort(this.arrAtts, String.CASE_INSENSITIVE_ORDER);
                for (JComboBox<String> jComboBox : this.lstCmbAtt) {
                    jComboBox.removeAllItems();
                    for (String currAtt : this.arrAtts) {
                        jComboBox.addItem(currAtt);
                    }
                }
                this.cmbValue.setSelectedItem(this.si.getAttribute());
                SearchInputModel searchInputModel2 = this.si;
                if (searchInputModel2 instanceof FieldInputModel) {
                    FieldInputModel fi = (FieldInputModel)searchInputModel2;
                    this.setCmbWildcard(fi.getWildcard());
                }
                if (!((searchInputModel = this.si) instanceof ListInputModel) || (li = (ListInputModel)searchInputModel).getDatatypeName().length() <= 0) break block12;
                try {
                    DatastoreMetadata datastoreMetadata = this.dmdCol.getByName(this.strDatastore);
                    DataStore store = datastoreMetadata.getDataStore();
                    SimpleFeatureType simpleFeatureType = store.getSchema(li.getDatatypeName());
                    for (JComboBox<String> cmb3 : this.lstCmbListAtt) {
                        cmb3.removeAllItems();
                        cmb3.addItem("_PrimaryKey");
                        for (AttributeDescriptor currAttributeDescriptor : simpleFeatureType.getAttributeDescriptors()) {
                            cmb3.addItem(currAttributeDescriptor.getLocalName());
                        }
                    }
                }
                catch (Exception exception) {
                    LOG.warn(String.format("unable to add featuretypes from datastore: %s", exception.getMessage()), (Throwable)exception);
                    for (JComboBox jComboBox : this.lstCmbListAtt) {
                        jComboBox.removeAllItems();
                        jComboBox.addItem("_PrimaryKey");
                        if (li.getKeyAttribute() != null && li.getKeyAttribute().length() > 0) {
                            jComboBox.addItem(li.getKeyAttribute());
                        }
                        if (li.getValueAttribute() == null || li.getValueAttribute().length() <= 0) continue;
                        jComboBox.addItem(li.getValueAttribute());
                    }
                }
                this.cmbLink.setSelectedItem(li.getKeyAttribute());
                this.txtListValue.setText(li.getValueAttribute());
            }
            finally {
                this.blockEvents = blockEventsTmp;
            }
        }
    }

    private void setCmbWildcard(String strWildcard) {
        switch (WildcardSearchEnum.byValue((String)strWildcard)) {
            case NO_WILDCARD: {
                this.cmbWildcard.setSelectedIndex(0);
                break;
            }
            case WILDCARD_LEADING: {
                this.cmbWildcard.setSelectedIndex(2);
                break;
            }
            case WILDCARD_LEADING_AND_TRAILING: {
                this.cmbWildcard.setSelectedIndex(3);
                break;
            }
            default: {
                this.cmbWildcard.setSelectedIndex(1);
            }
        }
    }

    private WildcardSearchEnum getWildcardBySelectedIndex() {
        switch (this.cmbWildcard.getSelectedIndex()) {
            case 0: {
                return WildcardSearchEnum.NO_WILDCARD;
            }
            case 2: {
                return WildcardSearchEnum.WILDCARD_LEADING;
            }
            case 3: {
                return WildcardSearchEnum.WILDCARD_LEADING_AND_TRAILING;
            }
        }
        return WildcardSearchEnum.WILDCARD_TRAILING;
    }

    private SimpleFeatureType retrieveFeatureType() throws IOException {
        if (this.fType == null) {
            DatastoreMetadata dmd = this.dmdCol.getByName(this.strDatastore);
            DataStore store = dmd.getDataStore();
            this.fType = store.getSchema(this.txtList.getText());
        }
        return this.fType;
    }

    private boolean validateListValueExpression() {
        try {
            if (FeatBshValidator.validateTextExpression((String)this.txtListValue.getText(), (SimpleFeatureType)this.retrieveFeatureType()) == null) {
                this.txtListValue.setForeground(Color.GREEN.darker());
                return true;
            }
            this.txtListValue.setForeground(Color.RED.darker());
        }
        catch (Exception e) {
            this.txtListValue.setForeground(Color.RED.darker());
        }
        return false;
    }

    private void initComponents() {
        this.lblType = new JLabel();
        this.cmbType = new JComboBox();
        this.lblName = new JLabel();
        this.txtName = new JTextField();
        this.lblValue = new JLabel();
        this.cmbValue = new JComboBox();
        this.lblWildcard = new JLabel();
        this.cmbWildcard = new JComboBox();
        this.lblList = new JLabel();
        this.txtList = new JTextField();
        this.butList = new JButton();
        this.lblLink = new JLabel();
        this.txtListValue = new JTextField();
        this.lblListValue = new JLabel();
        this.cmbLink = new JComboBox();
        this.jPanel1 = new JPanel();
        this.butOK = new JButton();
        this.butCancel = new JButton();
        this.setDefaultCloseOperation(0);
        this.setMinimumSize(new Dimension(250, 300));
        this.setPreferredSize(new Dimension(300, 300));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent evt) {
                SearchInputDialog.this.this_onWindowActivated(evt);
            }

            @Override
            public void windowClosing(WindowEvent evt) {
                SearchInputDialog.this.formWindowClosing(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.lblType.setHorizontalAlignment(11);
        this.lblType.setText("Typ:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(10, 3, 3, 3);
        this.getContentPane().add((Component)this.lblType, gridBagConstraints);
        this.cmbType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchInputDialog.this.cmbType_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(9, 3, 3, 3);
        this.getContentPane().add(this.cmbType, gridBagConstraints);
        this.lblName.setHorizontalAlignment(11);
        this.lblName.setText("Name:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(10, 3, 3, 3);
        this.getContentPane().add((Component)this.lblName, gridBagConstraints);
        this.txtName.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                SearchInputDialog.this.txtName_onKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(9, 3, 3, 3);
        this.getContentPane().add((Component)this.txtName, gridBagConstraints);
        this.lblValue.setHorizontalAlignment(11);
        this.lblValue.setText("Wert:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(4, 3, 3, 3);
        this.getContentPane().add((Component)this.lblValue, gridBagConstraints);
        this.cmbValue.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchInputDialog.this.cmbValue_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add(this.cmbValue, gridBagConstraints);
        this.lblWildcard.setHorizontalAlignment(11);
        this.lblWildcard.setText("Platzhalter:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(4, 3, 3, 3);
        this.getContentPane().add((Component)this.lblWildcard, gridBagConstraints);
        this.cmbWildcard.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchInputDialog.this.cmbWildcard_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add(this.cmbWildcard, gridBagConstraints);
        this.lblList.setHorizontalAlignment(11);
        this.lblList.setText("Liste:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(11, 3, 3, 3);
        this.getContentPane().add((Component)this.lblList, gridBagConstraints);
        this.txtList.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                SearchInputDialog.this.txtList_onFocusLost(evt);
            }
        });
        this.txtList.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                SearchInputDialog.this.txtList_onKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 3, 3, 3);
        this.getContentPane().add((Component)this.txtList, gridBagConstraints);
        this.butList.setText("...");
        this.butList.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchInputDialog.this.butList_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 3, 3, 3);
        this.getContentPane().add((Component)this.butList, gridBagConstraints);
        this.lblLink.setHorizontalAlignment(11);
        this.lblLink.setText("Verkn\u00fcpfung:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(4, 3, 3, 3);
        this.getContentPane().add((Component)this.lblLink, gridBagConstraints);
        this.txtListValue.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                SearchInputDialog.this.txtListValueKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.txtListValue, gridBagConstraints);
        this.lblListValue.setHorizontalAlignment(11);
        this.lblListValue.setText("Wert:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(4, 3, 3, 3);
        this.getContentPane().add((Component)this.lblListValue, gridBagConstraints);
        this.cmbLink.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchInputDialog.this.cmbLink_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add(this.cmbLink, gridBagConstraints);
        this.butOK.setText("OK");
        this.butOK.setPreferredSize(new Dimension(110, 23));
        this.butOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchInputDialog.this.butOK_onActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.butOK);
        this.butCancel.setText("abbrechen");
        this.butCancel.setPreferredSize(new Dimension(110, 23));
        this.butCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchInputDialog.this.butCancel_onActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.butCancel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.pack();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void butList_onActionPerformed(ActionEvent evt) {
        try {
            ListInputModel li = (ListInputModel)this.si;
            DatastoreMetadata dmd = this.dmdCol.getByName(this.strDatastore);
            DataStore store = dmd.getDataStore();
            if (this.dlgDatatype == null) {
                this.dlgDatatype = DatatypeListDialog.createCenteredToWindow(this);
            }
            this.dlgDatatype.setTypeNames(store.getTypeNames());
            if (li.getDatatypeName() != null) {
                this.dlgDatatype.setDatatype(li.getDatatypeName());
            }
            this.dlgDatatype.setVisible(true);
            if (this.dlgDatatype.wasOKPressed()) {
                li.setDatatypeName(this.dlgDatatype.getDatatype());
                this.txtList.setText(this.dlgDatatype.getDatatype());
            }
            this.addAttributes();
        }
        catch (Exception e) {
            LOG.error(I18N.get("common.error") + ": " + e.getMessage(), (Throwable)e);
            JOptionPane.showMessageDialog(this, I18N.get("common.error") + ": " + e.getMessage());
        }
        finally {
            this.fType = null;
            this.validateListValueExpression();
        }
    }

    private void this_onWindowActivated(WindowEvent evt) {
        this.bolOKpressed = false;
    }

    private void butCancel_onActionPerformed(ActionEvent evt) {
        this.bolOKpressed = false;
        this.setVisible(false);
    }

    private void butOK_onActionPerformed(ActionEvent evt) {
        ListInputModel li;
        this.bolOKpressed = true;
        if (this.si.getName() == null || this.si.getName().trim().length() == 0) {
            GUISupport.msgbox((Component)this, (String)I18N.get("de.riwagis.riwajump.SearchInputDialog.no-name"), (String)I18N.get("common.error"));
            return;
        }
        if (this.cmbType.getSelectedIndex() == 1 && !this.validateListValueExpression()) {
            GUISupport.msgbox((Component)this, (String)I18N.get("de.riwagis.riwajump.SearchInputDialog.wrong-value-statement"), (String)I18N.get("common.error"));
            return;
        }
        if (this.si instanceof ListInputModel && ((li = (ListInputModel)this.si).getDatatypeName() == null || li.getDatatypeName().trim().length() == 0)) {
            GUISupport.msgbox((Component)this, (String)I18N.get("de.riwagis.riwajump.SearchInputDialog.no-datatypename"), (String)I18N.get("common.error"));
            return;
        }
        this.setVisible(false);
    }

    private void cmbType_onActionPerformed(ActionEvent evt) {
        if (this.blockEvents) {
            return;
        }
        if (this.cmbType.getSelectedIndex() == 0) {
            FieldInputModel fi = new FieldInputModel();
            fi.setName(this.si.getName());
            fi.setAttribute(this.si.getAttribute());
            this.setSearchInput((SearchInputModel)fi, this.arrAtts, this.dmdCol, this.strDatastore);
        } else {
            ListInputModel li = new ListInputModel();
            li.setName(this.si.getName());
            li.setAttribute(this.si.getAttribute());
            this.setSearchInput((SearchInputModel)li, this.arrAtts, this.dmdCol, this.strDatastore);
        }
    }

    private void cmbLink_onActionPerformed(ActionEvent evt) {
        if (this.blockEvents) {
            return;
        }
        ListInputModel li = (ListInputModel)this.si;
        li.setKeyAttribute(this.cmbLink.getSelectedItem().toString());
    }

    private void txtList_onFocusLost(FocusEvent evt) {
        if (this.blockEvents) {
            return;
        }
        this.addAttributes();
    }

    private void txtList_onKeyReleased(KeyEvent evt) {
        if (this.blockEvents) {
            return;
        }
        try {
            ListInputModel li = (ListInputModel)this.si;
            li.setDatatypeName(this.txtList.getText());
        }
        finally {
            this.fType = null;
            this.validateListValueExpression();
        }
    }

    private void cmbValue_onActionPerformed(ActionEvent evt) {
        if (this.blockEvents) {
            return;
        }
        this.si.setAttribute(this.cmbValue.getSelectedItem().toString());
    }

    private void txtName_onKeyReleased(KeyEvent evt) {
        if (this.blockEvents) {
            return;
        }
        this.si.setName(this.txtName.getText());
    }

    private void txtListValueKeyReleased(KeyEvent evt) {
        if (this.blockEvents) {
            return;
        }
        this.validateListValueExpression();
        ListInputModel li = (ListInputModel)this.si;
        li.setValueAttribute(this.txtListValue.getText());
    }

    private void cmbWildcard_onActionPerformed(ActionEvent evt) {
        if (this.blockEvents) {
            return;
        }
        ((FieldInputModel)this.si).setWildcard(this.getWildcardBySelectedIndex().getValue());
    }

    private void formWindowClosing(WindowEvent evt) {
        this.bolOKpressed = false;
        this.setVisible(false);
    }
}

