/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.search.gui;

import de.riwagis.riwajump.data.model.DMDCollection;
import de.riwagis.riwajump.model.search.RootSearchModel;
import de.riwagis.riwajump.search.intelligence.RootSearchIntelligence;
import de.riwagis.riwajump.search.intelligence.SearchValue;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RootSearchTreeModel
implements TreeModel {
    private static final Logger LOG = LoggerFactory.getLogger(RootSearchTreeModel.class);
    private final Component comp;
    private final DMDCollection dmdCol;
    private final RootSearchModel searchRoot;
    private final List<TreeModelListener> treeModelListeners = new ArrayList<TreeModelListener>();

    public RootSearchTreeModel(RootSearchModel _searchRoot, DMDCollection _dmdCol, Component _comp) {
        this.comp = _comp;
        this.searchRoot = _searchRoot;
        this.dmdCol = _dmdCol;
    }

    public void fireTreeStructureChanged(RootSearchModel oldRoot) {
        TreeModelEvent e = new TreeModelEvent((Object)this, new Object[]{oldRoot});
        for (TreeModelListener tml : this.treeModelListeners) {
            tml.treeStructureChanged(e);
        }
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.treeModelListeners.add(l);
    }

    @Override
    public Object getChild(Object parent, int index) {
        if (parent instanceof RootSearchModel) {
            return ((RootSearchIntelligence)this.searchRoot.createAndGetIntelligence(null)).executeSearch(this.dmdCol, this.comp, null)[index];
        }
        SearchValue sv = (SearchValue)((Object)parent);
        return sv.getSubSearchValues(this.dmdCol, this.comp)[index];
    }

    @Override
    public int getChildCount(Object parent) {
        if (parent instanceof RootSearchModel) {
            return ((RootSearchIntelligence)this.searchRoot.createAndGetIntelligence(null)).executeSearch(this.dmdCol, this.comp, null).length;
        }
        SearchValue sv = (SearchValue)((Object)parent);
        return sv.getSubSearchValues(this.dmdCol, this.comp).length;
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        SearchValue[] arrSV;
        if (parent instanceof RootSearchModel) {
            arrSV = ((RootSearchIntelligence)this.searchRoot.createAndGetIntelligence(null)).executeSearch(this.dmdCol, this.comp, null);
        } else {
            SearchValue sv = (SearchValue)((Object)parent);
            arrSV = sv.getSubSearchValues(this.dmdCol, this.comp);
        }
        for (int i = 0; i < arrSV.length; ++i) {
            if (!arrSV[i].equals(child)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Object getRoot() {
        return this.searchRoot;
    }

    @Override
    public boolean isLeaf(Object node) {
        if (node instanceof RootSearchModel) {
            return false;
        }
        SearchValue sv = (SearchValue)((Object)node);
        return !sv.hasSubSearch();
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.treeModelListeners.remove(l);
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        LOG.debug("*** valueForPathChanged : " + String.valueOf(path) + " --> " + String.valueOf(newValue));
    }
}

