/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.search.gui;

import de.riwagis.riwajump.data.model.DatastoreMetadata;
import de.riwagis.riwajump.model.search.FieldInputModel;
import de.riwagis.riwajump.model.search.SearchInputModel;
import de.riwagis.riwajump.search.gui.MapContextSearchPanel;
import de.riwagis.riwajump.search.intelligence.ListInputIntelligence;
import de.riwagis.util.gui.GUISupport;
import de.riwagis.util.gui.models.KeyValue;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;
import javax.swing.text.JTextComponent;

public class RootSearchTableEditor
extends AbstractCellEditor
implements TableCellEditor {
    private JComboBox cmbEdit = new JComboBox();
    private JTextField txtEdit = new JTextField();
    private final DefaultCellEditor cmbCellEdit = new DefaultCellEditor(this.cmbEdit);
    private final DefaultCellEditor txtCellEdit = new DefaultCellEditor(this.txtEdit);
    private JTable currentTable = null;
    private DefaultCellEditor currentCellEdit = this.txtCellEdit;
    private DatastoreMetadata dmd = null;

    public RootSearchTableEditor(DatastoreMetadata _dmd, final MapContextSearchPanel searchPanel) {
        this.dmd = _dmd;
        this.txtEdit.setBorder(null);
        this.txtEdit.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyChar() == '\n') {
                    RootSearchTableEditor.this.stopCellEditing();
                    searchPanel.search();
                }
                if (!e.isControlDown() && !e.isActionKey() && e.getKeyCode() != 17 && e.getKeyCode() != 16 && e.getKeyCode() != 127 && e.getKeyCode() != 8) {
                    int intPos = RootSearchTableEditor.this.txtEdit.getCaretPosition();
                    RootSearchTableEditor.this.txtEdit.select(intPos, intPos);
                }
            }
        });
        GUISupport.addCopyInsertPopup((JTextComponent)this.txtEdit);
        this.cmbEdit.setBorder(null);
        this.cmbEdit.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyChar() == '\n' && !RootSearchTableEditor.this.cmbEdit.isPopupVisible()) {
                    RootSearchTableEditor.this.stopCellEditing();
                    searchPanel.search();
                }
            }
        });
        this.cmbEdit.addActionListener(new ActionListener(this){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
    }

    public void requestFocus() {
        if (this.currentCellEdit == this.cmbCellEdit) {
            this.cmbEdit.requestFocusInWindow();
        } else {
            this.txtEdit.requestFocusInWindow();
        }
    }

    @Override
    public Object getCellEditorValue() {
        return this.currentCellEdit.getCellEditorValue();
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.currentTable = table;
        SearchInputModel si = (SearchInputModel)table.getModel().getValueAt(row, 0);
        if (si instanceof FieldInputModel) {
            this.currentCellEdit = this.txtCellEdit;
            return this.txtCellEdit.getTableCellEditorComponent(table, value, isSelected, row, column);
        }
        try {
            ListInputIntelligence li = (ListInputIntelligence)si.createAndGetIntelligence(null);
            this.currentCellEdit = this.cmbCellEdit;
            KeyValue[] arrList = li.getList(this.dmd);
            this.cmbEdit.removeAllItems();
            this.cmbEdit.addItem(new KeyValue((Object)"", (Object)""));
            for (KeyValue arrList1 : arrList) {
                this.cmbEdit.addItem(arrList1);
            }
            return this.cmbCellEdit.getTableCellEditorComponent(table, value, isSelected, row, column);
        }
        catch (Exception e) {
            GUISupport.msgbox(null, (String)"Error on reading list input", (String)"error");
            this.currentCellEdit = this.txtCellEdit;
            return this.txtCellEdit.getTableCellEditorComponent(table, value, isSelected, row, column);
        }
    }
}

