/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.search.gui;

import com.vividsolutions.jump.I18N;
import de.riwagis.riwajump.data.model.DMDCollection;
import de.riwagis.riwajump.data.model.DatastoreMetadata;
import de.riwagis.riwajump.model.search.FieldInputModel;
import de.riwagis.riwajump.model.search.RootSearchModel;
import de.riwagis.riwajump.model.search.SearchInputModel;
import de.riwagis.riwajump.model.search.SearchModel;
import de.riwagis.riwajump.model.search.SubSearchModel;
import de.riwagis.riwajump.search.gui.ListEditor;
import de.riwagis.riwajump.search.gui.SearchBshDialog;
import de.riwagis.riwajump.search.gui.SearchInputDialog;
import de.riwagis.riwajump.search.gui.SearchListPanel;
import de.riwagis.riwajump.search.gui.SearchPanel;
import de.riwagis.riwajump.search.gui.SubSearchDialog;
import de.riwagis.util.gui.GUISupport;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;

public class RootSearchPanel
extends JPanel {
    private RootSearchModel searchRoot = null;
    private DMDCollection dmdCol = new DMDCollection();
    private boolean bolBlockEvents = false;
    private final NumberFormat nf = NumberFormat.getIntegerInstance();
    private String strBshSearchTable = "";
    private JButton butPrg;
    private JComboBox<DatastoreMetadata> cmbDatastore;
    private JLabel lblDatastore;
    private JLabel lblScale;
    private SearchListPanel<SearchInputModel> lstFields;
    private SearchListPanel<String> lstLayer;
    private SearchListPanel<SearchModel> lstSubSearch;
    private SearchPanel rootSearchPanel;
    private JFormattedTextField txtScale;

    public RootSearchPanel() {
        this.initComponents();
        this.i18n();
        this.init();
    }

    private void i18n() {
        this.lblDatastore.setText(I18N.get("de.riwagis.riwajump.RootSearchPanel.datastore"));
        ((TitledBorder)this.lstFields.getBorder()).setTitle(I18N.get("de.riwagis.riwajump.RootSearchPanel.search-fields"));
        ((TitledBorder)this.lstSubSearch.getBorder()).setTitle(I18N.get("de.riwagis.riwajump.RootSearchPanel.subsearch"));
        ((TitledBorder)this.lstLayer.getBorder()).setTitle(I18N.get("de.riwagis.riwajump.RootSearchPanel.layer-ids"));
        this.lblScale.setText(I18N.get("de.riwagis.riwajump.RootSearchPanel.min-scale"));
        this.butPrg.setText(I18N.get("de.riwagis.riwajump.RootSearchPanel.programming"));
    }

    private void init() {
        this.lstSubSearch.setListEditor(new SubSearchEditor());
        this.lstFields.setListEditor(new SearchInputEditor());
        this.lstLayer.setListEditor(new LayerIDEditor());
        this.nf.setGroupingUsed(false);
        NumberFormatter nff = new NumberFormatter(this.nf);
        this.txtScale.setFormatterFactory(new DefaultFormatterFactory(nff));
    }

    public String isInputValid() {
        if (this.rootSearchPanel.isInputValid() != null) {
            return this.rootSearchPanel.isInputValid();
        }
        if (this.lstFields.getData().isEmpty()) {
            return I18N.get("de.riwagis.riwajump.RootSearchPanel.no-fields");
        }
        return null;
    }

    public void setRootSearch(RootSearchModel _searchRoot, DMDCollection _dmdCol) {
        this.dmdCol = _dmdCol;
        this.searchRoot = _searchRoot;
        if (this.searchRoot.getDatastore() == null || this.searchRoot.getDatastore().trim().length() == 0) {
            DatastoreMetadata dmd = this.dmdCol.getInternalList().get(0);
            this.searchRoot.setDatastore(dmd.getName());
        }
        ArrayList lstFieldsObj = new ArrayList(this.searchRoot.getInput());
        ArrayList lstSubSearchObj = new ArrayList(this.searchRoot.getSubSearches());
        ArrayList lstLayerObj = new ArrayList(this.searchRoot.getLayers());
        this.lstFields.setData(lstFieldsObj);
        this.lstSubSearch.setData(lstSubSearchObj);
        this.lstLayer.setData(lstLayerObj);
        this.strBshSearchTable = this.searchRoot.getBshSearchTable();
        this.updateComponents();
    }

    public RootSearchModel getRootSearch() {
        DatastoreMetadata dmd = (DatastoreMetadata)this.cmbDatastore.getSelectedItem();
        this.searchRoot.setDatastore(dmd.getName());
        this.searchRoot.setInput(this.lstFields.getData());
        this.searchRoot.setSubSearches(this.lstSubSearch.getData());
        this.searchRoot.setLayers(this.lstLayer.getData());
        this.searchRoot.setBshSearchTable(this.strBshSearchTable);
        return this.searchRoot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateComponents() {
        this.bolBlockEvents = true;
        try {
            this.cmbDatastore.removeAllItems();
            Iterator<DatastoreMetadata> iDS = this.dmdCol.iterator();
            DatastoreMetadata dmdSel = null;
            while (iDS.hasNext()) {
                DatastoreMetadata dmd = iDS.next();
                if (dmd.getName().equals(this.searchRoot.getDatastore())) {
                    dmdSel = dmd;
                }
                this.cmbDatastore.addItem(dmd);
            }
            if (dmdSel != null) {
                this.cmbDatastore.setSelectedItem(dmdSel);
            }
            this.rootSearchPanel.setSearch((SearchModel)this.searchRoot, this.dmdCol);
            this.txtScale.setText("" + this.searchRoot.getScale());
        }
        finally {
            this.bolBlockEvents = false;
        }
    }

    private void initComponents() {
        this.rootSearchPanel = new SearchPanel();
        this.lstFields = new SearchListPanel();
        this.lstSubSearch = new SearchListPanel();
        this.lblDatastore = new JLabel();
        this.cmbDatastore = new JComboBox();
        this.lstLayer = new SearchListPanel();
        this.lblScale = new JLabel();
        this.txtScale = new JFormattedTextField();
        this.butPrg = new JButton();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 26, 3, 3);
        this.add((Component)this.rootSearchPanel, gridBagConstraints);
        this.lstFields.setBorder(BorderFactory.createTitledBorder("Suchfelder"));
        this.lstFields.setPreferredSize(new Dimension(383, 90));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add(this.lstFields, gridBagConstraints);
        this.lstSubSearch.setBorder(BorderFactory.createTitledBorder("abh\u00e4ngige Suchen"));
        this.lstSubSearch.setPreferredSize(new Dimension(383, 90));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add(this.lstSubSearch, gridBagConstraints);
        this.lblDatastore.setFont(this.lblDatastore.getFont().deriveFont(this.lblDatastore.getFont().getStyle() | 1));
        this.lblDatastore.setText("Datenquelle:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(4, 3, 3, 3);
        this.add((Component)this.lblDatastore, gridBagConstraints);
        this.cmbDatastore.setFont(this.cmbDatastore.getFont().deriveFont(this.cmbDatastore.getFont().getStyle() | 1));
        this.cmbDatastore.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RootSearchPanel.this.cmbDatastore_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add(this.cmbDatastore, gridBagConstraints);
        this.lstLayer.setBorder(BorderFactory.createTitledBorder("Ebenen-IDs"));
        this.lstLayer.setPreferredSize(new Dimension(383, 90));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add(this.lstLayer, gridBagConstraints);
        this.lblScale.setText("min. Zoomma\u00dfstab:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(4, 3, 3, 3);
        this.add((Component)this.lblScale, gridBagConstraints);
        this.txtScale.setMinimumSize(new Dimension(50, 20));
        this.txtScale.setPreferredSize(new Dimension(50, 20));
        this.txtScale.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                RootSearchPanel.this.txtScale_onKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.txtScale, gridBagConstraints);
        this.butPrg.setText("Programmierung");
        this.butPrg.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RootSearchPanel.this.butPrg_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.butPrg, gridBagConstraints);
    }

    private void txtScale_onKeyReleased(KeyEvent evt) {
        if (this.bolBlockEvents) {
            return;
        }
        try {
            int intScale = this.nf.parse(this.txtScale.getText()).intValue();
            if (this.txtScale.getText().length() == 0 || intScale <= 0) {
                intScale = 500;
            }
            this.searchRoot.setScale(intScale);
        }
        catch (Exception e) {
            this.searchRoot.setScale(500);
        }
    }

    private void cmbDatastore_onActionPerformed(ActionEvent evt) {
        if (this.bolBlockEvents) {
            return;
        }
        DatastoreMetadata dmd = (DatastoreMetadata)this.cmbDatastore.getSelectedItem();
        this.searchRoot.setDatastore(dmd.getName());
    }

    private void butPrg_onActionPerformed(ActionEvent evt) {
        Window parent = SwingUtilities.windowForComponent(this);
        SearchBshDialog dlgBsh = parent instanceof Dialog ? new SearchBshDialog((Dialog)parent) : new SearchBshDialog((Frame)parent);
        dlgBsh.setBshSearchTable(this.strBshSearchTable);
        dlgBsh.setVisible(true);
        if (dlgBsh.wasOKPressed()) {
            this.strBshSearchTable = dlgBsh.getBshSearchTable();
        }
    }

    private class SubSearchEditor
    implements ListEditor<SearchModel> {
        private SubSearchDialog dlg = null;

        private SubSearchEditor() {
        }

        private SubSearchDialog getDialog() {
            if (this.dlg == null) {
                Window parent = SwingUtilities.windowForComponent(RootSearchPanel.this);
                if (parent instanceof Frame) {
                    this.dlg = new SubSearchDialog((Frame)parent);
                }
                if (parent instanceof Dialog) {
                    this.dlg = new SubSearchDialog((Dialog)parent);
                }
            }
            return this.dlg;
        }

        @Override
        public SearchModel editObject(SearchModel obj) {
            SubSearchDialog ssDlg = this.getDialog();
            if (ssDlg == null) {
                return null;
            }
            SubSearchModel search = (SubSearchModel)obj;
            ssDlg.setSearch(search, RootSearchPanel.this.dmdCol);
            GUISupport.centreOnScreen((Component)ssDlg);
            ssDlg.setVisible(true);
            if (ssDlg.wasOkPressed()) {
                SubSearchModel objSearchNew = ssDlg.getSearch();
                return objSearchNew;
            }
            return null;
        }

        @Override
        public SearchModel newObject() {
            SubSearchModel search = new SubSearchModel();
            search.setName("new");
            search.setRootSearchModel(RootSearchPanel.this.searchRoot);
            SubSearchDialog ssDlg = this.getDialog();
            if (ssDlg == null) {
                return null;
            }
            ssDlg.setSearch(search, RootSearchPanel.this.dmdCol);
            GUISupport.centreOnScreen((Component)ssDlg);
            ssDlg.setVisible(true);
            if (ssDlg.wasOkPressed()) {
                SubSearchModel objSearchNew = ssDlg.getSearch();
                return objSearchNew;
            }
            return null;
        }
    }

    private class SearchInputEditor
    implements ListEditor<SearchInputModel> {
        private SearchInputDialog dlg = null;

        private SearchInputEditor() {
        }

        private SearchInputDialog getDialog() {
            if (this.dlg == null) {
                Window parent = SwingUtilities.windowForComponent(RootSearchPanel.this);
                if (parent instanceof Frame) {
                    this.dlg = new SearchInputDialog((Frame)parent);
                }
                if (parent instanceof Dialog) {
                    this.dlg = new SearchInputDialog((Dialog)parent);
                }
            }
            return this.dlg;
        }

        @Override
        public SearchInputModel editObject(SearchInputModel obj) {
            try {
                if (RootSearchPanel.this.searchRoot.getAttributes() == null || RootSearchPanel.this.searchRoot.getAttributes().length == 0) {
                    GUISupport.msgbox((Component)RootSearchPanel.this, (String)I18N.get("de.riwagis.riwajump.SearchPanel.no-atts"), (String)I18N.get("common.error"));
                    return null;
                }
                SearchInputDialog siDlg = this.getDialog();
                if (siDlg == null) {
                    return null;
                }
                SearchInputModel si = obj.clone();
                siDlg.setSearchInput(si, RootSearchPanel.this.searchRoot.getAttributes(), RootSearchPanel.this.dmdCol, RootSearchPanel.this.searchRoot.getDatastore());
                GUISupport.centreOnScreen((Component)siDlg);
                siDlg.setVisible(true);
                if (siDlg.wasOkPressed()) {
                    SearchInputModel objSiNew = siDlg.getSearchInput();
                    return objSiNew;
                }
                return null;
            }
            catch (CloneNotSupportedException ex) {
                throw new RuntimeException("Should never reach here", ex);
            }
        }

        @Override
        public SearchInputModel newObject() {
            if (RootSearchPanel.this.searchRoot.getAttributes() == null || RootSearchPanel.this.searchRoot.getAttributes().length == 0) {
                GUISupport.msgbox((Component)RootSearchPanel.this, (String)I18N.get("de.riwagis.riwajump.SearchPanel.no-atts"), (String)I18N.get("common.error"));
                return null;
            }
            FieldInputModel fi = new FieldInputModel();
            fi.setName("new");
            SearchInputDialog siDlg = this.getDialog();
            if (siDlg == null) {
                return null;
            }
            siDlg.setSearchInput((SearchInputModel)fi, RootSearchPanel.this.searchRoot.getAttributes(), RootSearchPanel.this.dmdCol, RootSearchPanel.this.searchRoot.getDatastore());
            GUISupport.centreOnScreen((Component)siDlg);
            siDlg.setVisible(true);
            if (siDlg.wasOkPressed()) {
                SearchInputModel objSiNew = siDlg.getSearchInput();
                return objSiNew;
            }
            return null;
        }
    }

    private class LayerIDEditor
    implements ListEditor<String> {
        private LayerIDEditor() {
        }

        @Override
        public String editObject(String obj) {
            String strLayerID = obj;
            strLayerID = GUISupport.inputbox((Component)RootSearchPanel.this, (String)I18N.get("de.riwagis.riwajump.RootSearchPanel.insert-layer-id"), (String)strLayerID);
            if (strLayerID == null || strLayerID.trim().length() == 0) {
                return null;
            }
            return strLayerID;
        }

        @Override
        public String newObject() {
            String strLayerID = "";
            strLayerID = GUISupport.inputbox((Component)RootSearchPanel.this, (String)I18N.get("de.riwagis.riwajump.RootSearchPanel.insert-layer-id"), (String)strLayerID);
            if (strLayerID == null || strLayerID.trim().length() == 0) {
                return null;
            }
            return strLayerID;
        }
    }
}

