/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.search.gui;

import com.vividsolutions.jump.I18N;
import de.riwagis.guitools.GUIUtil;
import de.riwagis.guitools.Validator;
import de.riwagis.riwajump.data.model.DMDCollection;
import de.riwagis.riwajump.model.search.RootSearchModel;
import de.riwagis.riwajump.model.search.SearchCollectionModel;
import de.riwagis.riwajump.model.search.SearchModel;
import de.riwagis.riwajump.search.gui.RootSearchDialog;
import de.riwagis.util.gui.GUISupport;
import de.riwagis.util.gui.models.ListListModel;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;

public class RootSearchListPanel
extends JPanel {
    private DMDCollection dmdCol = new DMDCollection();
    private final ListListModel<SearchModel> listModel;
    private RootSearchDialog dlg = null;
    private String editName = "";
    private JButton butDelete;
    private JButton butEdit;
    private JButton butNew;
    private JScrollPane jScrollPane1;
    private JLabel lblSearch;
    private JList<SearchModel> lstSearch;
    private JPanel pnlBut;

    public RootSearchListPanel() {
        this.initComponents();
        this.i18n();
        this.listModel = new ListListModel(new ArrayList());
        this.lstSearch.setModel((ListModel<SearchModel>)this.listModel);
    }

    private void i18n() {
        this.lblSearch.setText(I18N.get("de.riwagis.riwajump.RootSearchListPanel.searches"));
        this.butNew.setText(I18N.get("common.new"));
        this.butEdit.setText(I18N.get("common.change"));
        this.butDelete.setText(I18N.get("common.delete"));
    }

    public void setSearchList(SearchCollectionModel _lstRootSearch, DMDCollection _dmdCol) {
        this.dmdCol = _dmdCol;
        _lstRootSearch.sortList();
        try {
            this.listModel.setList(_lstRootSearch.clone().getInternalList());
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Should never reach here", e);
        }
    }

    public SearchCollectionModel getSearchCollection() {
        SearchCollectionModel scModel = new SearchCollectionModel();
        scModel.getInternalList().addAll(this.listModel.getList());
        return scModel;
    }

    public RootSearchDialog getDialog(int _intMode, RootSearchModel _searchRoot, DMDCollection _dmdCol) {
        if (this.dlg == null) {
            Window parent = SwingUtilities.windowForComponent(this);
            if (parent instanceof Frame) {
                this.dlg = new RootSearchDialog((Frame)parent, _intMode, _searchRoot, _dmdCol);
            }
            if (parent instanceof Dialog) {
                this.dlg = new RootSearchDialog((Dialog)parent, _intMode, _searchRoot, _dmdCol);
            }
            Validator validator = new Validator(){

                @Override
                public String check(Object obj) {
                    try {
                        int count = 0;
                        RootSearchModel rsData = (RootSearchModel)obj;
                        for (RootSearchModel tmpData : RootSearchListPanel.this.listModel.getList()) {
                            if (!tmpData.getName().equals(rsData.getName())) continue;
                            ++count;
                        }
                        if (0 == RootSearchListPanel.this.dlg.getMode() && count > 0) {
                            return "\"" + rsData.getName() + "\". " + I18N.get("de.riwagis.riwajump.RootSearchListPanel.duplicate-name");
                        }
                        if (1 == RootSearchListPanel.this.dlg.getMode() && count > 0 && !RootSearchListPanel.this.editName.equals(rsData.getName())) {
                            return "\"" + rsData.getName() + "\". " + I18N.get("de.riwagis.riwajump.RootSearchListPanel.duplicate-name");
                        }
                        return null;
                    }
                    catch (Exception e) {
                        return I18N.get("common.error") + " in check: " + e.getMessage();
                    }
                }
            };
            this.dlg.addValidator(validator);
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            this.dlg.setLocation((screenSize.width - this.dlg.getWidth()) / 2, (screenSize.height - this.dlg.getHeight()) / 2);
            GUIUtil.centreOnScreen(this.dlg);
            return this.dlg;
        }
        this.dlg.setMode(_intMode);
        this.dlg.setRootSearch(_searchRoot, _dmdCol);
        return this.dlg;
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.lstSearch = new JList();
        this.lblSearch = new JLabel();
        this.pnlBut = new JPanel();
        this.butNew = new JButton();
        this.butEdit = new JButton();
        this.butDelete = new JButton();
        this.setLayout(new GridBagLayout());
        this.lstSearch.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                RootSearchListPanel.this.lstSearch_onMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.lstSearch);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 9, 9, 3);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.lblSearch.setText("Suchen:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(9, 9, 3, 9);
        this.add((Component)this.lblSearch, gridBagConstraints);
        this.pnlBut.setLayout(new GridLayout(3, 1, 3, 4));
        this.butNew.setText("neu");
        this.butNew.setMinimumSize(new Dimension(80, 23));
        this.butNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RootSearchListPanel.this.butNew_onActionPerformed(evt);
            }
        });
        this.pnlBut.add(this.butNew);
        this.butEdit.setText("\u00e4ndern");
        this.butEdit.setMinimumSize(new Dimension(80, 23));
        this.butEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RootSearchListPanel.this.butEdit_onActionPerformed(evt);
            }
        });
        this.pnlBut.add(this.butEdit);
        this.butDelete.setText("l\u00f6schen");
        this.butDelete.setMinimumSize(new Dimension(80, 23));
        this.butDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RootSearchListPanel.this.butDelete_onActionPerformed(evt);
            }
        });
        this.pnlBut.add(this.butDelete);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 9, 9);
        this.add((Component)this.pnlBut, gridBagConstraints);
    }

    private void lstSearch_onMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.butEdit_onActionPerformed(null);
        }
    }

    private void butDelete_onActionPerformed(ActionEvent evt) {
        List<SearchModel> arrRS = this.lstSearch.getSelectedValuesList();
        if (arrRS.isEmpty()) {
            return;
        }
        int option = JOptionPane.showConfirmDialog(this, I18N.get("de.riwagis.riwajump.RootSearchListPanel.delete-question"), I18N.get("common.message"), 0);
        if (option == 0) {
            for (SearchModel currSearch : arrRS) {
                this.listModel.removeListObject((Object)currSearch);
            }
        }
    }

    private void butEdit_onActionPerformed(ActionEvent evt) {
        if (this.lstSearch.getSelectedValuesList().size() != 1) {
            return;
        }
        if (this.dmdCol.getInternalList().isEmpty()) {
            GUISupport.msgbox((Component)this, (String)I18N.get("de.riwagis.riwajump.RootSearchListPanel.no-datastore"), (String)I18N.get("common.error"));
            return;
        }
        RootSearchModel oldRSearch = (RootSearchModel)this.lstSearch.getSelectedValue();
        RootSearchModel newRSearch = null;
        try {
            newRSearch = oldRSearch.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Should never reach here.", e);
        }
        this.editName = oldRSearch.getName();
        this.dlg = this.getDialog(1, newRSearch, this.dmdCol);
        this.dlg.setVisible(true);
        if (this.dlg.wasOKPressed()) {
            newRSearch = this.dlg.getRootSearchModel();
            this.listModel.replaceListObject((Object)oldRSearch, (Object)newRSearch);
            this.lstSearch.setSelectedValue(newRSearch, true);
        }
    }

    private void butNew_onActionPerformed(ActionEvent evt) {
        if (this.dmdCol.getInternalList().isEmpty()) {
            GUISupport.msgbox((Component)this, (String)I18N.get("de.riwagis.riwajump.RootSearchListPanel.no-datastore"), (String)I18N.get("common.error"));
            return;
        }
        RootSearchModel rSearch = new RootSearchModel();
        rSearch.setName("new");
        this.dlg = this.getDialog(0, rSearch, this.dmdCol);
        this.dlg.setVisible(true);
        if (this.dlg.wasOKPressed()) {
            rSearch = this.dlg.getRootSearchModel();
            this.listModel.addListObject((Object)rSearch);
            this.lstSearch.setSelectedValue(rSearch, true);
        }
    }
}

