/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.search.gui;

import com.vividsolutions.jump.I18N;
import de.riwagis.guitools.Validator;
import de.riwagis.riwajump.data.model.DMDCollection;
import de.riwagis.riwajump.model.search.RootSearchModel;
import de.riwagis.riwajump.search.gui.RootSearchPanel;
import de.riwagis.util.gui.GUISupport;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class RootSearchDialog
extends JDialog {
    private RootSearchModel searchRootOri = null;
    private RootSearchModel searchRoot = null;
    private DMDCollection dmdCol = new DMDCollection();
    private final List<Validator> lstValidator = new ArrayList<Validator>();
    public static final int MODE_ADD = 0;
    public static final int MODE_EDIT = 1;
    private int intMode = 0;
    private boolean bolOKPressed = false;
    private JButton butCancel;
    private JButton butOK;
    private JPanel jPanel1;
    private RootSearchPanel pnlRootSearch;

    public RootSearchDialog(Frame parent, int _intMode, RootSearchModel _searchRoot, DMDCollection _dmdCol) {
        super(parent, true);
        this.init(_intMode, _searchRoot, _dmdCol);
    }

    public RootSearchDialog(Dialog parent, int _intMode, RootSearchModel _searchRoot, DMDCollection _dmdCol) {
        super(parent, true);
        this.init(_intMode, _searchRoot, _dmdCol);
    }

    private void init(int _intMode, RootSearchModel _searchRoot, DMDCollection _dmdCol) {
        this.initComponents();
        this.setRootSearch(_searchRoot, _dmdCol);
        this.setMode(_intMode);
        this.i18n();
        this.setSize(450, 680);
    }

    private void i18n() {
        this.setTitle(I18N.get("de.riwagis.riwajump.RootSearchDialog.edit-title"));
        this.butCancel.setText(I18N.get("common.cancel"));
        this.butOK.setText(I18N.get("common.ok"));
    }

    public void setRootSearch(RootSearchModel _searchRoot, DMDCollection _dmdCol) {
        this.dmdCol = _dmdCol;
        this.searchRootOri = _searchRoot;
        try {
            this.searchRoot = _searchRoot.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Should never reach here.", e);
        }
        this.pnlRootSearch.setRootSearch(this.searchRoot, this.dmdCol);
    }

    public RootSearchModel getRootSearchModel() {
        return this.pnlRootSearch.getRootSearch();
    }

    public void addValidator(Validator val) {
        if (!this.lstValidator.contains(val)) {
            this.lstValidator.add(val);
        }
    }

    public void removeValidator(Validator val) {
        if (this.lstValidator.contains(val)) {
            this.lstValidator.remove(val);
        }
    }

    public void clearValidators() {
        this.lstValidator.clear();
    }

    public void setMode(int _intMode) {
        this.intMode = _intMode;
        if (this.intMode != 0 && this.intMode != 1) {
            this.intMode = 0;
        }
        if (this.intMode == 1) {
            this.setTitle(I18N.get("de.riwagis.riwajump.RootSearchDialog.edit-title"));
        } else {
            this.setTitle(I18N.get("de.riwagis.riwajump.RootSearchDialog.add-title"));
        }
    }

    public int getMode() {
        return this.intMode;
    }

    public boolean wasOKPressed() {
        return this.bolOKPressed;
    }

    private void initComponents() {
        this.pnlRootSearch = new RootSearchPanel();
        this.jPanel1 = new JPanel();
        this.butOK = new JButton();
        this.butCancel = new JButton();
        this.setDefaultCloseOperation(0);
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.getContentPane().add((Component)this.pnlRootSearch, gridBagConstraints);
        this.butOK.setText("OK");
        this.butOK.setPreferredSize(new Dimension(110, 23));
        this.butOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RootSearchDialog.this.butOK_onActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.butOK);
        this.butCancel.setText("abbrechen");
        this.butCancel.setPreferredSize(new Dimension(110, 23));
        this.butCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RootSearchDialog.this.butCancel_onActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.butCancel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.pack();
    }

    private void butOK_onActionPerformed(ActionEvent evt) {
        if (this.pnlRootSearch.isInputValid() != null) {
            GUISupport.msgbox((Component)this, (String)this.pnlRootSearch.isInputValid(), (String)I18N.get("common.error"));
            return;
        }
        for (Validator val : this.lstValidator) {
            String strError = val.check(this.searchRoot);
            if (strError == null) continue;
            JOptionPane.showMessageDialog(this, I18N.get("common.error") + ": " + strError);
            return;
        }
        this.bolOKPressed = true;
        this.setVisible(false);
    }

    private void butCancel_onActionPerformed(ActionEvent evt) {
        this.bolOKPressed = false;
        this.setVisible(false);
    }
}

