/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.search.gui;

import bsh.Interpreter;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import de.riwagis.gis.context.map.MapContext;
import de.riwagis.riwajump.data.model.DMDCollection;
import de.riwagis.riwajump.model.search.RootSearchModel;
import de.riwagis.riwajump.model.search.SearchCollectionModel;
import de.riwagis.riwajump.search.gui.RootSearchTableEditor;
import de.riwagis.riwajump.search.gui.RootSearchTableModel;
import de.riwagis.riwajump.search.gui.RootSearchTreeModel;
import de.riwagis.riwajump.search.intelligence.RootSearchIntelligence;
import de.riwagis.riwajump.search.intelligence.SearchValue;
import de.riwagis.util.gui.GUISupport;
import de.riwagis.util.gui.components.WaitDialog;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.tree.TreePath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapContextSearchPanel
extends JPanel {
    private static final Logger LOG = LoggerFactory.getLogger(MapContextSearchPanel.class);
    private static final int SPLIT_PANEL_DEFAULT_LOCATION = 320;
    static final String CONTEXT_SEARCH_DIV_LOCATION = "CONTEXT_SEARCH_DIV_LOCATION";
    private MapContext ctxMap = null;
    private SearchCollectionModel lstRootSearch = null;
    private DMDCollection dmdCol = null;
    private RootSearchModel currentSearch = null;
    private boolean blockEvents = false;
    private RootSearchTreeModel rtm = null;
    private JButton butNewSearch;
    private JButton butSearch;
    private JComboBox cmbSearch;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSplitPane jSplitPane1;
    private JLabel lblDesc;
    private JLabel lblSearch;
    private JPanel pnlResult;
    private JPanel pnlSearch;
    private JPanel pnlSearchType;
    private JTable tblSearchInput;
    private JTree treeResult;

    public MapContextSearchPanel() {
        this.initComponents();
        this.init();
        this.i18n();
    }

    private void init() {
        this.treeResult.getSelectionModel().setSelectionMode(1);
        ActionListener zoomAction = e -> this.zoom();
        this.treeResult.unregisterKeyboardAction(KeyStroke.getKeyStroke(10, 0));
        this.treeResult.registerKeyboardAction(zoomAction, KeyStroke.getKeyStroke(10, 0), 0);
        ActionListener searchAction = e -> this.butSearch_onActionPerformed(null);
        this.tblSearchInput.unregisterKeyboardAction(KeyStroke.getKeyStroke(10, 0));
        this.tblSearchInput.registerKeyboardAction(searchAction, KeyStroke.getKeyStroke(10, 0), 1);
        int dividerLocation = PersistentBlackboardPlugIn.get().get(CONTEXT_SEARCH_DIV_LOCATION, 320);
        this.jSplitPane1.setDividerLocation(dividerLocation);
    }

    private void i18n() {
        this.lblSearch.setText(I18N.get("de.riwagis.riwajump.MapContextSearchPanel.searches"));
        this.lblDesc.setText("");
        this.butNewSearch.setText(I18N.get("de.riwagis.riwajump.MapContextSearchPanel.new-search"));
        this.butSearch.setText(I18N.get("de.riwagis.riwajump.MapContextSearchPanel.search"));
        this.updateResultTitle(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSearches(MapContext _ctxMap, SearchCollectionModel _lstRootSearch, DMDCollection _dmdCol) {
        this.ctxMap = _ctxMap;
        this.dmdCol = _dmdCol;
        this.lstRootSearch = _lstRootSearch;
        this.blockEvents = true;
        try {
            int idx = this.cmbSearch.getSelectedIndex();
            this.cmbSearch.removeAllItems();
            for (RootSearchModel rSearch : this.lstRootSearch) {
                this.cmbSearch.addItem(rSearch);
            }
            if (this.lstRootSearch.getInternalList().size() > 0) {
                if (this.lstRootSearch.getInternalList().size() > idx && idx >= 0) {
                    this.setSearch((RootSearchModel)this.lstRootSearch.getInternalList().get(idx));
                } else {
                    this.setSearch((RootSearchModel)this.lstRootSearch.getInternalList().get(0));
                }
            }
        }
        finally {
            this.blockEvents = false;
        }
    }

    public SearchCollectionModel getActiveSearchCollection() {
        return this.lstRootSearch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSearch(RootSearchModel _currentSearch) {
        this.currentSearch = _currentSearch;
        boolean blockEventsTmp = this.blockEvents;
        this.blockEvents = false;
        try {
            this.cmbSearch.setSelectedItem(this.currentSearch);
            this.lblDesc.setText(this.currentSearch.getDescription());
            this.tblSearchInput.setModel(new RootSearchTableModel(this.currentSearch));
            this.tblSearchInput.getColumnModel().getColumn(1).setCellEditor(new RootSearchTableEditor(this.dmdCol.getByName(this.currentSearch.getDatastore()), this));
            TableColumn tblCol = this.tblSearchInput.getColumnModel().getColumn(0);
            DefaultTableCellRenderer colRenderer = new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    this.setText(value.toString());
                    this.setFont(this.getFont().deriveFont(1, 12.0f));
                    return this;
                }
            };
            tblCol.setCellRenderer(colRenderer);
            this.emptyCurrentSearch();
        }
        finally {
            this.blockEvents = blockEventsTmp;
        }
    }

    void zoom() {
        WaitDialog dlgWait = new WaitDialog((Window)((Dialog)SwingUtilities.windowForComponent(this)), I18N.get("de.riwagis.riwajump.MapContextSearchPanel.wait"));
        RootSearchModel finalSearch = this.currentSearch;
        Runnable run = () -> {
            if (this.treeResult.getSelectionCount() > 0) {
                SearchValue sv;
                TreePath selpath = this.treeResult.getSelectionPaths()[0];
                if (selpath == null) {
                    return;
                }
                Object selection = selpath.getLastPathComponent();
                if (selection instanceof SearchValue && !(sv = (SearchValue)((Object)((Object)selection))).hasSubSearch()) {
                    Object objKey = sv.getKey();
                    ((RootSearchIntelligence)finalSearch.createAndGetIntelligence(null)).zoomMap(this.dmdCol, this, this.ctxMap, objKey);
                }
            }
        };
        dlgWait.addWorkToDo(run);
        dlgWait.setVisible(true);
    }

    void search() {
        this.tblSearchInput.getColumnModel().getColumn(1).getCellEditor().stopCellEditing();
        Dialog dlgSearch = (Dialog)SwingUtilities.windowForComponent(this);
        WaitDialog dlgWait = new WaitDialog((Window)dlgSearch, I18N.get("de.riwagis.riwajump.MapContextSearchPanel.wait"));
        RootSearchModel finalSearch = this.currentSearch;
        Runnable run = () -> {
            try {
                ((RootSearchIntelligence)finalSearch.createAndGetIntelligence(null)).clearSearch();
                this.treeResult.setSelectionPath(new TreePath(new Object[]{finalSearch}));
                SearchValue[] arrSV = ((RootSearchIntelligence)finalSearch.createAndGetIntelligence(null)).executeRootSearch(this.dmdCol, this, null);
                if (arrSV.length == 0) {
                    GUISupport.msgbox((Component)dlgSearch, (String)I18N.get("de.riwagis.riwajump.MapContextSearchPanel.no-result"), (String)I18N.get("common.message"));
                    SwingUtilities.invokeLater(() -> this.butNewSearch.requestFocusInWindow());
                    return;
                }
                this.rtm.fireTreeStructureChanged(finalSearch);
                this.treeResult.setSelectionPath(new TreePath(new Object[]{this.currentSearch, arrSV[0]}));
                this.treeResult.requestFocusInWindow();
                if (arrSV.length == 1 && !arrSV[0].hasSubSearch()) {
                    this.zoom();
                }
                SwingUtilities.invokeLater(() -> this.updateResultTitle(arrSV.length));
            }
            catch (Exception e) {
                dlgWait.setError(e);
            }
        };
        dlgWait.addWorkToDo(run);
        dlgWait.setVisible(true);
        if (dlgWait.getError() != null) {
            Exception e = dlgWait.getError();
            LOG.error("Error at search", (Throwable)e);
            GUISupport.msgbox((Component)dlgSearch, (String)(I18N.get("common.error") + ": " + e.getMessage()), (String)I18N.get("common.error"));
        }
    }

    public void updateResultTitle(int hits) {
        String title = hits < 0 ? I18N.getMessage("de.riwagis.riwajump.MapContextSearchPanel.result", new Object[0]) : I18N.getMessage("de.riwagis.riwajump.MapContextSearchPanel.result-with-hits", hits);
        ((TitledBorder)this.pnlResult.getBorder()).setTitle(title);
        this.pnlResult.repaint();
    }

    private void emptyCurrentSearch() {
        this.tblSearchInput.getColumnModel().getColumn(1).getCellEditor().stopCellEditing();
        int intRows = this.tblSearchInput.getModel().getRowCount();
        for (int i = 0; i < intRows; ++i) {
            this.tblSearchInput.getModel().setValueAt(null, i, 1);
        }
        ((RootSearchIntelligence)this.currentSearch.createAndGetIntelligence(null)).emptySearch();
        ((RootSearchIntelligence)this.currentSearch.createAndGetIntelligence(null)).reloadLists(this.dmdCol, this);
        this.rtm = new RootSearchTreeModel(this.currentSearch, this.dmdCol, this);
        this.treeResult.setModel(this.rtm);
        if (intRows > 0) {
            this.selectRowInSearchInput(0);
        }
        this.updateResultTitle(-1);
    }

    int getDividerLocation() {
        if (this.jScrollPane1 == null) {
            return 320;
        }
        return this.jSplitPane1.getDividerLocation();
    }

    private void initComponents() {
        this.pnlSearchType = new JPanel();
        this.lblSearch = new JLabel();
        this.cmbSearch = new JComboBox();
        this.jSplitPane1 = new JSplitPane();
        this.pnlSearch = new JPanel();
        this.lblDesc = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.tblSearchInput = new JTable(){

            @Override
            public void changeSelection(int row, int column, boolean toggle, boolean extend) {
                super.changeSelection(row, column, toggle, extend);
                if (this.editCellAt(row, column)) {
                    Component editor = this.getEditorComponent();
                    editor.requestFocusInWindow();
                }
            }
        };
        this.jPanel1 = new JPanel();
        this.butNewSearch = new JButton();
        this.butSearch = new JButton();
        this.pnlResult = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.treeResult = new JTree();
        this.setLayout(new GridBagLayout());
        this.pnlSearchType.setMinimumSize(new Dimension(180, 28));
        this.pnlSearchType.setLayout(new GridBagLayout());
        this.lblSearch.setText("Suche:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlSearchType.add((Component)this.lblSearch, gridBagConstraints);
        this.cmbSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MapContextSearchPanel.this.cmbSearch_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlSearchType.add((Component)this.cmbSearch, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(8, 3, 3, 3);
        this.add((Component)this.pnlSearchType, gridBagConstraints);
        this.jSplitPane1.setDividerLocation(300);
        this.jSplitPane1.setOrientation(0);
        this.pnlSearch.setMinimumSize(new Dimension(180, 140));
        this.pnlSearch.setPreferredSize(new Dimension(460, 450));
        this.pnlSearch.setLayout(new GridBagLayout());
        this.lblDesc.setText("Beschreibung");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 3, 3, 3);
        this.pnlSearch.add((Component)this.lblDesc, gridBagConstraints);
        this.tblSearchInput.setModel(new DefaultTableModel(new Object[0][], new String[]{"Eigenschaft", "Wert"}){
            boolean[] canEdit;
            {
                this.canEdit = new boolean[]{false, true};
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.tblSearchInput.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                MapContextSearchPanel.this.tblSearchInput_onMouseClicked(evt);
            }
        });
        this.tblSearchInput.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                MapContextSearchPanel.this.tblSearchInput_onPropertyChange(evt);
            }
        });
        this.tblSearchInput.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                MapContextSearchPanel.this.tblSearchInput_onKeyTyped(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.tblSearchInput);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 3, 3, 3);
        this.pnlSearch.add((Component)this.jScrollPane1, gridBagConstraints);
        this.butNewSearch.setText("Neue Suche");
        this.butNewSearch.setPreferredSize(new Dimension(100, 23));
        this.butNewSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MapContextSearchPanel.this.butNewSearch_onActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.butNewSearch);
        this.butSearch.setFont(this.butSearch.getFont().deriveFont(this.butSearch.getFont().getStyle() | 1));
        this.butSearch.setText("Suchen");
        this.butSearch.setPreferredSize(new Dimension(100, 23));
        this.butSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MapContextSearchPanel.this.butSearch_onActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.butSearch);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlSearch.add((Component)this.jPanel1, gridBagConstraints);
        this.jSplitPane1.setTopComponent(this.pnlSearch);
        this.pnlResult.setBorder(BorderFactory.createTitledBorder("Ergebnis"));
        this.pnlResult.setMinimumSize(new Dimension(200, 70));
        this.pnlResult.setLayout(new GridBagLayout());
        this.treeResult.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                MapContextSearchPanel.this.treeResult_onMousePressed(evt);
            }
        });
        this.treeResult.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                MapContextSearchPanel.this.treeResult_onKeyTyped(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.treeResult);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlResult.add((Component)this.jScrollPane2, gridBagConstraints);
        this.jSplitPane1.setRightComponent(this.pnlResult);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jSplitPane1, gridBagConstraints);
    }

    private void butNewSearch_onActionPerformed(ActionEvent evt) {
        this.emptyCurrentSearch();
    }

    private void tblSearchInput_onMouseClicked(MouseEvent evt) {
        int intRow = this.tblSearchInput.getSelectedRow();
        this.selectRowInSearchInput(intRow);
    }

    private void selectRowInSearchInput(int intRow) {
        this.tblSearchInput.setRowSelectionInterval(intRow, intRow);
        this.tblSearchInput.setColumnSelectionInterval(1, 1);
        this.tblSearchInput.editCellAt(intRow, 1);
        ((RootSearchTableEditor)this.tblSearchInput.getColumnModel().getColumn(1).getCellEditor()).requestFocus();
    }

    private void tblSearchInput_onKeyTyped(KeyEvent evt) {
        this.tblSearchInput_onMouseClicked(null);
    }

    private void treeResult_onKeyTyped(KeyEvent evt) {
    }

    private void butSearch_onActionPerformed(ActionEvent evt) {
        this.search();
    }

    private void cmbSearch_onActionPerformed(ActionEvent evt) {
        if (this.blockEvents) {
            return;
        }
        this.setSearch((RootSearchModel)this.cmbSearch.getSelectedItem());
    }

    private void tblSearchInput_onPropertyChange(PropertyChangeEvent evt) {
        if (this.currentSearch != null && this.currentSearch.getBshSearchTable() != null && this.currentSearch.getBshSearchTable().length() > 0) {
            Interpreter bshInt = new Interpreter();
            try {
                bshInt.eval("import de.riwagis.geotools.search.model.*;");
                bshInt.set("search", (Object)this.currentSearch);
                bshInt.set("searchTable", (Object)this.tblSearchInput);
                bshInt.set("evt", (Object)evt);
                bshInt.eval(this.currentSearch.getBshSearchTable());
            }
            catch (Exception e) {
                GUISupport.msgbox((Component)this, (String)("<html>Error in search programming: " + e.getMessage() + "</html>"), (String)I18N.get("common.error"));
            }
        }
    }

    private void treeResult_onMousePressed(MouseEvent evt) {
        TreePath[] arrPath = this.treeResult.getSelectionPaths();
        if (arrPath == null || arrPath.length == 0) {
            return;
        }
        TreePath selpath = arrPath[0];
        if (selpath == null) {
            return;
        }
        Object selection = selpath.getLastPathComponent();
        TreePath pathClicked = this.treeResult.getClosestPathForLocation(evt.getX(), evt.getY());
        if (pathClicked == null) {
            return;
        }
        Object clickedSelection = pathClicked.getLastPathComponent();
        if (selection.equals(clickedSelection)) {
            this.zoom();
        }
    }
}

