/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.search.gui;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import de.riwagis.gis.context.map.MapContext;
import de.riwagis.riwajump.data.model.DMDCollection;
import de.riwagis.riwajump.model.search.SearchCollectionModel;
import de.riwagis.riwajump.search.gui.MapContextSearchPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;

public class MapContextSearchDialog
extends JDialog {
    public static final String CONTEXT_SEARCH_LOCATION = "CONTEXT_SEARCH_LOCATION";
    private static final String CONTEXT_SEARCH_DIM = "CONTEXT_SEARCH_DIM";
    private static final Dimension DEFAULT_DIM = new Dimension(410, 760);
    private JButton butClose;
    private MapContextSearchPanel pnlSearch;

    public MapContextSearchDialog(Frame parent, MapContext _ctxMap, SearchCollectionModel _lstRootSearch, DMDCollection _dmdCol) {
        super(parent, false);
        this.initComponents();
        this.i18n();
        Dimension prevDialogSize = (Dimension)PersistentBlackboardPlugIn.get().get(CONTEXT_SEARCH_DIM, DEFAULT_DIM);
        this.setSize(prevDialogSize);
        this.addPropertyChangeListener("graphicsConfiguration", evt -> this.ensureFrameIsVisible());
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                MapContextSearchDialog.this.persistDimensionAndLocation();
                MapContextSearchDialog.this.setVisible(false);
            }
        });
        this.setSearches(_ctxMap, _lstRootSearch, _dmdCol);
    }

    public final void setSearches(MapContext _ctxMap, SearchCollectionModel _lstRootSearch, DMDCollection _dmdCol) {
        this.pnlSearch.setSearches(_ctxMap, _lstRootSearch, _dmdCol);
    }

    public SearchCollectionModel getActiveSearchCollection() {
        return this.pnlSearch.getActiveSearchCollection();
    }

    private void i18n() {
        this.setTitle(I18N.get("de.riwagis.riwajump.MapContextSearchDialog.title"));
        this.butClose.setText(I18N.get("common.close"));
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
        if (b) {
            this.ensureFrameIsVisible();
        }
    }

    private void initComponents() {
        this.pnlSearch = new MapContextSearchPanel();
        this.butClose = new JButton();
        this.setMinimumSize(new Dimension(134, 430));
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.pnlSearch, gridBagConstraints);
        this.butClose.setText("schlie\u00dfen");
        this.butClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MapContextSearchDialog.this.butClose_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 9, 3);
        this.getContentPane().add((Component)this.butClose, gridBagConstraints);
        this.pack();
    }

    private void butClose_onActionPerformed(ActionEvent evt) {
        this.persistDimensionAndLocation();
        this.setVisible(false);
    }

    private void persistDimensionAndLocation() {
        Dimension dim = this.getSize() != null ? this.getSize() : DEFAULT_DIM;
        PersistentBlackboardPlugIn.get().put(CONTEXT_SEARCH_DIM, dim);
        if (this.getLocation() != null) {
            PersistentBlackboardPlugIn.get().put(CONTEXT_SEARCH_LOCATION, this.getLocation());
        }
        if (this.pnlSearch != null) {
            PersistentBlackboardPlugIn.get().put("CONTEXT_SEARCH_DIV_LOCATION", this.pnlSearch.getDividerLocation());
        }
    }

    private void ensureFrameIsVisible() {
        SwingUtilities.invokeLater(() -> {
            GraphicsConfiguration graphicsConfiguration = this.getGraphicsConfiguration();
            Rectangle bounds = graphicsConfiguration.getBounds();
            Dimension dimWMFrame = this.getSize();
            dimWMFrame.setSize(Math.min(bounds.getWidth(), dimWMFrame.getWidth()), Math.min(bounds.getHeight(), dimWMFrame.getHeight()));
            this.setSize(dimWMFrame);
            Point ptWMFrame = this.evaluateFrameStartPositionBasedOnScreens(graphicsConfiguration);
            this.setLocation(ptWMFrame);
        });
    }

    private Point evaluateFrameStartPositionBasedOnScreens(GraphicsConfiguration deviceConfiguration) {
        Point location = this.getLocation();
        Rectangle screenBounds = deviceConfiguration.getBounds();
        int delta = 50;
        Rectangle biggerScreenBounds = new Rectangle(screenBounds.x, screenBounds.y, screenBounds.width - delta, screenBounds.height - delta);
        if (!biggerScreenBounds.contains(location)) {
            location = new Point(0, 0);
        }
        return location;
    }
}

