/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.reduction;

import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Task;
import de.riwagis.crs.CRSDefinition;
import de.riwagis.unit.DrawingUnit;
import java.util.function.Supplier;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;

public class ProjectionReduction {
    private static final ProjectionReduction INSTANCE = new ProjectionReduction(WorkbenchContext::getTask);
    private final Supplier<Task> taskSupplier;

    public ProjectionReduction(Supplier<Task> taskSupplier) {
        this.taskSupplier = taskSupplier;
    }

    public double calculateRealWorldArea(Geometry geom) {
        double area = geom.getArea();
        Task task = this.taskSupplier.get();
        if (!task.isProjectionReductionActive()) {
            return area;
        }
        CRSDefinition crsDef = task.getCRSDefinition();
        DrawingUnit unit = task.getDrawingUnit();
        Point p = geom.getCentroid();
        Coordinate centerCoord = new Coordinate(p.getX(), p.getY());
        double height = task.getHeightReduction();
        return crsDef.getRealWorldArea(area, height, centerCoord, unit);
    }

    public double calculateRealWorldLength(Geometry geom) {
        double length = geom.getLength();
        Task task = this.taskSupplier.get();
        if (!task.isProjectionReductionActive()) {
            return length;
        }
        CRSDefinition crsDef = task.getCRSDefinition();
        DrawingUnit unit = task.getDrawingUnit();
        Point p = geom.getCentroid();
        Coordinate centerCoord = new Coordinate(p.getX(), p.getY());
        double height = task.getHeightReduction();
        return crsDef.getRealWorldDistance(length, height, centerCoord, unit);
    }

    public static ProjectionReduction getInstance() {
        return INSTANCE;
    }
}

