/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.feature.util;

import de.riwagis.geotools.feature.CollectionFeatureIterator;
import de.riwagis.geotools.feature.util.FilterUtil;
import de.riwagis.riwajump.data.model.DMDCollection;
import de.riwagis.riwajump.data.model.FeaturestoreMetadata;
import de.riwagis.riwajump.feature.util.SourceTargetResult;
import de.riwagis.util.jts.JTSSupport;
import de.riwagis.util.thread.Cancelable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.geotools.data.FeatureReader;
import org.geotools.feature.FeatureIterator;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.TopologyException;
import org.locationtech.jts.index.strtree.STRtree;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.IncludeFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpatialUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SpatialUtil.class);
    public static final int INTERSECT = 0;
    public static final int CONTAINS = 1;
    public static final int EQUALS = 2;
    public static final int DISJOINT = 3;

    public static Envelope[] tileEnvelope(Envelope env, double dblMaxSize) {
        double minY;
        double minX;
        int intFullWidth = (int)(env.getWidth() / dblMaxSize);
        int intFullHeight = (int)(env.getHeight() / dblMaxSize);
        double dblRestWidth = env.getWidth() % dblMaxSize;
        double dblRestHeight = env.getHeight() % dblMaxSize;
        Envelope[] arrEnv = new Envelope[(intFullWidth + 1) * (intFullHeight + 1)];
        int counter = 0;
        for (int i = 0; i < intFullWidth; ++i) {
            for (int j = 0; j < intFullHeight; ++j) {
                double minX2 = env.getMinX() + (double)i * dblMaxSize;
                double minY2 = env.getMinY() + (double)j * dblMaxSize;
                arrEnv[counter] = new Envelope(minX2, minX2 + dblMaxSize, minY2, minY2 + dblMaxSize);
                ++counter;
            }
            minX = env.getMinX() + (double)i * dblMaxSize;
            minY = env.getMinY() + (double)intFullHeight * dblMaxSize;
            arrEnv[counter] = new Envelope(minX, minX + dblMaxSize, minY, minY + dblRestHeight);
            ++counter;
        }
        for (int j = 0; j < intFullHeight; ++j) {
            minX = env.getMinX() + (double)intFullWidth * dblMaxSize;
            minY = env.getMinY() + (double)j * dblMaxSize;
            arrEnv[counter] = new Envelope(minX, minX + dblRestWidth, minY, minY + dblMaxSize);
            ++counter;
        }
        double minX3 = env.getMinX() + (double)intFullWidth * dblMaxSize;
        double minY3 = env.getMinY() + (double)intFullHeight * dblMaxSize;
        arrEnv[counter] = new Envelope(minX3, minX3 + dblRestWidth, minY3, minY3 + dblRestHeight);
        return arrEnv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<SourceTargetResult> executeSpatialOperation(Collection<SimpleFeature> lstSourceFeatures, DMDCollection dmdCol, FeaturestoreMetadata fmdTarget, Filter filtTarget, double dblMaxEnvSize, int intMethod, double dblMinAreaOnIntersect, boolean bolTouchOnIntersect, Cancelable canceledIndicator) throws Exception {
        Envelope envSource = new Envelope();
        for (SimpleFeature feat : lstSourceFeatures) {
            Geometry geom = (Geometry)feat.getDefaultGeometry();
            if (geom == null || geom.isEmpty()) continue;
            envSource.expandToInclude(geom.getEnvelopeInternal());
        }
        IncludeFilter effectiveFilter = filtTarget == null ? Filter.INCLUDE : filtTarget;
        Envelope[] arrSrcEnv = SpatialUtil.tileEnvelope(envSource, dblMaxEnvSize);
        HashMap<SimpleFeature, Collection<SimpleFeature>> mapSourceTargetResult = new HashMap<SimpleFeature, Collection<SimpleFeature>>();
        HashMap<SimpleFeature, Collection<String>> mapSourceTargetFID = new HashMap<SimpleFeature, Collection<String>>();
        if (intMethod == 0 || intMethod == 2 || intMethod == 1) {
            for (Envelope arrSrcEnv1 : arrSrcEnv) {
                if (canceledIndicator.isCanceled()) {
                    throw new InterruptedException();
                }
                STRtree featTargetIndex = new STRtree();
                Filter filtEnv = FilterUtil.getEnvelopeFilter((Envelope)arrSrcEnv1, (SimpleFeatureType)fmdTarget.getSchema(dmdCol));
                Filter filt = FilterUtil.getAndFilter((Filter)filtEnv, (Filter)effectiveFilter);
                try (FeatureReader<SimpleFeatureType, SimpleFeature> frTarget = fmdTarget.getFeatureReader(dmdCol, filt);){
                    while (frTarget.hasNext()) {
                        if (canceledIndicator.isCanceled()) {
                            throw new InterruptedException();
                        }
                        SimpleFeature feat = (SimpleFeature)frTarget.next();
                        Geometry geometry = (Geometry)feat.getDefaultGeometry();
                        if (geometry == null) continue;
                        featTargetIndex.insert(geometry.getEnvelopeInternal(), (Object)feat);
                    }
                }
                featTargetIndex.build();
                for (SimpleFeature feat : lstSourceFeatures) {
                    Geometry[] arrGeom;
                    if (canceledIndicator.isCanceled()) {
                        throw new InterruptedException();
                    }
                    Collection<SimpleFeature> lstResult = SpatialUtil.getList4SourceFeature(feat, mapSourceTargetResult);
                    Collection<String> setFID = SpatialUtil.getFIDList4SourceFeature(feat, mapSourceTargetFID);
                    Geometry fgeom = (Geometry)feat.getDefaultGeometry();
                    if (fgeom == null || fgeom.isEmpty()) continue;
                    for (Geometry geom : arrGeom = JTSSupport.getGeometries((Geometry)fgeom)) {
                        block13: for (SimpleFeature featCandidate : featTargetIndex.query(geom.getEnvelopeInternal())) {
                            Geometry[] arrCandGeom;
                            for (Geometry arrCandGeom1 : arrCandGeom = JTSSupport.getGeometries((Geometry)((Geometry)featCandidate.getDefaultGeometry()))) {
                                boolean bolFound = false;
                                switch (intMethod) {
                                    case 0: {
                                        if (!geom.intersects(arrCandGeom1) || !bolTouchOnIntersect && geom.touches(arrCandGeom1) || dblMinAreaOnIntersect != 0.0 && !(SpatialUtil.getIntersectionArea(geom, arrCandGeom1) >= dblMinAreaOnIntersect)) break;
                                        if (!setFID.contains(featCandidate.getID())) {
                                            lstResult.add(featCandidate);
                                            setFID.add(featCandidate.getID());
                                        }
                                        bolFound = true;
                                        break;
                                    }
                                    case 2: {
                                        if (!geom.equals(arrCandGeom1)) break;
                                        if (!setFID.contains(featCandidate.getID())) {
                                            lstResult.add(featCandidate);
                                            setFID.add(featCandidate.getID());
                                        }
                                        bolFound = true;
                                        break;
                                    }
                                    case 1: {
                                        if (!geom.contains(arrCandGeom1)) break;
                                        if (!setFID.contains(featCandidate.getID())) {
                                            lstResult.add(featCandidate);
                                            setFID.add(featCandidate.getID());
                                        }
                                        bolFound = true;
                                        break;
                                    }
                                    default: {
                                        throw new UnsupportedOperationException("invalid spatial operation");
                                    }
                                }
                                if (bolFound) continue block13;
                            }
                        }
                    }
                }
            }
            ArrayList<SourceTargetResult> lstSourceTargetResult = new ArrayList<SourceTargetResult>();
            for (Map.Entry me : mapSourceTargetResult.entrySet()) {
                if (((Collection)me.getValue()).isEmpty()) continue;
                SourceTargetResult sTR = new SourceTargetResult((SimpleFeature)me.getKey(), (Collection)me.getValue());
                lstSourceTargetResult.add(sTR);
            }
            return lstSourceTargetResult;
        }
        if (intMethod == 3) {
            throw new UnsupportedOperationException("DISJOINT ist not supported yet");
        }
        throw new UnsupportedOperationException(intMethod + " is and invalid spatial operation");
    }

    public static double getIntersectionArea(Geometry geom1, Geometry geom2) {
        if (geom1 != null && geom2 != null) {
            try {
                return geom1.intersection(geom2).getArea();
            }
            catch (TopologyException e) {
                log.warn(String.format("error intersecting geometries: %s", e.getMessage()), (Throwable)e);
            }
        }
        return 0.0;
    }

    private static Collection<SimpleFeature> getList4SourceFeature(SimpleFeature sourceFeat, Map<SimpleFeature, Collection<SimpleFeature>> mapSourceTarget) {
        if (mapSourceTarget.containsKey(sourceFeat)) {
            return mapSourceTarget.get(sourceFeat);
        }
        ArrayList<SimpleFeature> lstTarget = new ArrayList<SimpleFeature>();
        mapSourceTarget.put(sourceFeat, lstTarget);
        return lstTarget;
    }

    private static Collection<String> getFIDList4SourceFeature(SimpleFeature sourceFeat, Map<SimpleFeature, Collection<String>> mapSourceTargetFID) {
        if (mapSourceTargetFID.containsKey(sourceFeat)) {
            return mapSourceTargetFID.get(sourceFeat);
        }
        HashSet<String> setFID = new HashSet<String>();
        mapSourceTargetFID.put(sourceFeat, setFID);
        return setFID;
    }

    public static FeatureIterator<SimpleFeature> getUniqueTargetFeatureIterator(Collection<SourceTargetResult> lstResult) {
        HashSet<String> setTargetFID = new HashSet<String>();
        ArrayList<SimpleFeature> lstFeatureResult = new ArrayList<SimpleFeature>();
        for (SourceTargetResult sTR : lstResult) {
            Collection<SimpleFeature> lstSTR = sTR.getResult();
            for (SimpleFeature feat : lstSTR) {
                if (setTargetFID.contains(feat.getID())) continue;
                setTargetFID.add(feat.getID());
                lstFeatureResult.add(feat);
            }
        }
        return new CollectionFeatureIterator(lstFeatureResult);
    }
}

