/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.feature;

import de.riwagis.geotools.feature.util.FeatureUtil;
import de.riwagis.riwajump.data.model.FeaturestoreMetadata;
import java.util.Collection;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.geotools.feature.FeatureIterator;
import org.opengis.feature.simple.SimpleFeature;

public class WhiteListFeatureIterator
implements FeatureIterator<SimpleFeature> {
    private final FeatureIterator<SimpleFeature> fi;
    private final Collection<String> whiteList;
    private final String whiteListKeyAtt;
    private boolean nextCalled = false;
    private boolean hasNext = true;
    private SimpleFeature nextFeature = null;

    public WhiteListFeatureIterator(FeatureIterator<SimpleFeature> fi, Collection<String> whiteList, FeaturestoreMetadata fmd) {
        this(fi, whiteList, WhiteListFeatureIterator.getWhiteListAttribute(fmd));
    }

    public WhiteListFeatureIterator(FeatureIterator<SimpleFeature> fi, Collection<String> whiteList, String whiteListKeyAtt) {
        this.fi = fi;
        this.whiteList = whiteList;
        this.whiteListKeyAtt = whiteListKeyAtt;
    }

    public boolean hasNext() {
        if (this.nextCalled) {
            return this.hasNext;
        }
        this.nextCalled = true;
        this.hasNext = false;
        while (this.fi.hasNext()) {
            SimpleFeature tmpFeat = (SimpleFeature)this.fi.next();
            if (this.whiteList.contains(this.retrieveAtt(tmpFeat))) {
                this.nextFeature = tmpFeat;
                this.hasNext = true;
                break;
            }
            this.nextFeature = null;
            this.hasNext = false;
        }
        return this.hasNext;
    }

    public SimpleFeature next() {
        if (!this.nextCalled) {
            this.hasNext();
        }
        this.nextCalled = false;
        return this.nextFeature;
    }

    public void close() {
        this.fi.close();
    }

    private String retrieveAtt(SimpleFeature feature) {
        return WhiteListFeatureIterator.extractKey(feature, this.whiteListKeyAtt);
    }

    public static String getWhiteListAttribute(FeaturestoreMetadata fmd) {
        return StringUtils.defaultString((String)fmd.getKeyAttView(), (String)fmd.getKeyAtt());
    }

    public static String extractKey(SimpleFeature feature, String whiteListKeyAtt) {
        if (whiteListKeyAtt == null) {
            return FeatureUtil.getFeatureIDWithoutTable((SimpleFeature)feature);
        }
        return Objects.toString(FeatureUtil.getAttribute((SimpleFeature)feature, (String)whiteListKeyAtt), null);
    }
}

