/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.feature;

import de.riwagis.riwajump.data.model.FeaturestoreMetadata;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.geotools.data.DataUtilities;
import org.geotools.filter.visitor.DuplicatingFilterVisitor;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.expression.PropertyName;

public class PropertyCaseResolvingVisitor
extends DuplicatingFilterVisitor {
    private final Map<String, String> fmdAttributeCaseMap;
    private final Set<String> fmdAttributes;

    public PropertyCaseResolvingVisitor(Set<String> fmdAttributes) {
        this.fmdAttributes = fmdAttributes;
        this.fmdAttributeCaseMap = fmdAttributes.stream().collect(Collectors.toMap(s -> s.toLowerCase(), s -> s));
    }

    public Object visit(PropertyName expression, Object extraData) {
        String propertyName = expression.getPropertyName();
        if (StringUtils.isBlank((CharSequence)propertyName)) {
            return super.visit(expression, extraData);
        }
        if (!this.fmdAttributes.contains(propertyName)) {
            String caseMatchingName = this.fmdAttributeCaseMap.get(propertyName.toLowerCase());
            if (caseMatchingName == null) {
                return super.visit(expression, extraData);
            }
            return this.getFactory(extraData).property(caseMatchingName);
        }
        return super.visit(expression, extraData);
    }

    public static Filter ignoreCaseOfProperties(Filter filter, FeaturestoreMetadata fmd) {
        Set<String> fmdAttributes = Set.of(fmd.getAttributes());
        return PropertyCaseResolvingVisitor.getFilter(filter, fmdAttributes, false);
    }

    public static Filter ignoreCaseOfPropertiesAndFailOnMissing(Filter filter, SimpleFeatureType sft) {
        Set<String> sftAttributes = sft.getAttributeDescriptors().stream().map(n -> n.getLocalName()).collect(Collectors.toSet());
        return PropertyCaseResolvingVisitor.getFilter(filter, sftAttributes, true);
    }

    private static Filter getFilter(Filter filter, Set<String> attributes, boolean failOnMissingAttributes) {
        if (filter == null || filter == Filter.INCLUDE) {
            return filter;
        }
        Set<String> filterAttributes = Set.of(DataUtilities.attributeNames((Filter)filter));
        if (PropertyCaseResolvingVisitor.schemaCanValidateFilter(attributes, filterAttributes, Function.identity())) {
            return filter;
        }
        if (PropertyCaseResolvingVisitor.schemaCanValidateFilter(attributes, filterAttributes, String::toLowerCase)) {
            return (Filter)filter.accept((FilterVisitor)new PropertyCaseResolvingVisitor(attributes), null);
        }
        if (failOnMissingAttributes) {
            Set<String> schemaAttributes = PropertyCaseResolvingVisitor.buildAttributeSet(attributes, String::toLowerCase);
            List<String> missingAttributes = filterAttributes.stream().map(String::toLowerCase).filter(at -> !schemaAttributes.contains(at)).toList();
            throw new IllegalArgumentException("The schema does not contain the attributes: %s".formatted(String.join((CharSequence)", ", missingAttributes)));
        }
        return Filter.INCLUDE;
    }

    private static boolean schemaCanValidateFilter(Set<String> fmdAttributes, Set<String> filterAttributes, Function<String, String> mapFunction) {
        Set<String> schemaAttributes = PropertyCaseResolvingVisitor.buildAttributeSet(fmdAttributes, mapFunction);
        return filterAttributes.stream().map(mapFunction).allMatch(schemaAttributes::contains);
    }

    private static Set<String> buildAttributeSet(Set<String> fmdAttributes, Function<String, String> mapFunction) {
        return fmdAttributes.stream().map(mapFunction).collect(Collectors.toSet());
    }
}

