/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.data.model.datalocation.raster;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.vividsolutions.jump.I18N;
import de.riwagis.crs.CRSDefFactory;
import de.riwagis.riwajump.data.model.datalocation.AbstractDataLocation;
import de.riwagis.riwajump.data.model.datalocation.DataLocation;
import de.riwagis.riwajump.data.model.datalocation.DataLocationType;
import de.riwagis.riwajump.data.model.datalocation.FileParameterDescriptor;
import de.riwagis.riwajump.data.model.datalocation.ParameterDescriptor;
import de.riwagis.riwajump.data.model.datalocation.StringParameterDescriptor;
import de.riwagis.riwajump.data.model.datalocation.raster.RasterDataLocationSupport;
import de.riwagis.util.exception.SystemException;
import java.io.File;
import java.util.Arrays;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.gce.imagemosaic.ImageMosaicFormat;
import org.geotools.referencing.CRS;
import org.geotools.util.factory.Hints;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XStreamAlias(value="DLOCshapeindex")
public class ShapeIndexedRasterDataLocation
extends AbstractDataLocation {
    private static final Logger LOG = LoggerFactory.getLogger(ShapeIndexedRasterDataLocation.class);
    public static final String PARAM_LOCATION = "Shape file";
    public static final String PARAM_LOCATION_RELATIVE = "Shape file relative";
    private static final ParameterDescriptor[] PARAMS = new ParameterDescriptor[]{new FileParameterDescriptor("Shape file", I18N.get("de.riwagis.riwajump.datalocation.raster.ShapeIndexedRasterDataLocation.shp-file-param"), I18N.get("de.riwagis.riwajump.datalocation.raster.ShapeIndexedRasterDataLocation.shp-file-param-desc"), true, new String[]{"shp"}), new StringParameterDescriptor("Shape file relative", I18N.get("de.riwagis.riwajump.datalocation.raster.ShapeIndexedRasterDataLocation.shp-filerel-param"), I18N.get("de.riwagis.riwajump.datalocation.raster.ShapeIndexedRasterDataLocation.shp-filerel-param-desc"), true)};

    @Override
    public ParameterDescriptor[] getParameterDescription() {
        return Arrays.copyOf(PARAMS, PARAMS.length);
    }

    @Override
    public Object getDataLocationObject() throws Exception {
        File dataLocationFile = this.determineDataLocationFile(PARAM_LOCATION, PARAM_LOCATION_RELATIVE);
        if (dataLocationFile == null || !dataLocationFile.exists()) {
            throw new SystemException(I18N.getMessage("de.riwagis.riwajump.datalocation.raster.ShapeIndexedRasterDataLocation.does-not-exist", this.getParameterValue(PARAM_LOCATION)));
        }
        Hints hint = new Hints();
        hint.put((Object)Hints.CRS_AUTHORITY_FACTORY, (Object)CRSDefFactory.getCRSAuthorityFactory());
        hint.put((Object)Hints.CRS_FACTORY, (Object)CRSDefFactory.getCRSFactory());
        hint.put((Object)Hints.DEFAULT_COORDINATE_REFERENCE_SYSTEM, (Object)CRS.decode((String)"EPSG:25832"));
        ImageMosaicFormat imageFormat = new ImageMosaicFormat();
        AbstractGridCoverage2DReader gcread = imageFormat.getReader((Object)dataLocationFile, hint);
        return gcread;
    }

    @Override
    public String testConnection() {
        try {
            String strPCheck = this.onlyOneOfTwoParametersCheck(PARAM_LOCATION, PARAM_LOCATION_RELATIVE);
            if (strPCheck != null) {
                return strPCheck;
            }
            File dataLocationFile = this.determineDataLocationFile(PARAM_LOCATION, PARAM_LOCATION_RELATIVE);
            if (dataLocationFile == null || !dataLocationFile.exists()) {
                return I18N.getMessage("de.riwagis.riwajump.datalocation.raster.ShapeIndexedRasterDataLocation.does-not-exist", this.getParameterValue(PARAM_LOCATION));
            }
            AbstractGridCoverage2DReader gcread = (AbstractGridCoverage2DReader)this.getDataLocationObject();
            RasterDataLocationSupport.testGridCoverageReader((GridCoverage2DReader)gcread);
            gcread.dispose();
        }
        catch (Throwable t) {
            LOG.warn(String.format("Connection test - error loading raster: %s", t.getMessage()), t);
            return String.format("Error loading raster: %s", t.getMessage());
        }
        return null;
    }

    @Override
    public DataLocationType getDataLocationType() {
        return DataLocationType.SHAPEINDEXEDRASTER;
    }

    @Override
    public DataLocation.DataType getDataType() {
        return DataLocation.DataType.RASTER;
    }
}

