/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.data.model.datalocation.raster;

import it.geosolutions.rendered.viewer.RenderedImageBrowser;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import javax.media.jai.Interpolation;
import javax.media.jai.PlanarImage;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.coverage.processing.CoverageProcessingException;
import org.geotools.coverage.processing.Operations;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.image.util.ImageUtilities;
import org.opengis.coverage.Coverage;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.geometry.Envelope;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterValue;

public class RasterDataLocationSupport {
    private static final Interpolation DEFAULT_INTERPOLATION = Interpolation.getInstance((int)1);
    private static boolean debugEnabled = false;

    public static void testGridCoverageReader(GridCoverage2DReader gcread) throws Exception {
        GeneralEnvelope oriEnv = gcread.getOriginalEnvelope();
        Dimension pixelSize = new Dimension(100, 100);
        ReferencedEnvelope env = new ReferencedEnvelope(oriEnv.getMedian().getCoordinate()[0] - 1.0, oriEnv.getMedian().getCoordinate()[0] + 1.0, oriEnv.getMedian().getCoordinate()[1] - 1.0, oriEnv.getMedian().getCoordinate()[1] + 1.0, gcread.getCoordinateReferenceSystem());
        GridCoverage2D gc = RasterDataLocationSupport.determineGridCoverage2D(gcread, env, pixelSize);
        RenderedImage ri = gc.getRenderedImage();
        if (ri instanceof PlanarImage) {
            ImageUtilities.disposePlanarImageChain((PlanarImage)((PlanarImage)ri));
        }
        gc.dispose(true);
    }

    private static int scale(double scale, int size) {
        return (int)Math.round((double)size * scale);
    }

    public static BufferedImage getImageFromGCReader(GridCoverage2DReader gcread, ReferencedEnvelope env, AffineTransform modelToViewTransform, Dimension sizeInDisplayUnits, double pixelScale) throws IOException {
        Dimension pixelSize = new Dimension(RasterDataLocationSupport.scale(pixelScale, sizeInDisplayUnits.width), RasterDataLocationSupport.scale(pixelScale, sizeInDisplayUnits.height));
        GridCoverage2D gc = RasterDataLocationSupport.determineGridCoverage2D(gcread, env, pixelSize);
        if (gc == null) {
            return RasterDataLocationSupport.createBufferedImage(pixelSize);
        }
        GridCoverage2D scaled = RasterDataLocationSupport.determineScaledGridCoverage2D(gc, env, pixelSize);
        AffineTransform crsProjection = (AffineTransform)scaled.getGridGeometry().getGridToCRS();
        AffineTransform displayScale = AffineTransform.getScaleInstance(pixelScale, pixelScale);
        AffineTransform transformation = new AffineTransform(displayScale);
        transformation.concatenate(modelToViewTransform);
        transformation.concatenate(crsProjection);
        return RasterDataLocationSupport.renderToBufferedImage(scaled, transformation, pixelSize, gc);
    }

    public static GridCoverage2D determineScaledGridCoverage2D(GridCoverage2D gc, ReferencedEnvelope env, Dimension pixelSize) throws CoverageProcessingException, IndexOutOfBoundsException {
        Envelope gcenv = gc.getEnvelope();
        GridEnvelope2D gr = gc.getGridGeometry().getGridRange2D();
        double resolutionX = gcenv.getSpan(0) / (double)gr.width;
        double resolutionY = gcenv.getSpan(1) / (double)gr.height;
        double resolutionViewX = env.getSpan(0) / pixelSize.getWidth();
        double resolutionViewY = env.getSpan(1) / pixelSize.getHeight();
        double scaleX = resolutionX / resolutionViewX;
        double scaleY = resolutionY / resolutionViewY;
        GridCoverage2D coverage = gc;
        coverage = (GridCoverage2D)Operations.DEFAULT.crop((Coverage)coverage, (Envelope)env);
        double scale = Math.max(scaleX, scaleY);
        double numBisections = Math.max(0.0, Math.floor(Math.log(1.0 / scale) / Math.log(2.0)));
        if (numBisections > 0.0) {
            double expFactor = Math.pow(2.0, numBisections);
            scaleX *= expFactor;
            scaleY *= expFactor;
            coverage = (GridCoverage2D)Operations.DEFAULT.subsampleAverage((GridCoverage)coverage, 1.0 / expFactor, 1.0 / expFactor);
        }
        coverage = (GridCoverage2D)Operations.DEFAULT.scale((GridCoverage)coverage, scaleX, scaleY, 0.0, 0.0, DEFAULT_INTERPOLATION);
        return coverage;
    }

    public static GridCoverage2D determineGridCoverage2D(GridCoverage2DReader gcread, ReferencedEnvelope env, Dimension pixelSize) throws IOException {
        if (!gcread.getOriginalEnvelope().intersects((Envelope)env, false)) {
            return null;
        }
        GridEnvelope2D gridEnvelope = new GridEnvelope2D(0, 0, pixelSize.width * 2, pixelSize.height * 2);
        ParameterValue envelopeParam = AbstractGridFormat.READ_GRIDGEOMETRY2D.createValue();
        envelopeParam.setValue((Object)new GridGeometry2D((GridEnvelope)gridEnvelope, (Envelope)env));
        GeneralParameterValue[] readParams = new GeneralParameterValue[]{envelopeParam};
        return gcread.read(readParams);
    }

    public static boolean isDebugEnabled() {
        return debugEnabled;
    }

    public static void setDebugEnabled(boolean debugEnabled) {
        RasterDataLocationSupport.debugEnabled = debugEnabled;
    }

    private static BufferedImage createBufferedImage(Dimension pixelSize) {
        return new BufferedImage(pixelSize.width, pixelSize.height, 2);
    }

    private static BufferedImage renderToBufferedImage(GridCoverage2D coverage, AffineTransform transformation, Dimension imageSize, GridCoverage2D rootCoverage) {
        BufferedImage bimg = RasterDataLocationSupport.createBufferedImage(imageSize);
        RenderedImage ri = coverage.getRenderedImage();
        if (debugEnabled) {
            RenderedImageBrowser.showChainAndWaitOnClose((RenderedImage)ri);
        }
        Graphics2D g2d = (Graphics2D)bimg.getGraphics();
        g2d.drawRenderedImage(ri, transformation);
        if (ri instanceof PlanarImage) {
            ImageUtilities.disposePlanarImageChain((PlanarImage)((PlanarImage)ri));
        }
        rootCoverage.dispose(true);
        return bimg;
    }

    private RasterDataLocationSupport() {
    }
}

